/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.recovery;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HeartbeatManagerOptions;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.NettyShuffleEnvironmentOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.RestartStrategyOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.core.testutils.EachCallbackWrapper;
import org.apache.flink.runtime.entrypoint.StandaloneSessionClusterEntrypoint;
import org.apache.flink.runtime.testutils.CommonTestUtils;
import org.apache.flink.runtime.util.BlobServerExtension;
import org.apache.flink.runtime.zookeeper.ZooKeeperExtension;
import org.apache.flink.test.recovery.utils.TaskExecutorProcessEntryPoint;
import org.apache.flink.test.util.TestProcessBuilder;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.io.TempDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractTaskManagerProcessFailureRecoveryTest {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTaskManagerProcessFailureRecoveryTest.class);
    protected static final String READY_MARKER_FILE_PREFIX = "ready_";
    protected static final String PROCEED_MARKER_FILE = "proceed";
    protected static final int PARALLELISM = 4;
    @TempDir
    public Path temporaryFolder;
    @RegisterExtension
    public final EachCallbackWrapper<BlobServerExtension> blobServerExtensionWrapper = new EachCallbackWrapper((CustomExtension)new BlobServerExtension());
    @RegisterExtension
    public final EachCallbackWrapper<ZooKeeperExtension> zooKeeperExtensionWrapper = new EachCallbackWrapper((CustomExtension)new ZooKeeperExtension());

    AbstractTaskManagerProcessFailureRecoveryTest() {
    }

    @TestTemplate
    void testTaskManagerProcessFailure() throws Exception {
        block26: {
            TestProcessBuilder.TestProcess taskManagerProcess3;
            TestProcessBuilder.TestProcess taskManagerProcess2;
            TestProcessBuilder.TestProcess taskManagerProcess1;
            block25: {
                taskManagerProcess1 = null;
                taskManagerProcess2 = null;
                taskManagerProcess3 = null;
                final Configuration config = new Configuration();
                config.set(JobManagerOptions.ADDRESS, (Object)"localhost");
                config.set(RestOptions.BIND_PORT, (Object)"0");
                config.set(HeartbeatManagerOptions.HEARTBEAT_INTERVAL, (Object)Duration.ofMillis(200L));
                config.set(HeartbeatManagerOptions.HEARTBEAT_TIMEOUT, (Object)Duration.ofMillis(10000L));
                config.set(HeartbeatManagerOptions.HEARTBEAT_RPC_FAILURE_THRESHOLD, (Object)1);
                config.set(HighAvailabilityOptions.HA_MODE, (Object)"zookeeper");
                config.set(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, (Object)((ZooKeeperExtension)this.zooKeeperExtensionWrapper.getCustomExtension()).getConnectString());
                config.set(HighAvailabilityOptions.HA_STORAGE_PATH, (Object)TempDirUtils.newFolder((Path)this.temporaryFolder).getAbsolutePath());
                config.set(TaskManagerOptions.NUM_TASK_SLOTS, (Object)2);
                config.set(TaskManagerOptions.MANAGED_MEMORY_SIZE, (Object)MemorySize.parse((String)"4m"));
                config.set(TaskManagerOptions.NETWORK_MEMORY_MIN, (Object)MemorySize.parse((String)"3200k"));
                config.set(TaskManagerOptions.NETWORK_MEMORY_MAX, (Object)MemorySize.parse((String)"3200k"));
                config.set(NettyShuffleEnvironmentOptions.NETWORK_SORT_SHUFFLE_MIN_BUFFERS, (Object)16);
                config.set(TaskManagerOptions.TASK_HEAP_MEMORY, (Object)MemorySize.parse((String)"128m"));
                config.set(TaskManagerOptions.CPU_CORES, (Object)1.0);
                config.set(JobManagerOptions.EXECUTION_FAILOVER_STRATEGY, (Object)"full");
                config.set(JobManagerOptions.SCHEDULER_SUBMISSION_RESOURCE_WAIT_TIMEOUT, (Object)Duration.ofSeconds(30L));
                config.set(RestartStrategyOptions.RESTART_STRATEGY, (Object)"fixed-delay");
                config.set(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_ATTEMPTS, (Object)1);
                config.set(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_DELAY, (Object)Duration.ofMillis(5000L));
                try {
                    try (StandaloneSessionClusterEntrypoint clusterEntrypoint = new StandaloneSessionClusterEntrypoint(config);){
                        Throwable error;
                        String javaCommand = CommonTestUtils.getJavaCommandPath();
                        if (javaCommand == null) {
                            System.out.println("---- Skipping Process Failure test : Could not find java executable ----");
                            return;
                        }
                        clusterEntrypoint.startCluster();
                        File coordinateTempDir = TempDirUtils.newFolder((Path)this.temporaryFolder);
                        TestProcessBuilder taskManagerProcessBuilder = new TestProcessBuilder(TaskExecutorProcessEntryPoint.class.getName());
                        taskManagerProcessBuilder.addConfigAsMainClassArgs(config);
                        taskManagerProcess1 = taskManagerProcessBuilder.start();
                        taskManagerProcess2 = taskManagerProcessBuilder.start();
                        final File coordinateDirClosure = coordinateTempDir;
                        final AtomicReference errorRef = new AtomicReference();
                        Thread programTrigger = new Thread("Program Trigger"){

                            @Override
                            public void run() {
                                try {
                                    AbstractTaskManagerProcessFailureRecoveryTest.this.testTaskManagerFailure(config, coordinateDirClosure);
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                    errorRef.set(t);
                                }
                            }
                        };
                        programTrigger.start();
                        if (!AbstractTaskManagerProcessFailureRecoveryTest.waitForMarkerFiles(coordinateTempDir, READY_MARKER_FILE_PREFIX, 4, 120000L)) {
                            if (errorRef.get() != null) {
                                error = (Throwable)errorRef.get();
                                error.printStackTrace();
                                org.junit.jupiter.api.Assertions.fail((String)("The program encountered a " + error.getClass().getSimpleName() + " : " + error.getMessage()));
                            } else {
                                org.junit.jupiter.api.Assertions.fail((String)"The tasks were not started within time (120000ms)");
                            }
                        }
                        taskManagerProcess3 = taskManagerProcessBuilder.start();
                        taskManagerProcess1.destroy();
                        this.waitForShutdown("TaskManager 1", taskManagerProcess1);
                        AbstractTaskManagerProcessFailureRecoveryTest.touchFile(new File(coordinateTempDir, PROCEED_MARKER_FILE));
                        programTrigger.join(300000L);
                        ((AbstractBooleanAssert)Assertions.assertThat((boolean)programTrigger.isAlive()).withFailMessage("The program did not finish in time", new Object[0])).isFalse();
                        if (errorRef.get() != null) {
                            error = (Throwable)errorRef.get();
                            error.printStackTrace();
                            org.junit.jupiter.api.Assertions.fail((String)("The program encountered a " + error.getClass().getSimpleName() + " : " + error.getMessage()));
                        }
                    }
                    if (taskManagerProcess1 == null) break block25;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    AbstractTaskManagerProcessFailureRecoveryTest.printProcessLog("TaskManager 1", taskManagerProcess1);
                    AbstractTaskManagerProcessFailureRecoveryTest.printProcessLog("TaskManager 2", taskManagerProcess2);
                    AbstractTaskManagerProcessFailureRecoveryTest.printProcessLog("TaskManager 3", taskManagerProcess3);
                    org.junit.jupiter.api.Assertions.fail((String)e.getMessage());
                    break block26;
                }
                catch (Error e) {
                    e.printStackTrace();
                    AbstractTaskManagerProcessFailureRecoveryTest.printProcessLog("TaskManager 1", taskManagerProcess1);
                    AbstractTaskManagerProcessFailureRecoveryTest.printProcessLog("TaskManager 2", taskManagerProcess2);
                    AbstractTaskManagerProcessFailureRecoveryTest.printProcessLog("TaskManager 3", taskManagerProcess3);
                    throw e;
                }
                finally {
                    if (taskManagerProcess1 != null) {
                        taskManagerProcess1.destroy();
                    }
                    if (taskManagerProcess2 != null) {
                        taskManagerProcess2.destroy();
                    }
                    if (taskManagerProcess3 != null) {
                        taskManagerProcess3.destroy();
                    }
                    this.waitForShutdown("TaskManager 1", taskManagerProcess1);
                    this.waitForShutdown("TaskManager 2", taskManagerProcess2);
                    this.waitForShutdown("TaskManager 3", taskManagerProcess3);
                }
                taskManagerProcess1.destroy();
            }
            if (taskManagerProcess2 != null) {
                taskManagerProcess2.destroy();
            }
            if (taskManagerProcess3 != null) {
                taskManagerProcess3.destroy();
            }
            this.waitForShutdown("TaskManager 1", taskManagerProcess1);
            this.waitForShutdown("TaskManager 2", taskManagerProcess2);
            this.waitForShutdown("TaskManager 3", taskManagerProcess3);
        }
    }

    private void waitForShutdown(String processName, @Nullable TestProcessBuilder.TestProcess process) throws InterruptedException {
        if (process == null) {
            return;
        }
        if (!process.getProcess().waitFor(30L, TimeUnit.SECONDS)) {
            LOG.error("{} did not shutdown in time.", (Object)processName);
            AbstractTaskManagerProcessFailureRecoveryTest.printProcessLog(processName, process);
            process.getProcess().destroyForcibly();
        }
    }

    public abstract void testTaskManagerFailure(Configuration var1, File var2) throws Exception;

    static void printProcessLog(String processName, TestProcessBuilder.TestProcess process) {
        if (process == null) {
            System.out.println("-----------------------------------------");
            System.out.println(" PROCESS " + processName + " WAS NOT STARTED.");
            System.out.println("-----------------------------------------");
        } else {
            System.out.println("-----------------------------------------");
            System.out.println(" BEGIN SPAWNED PROCESS LOG FOR " + processName);
            System.out.println("-----------------------------------------");
            System.out.println(process.getErrorOutput().toString());
            System.out.println("-----------------------------------------");
            System.out.println("\t\tEND SPAWNED PROCESS LOG");
            System.out.println("-----------------------------------------");
        }
    }

    protected static void touchFile(File file) throws IOException {
        if (!file.exists()) {
            new FileOutputStream(file).close();
        }
        if (!file.setLastModified(System.currentTimeMillis())) {
            throw new IOException("Could not touch the file.");
        }
    }

    protected static boolean waitForMarkerFiles(File basedir, String prefix, int num, long timeout) {
        long now = System.currentTimeMillis();
        long deadline = now + timeout;
        while (now < deadline) {
            boolean allFound = true;
            for (int i = 0; i < num; ++i) {
                File nextToCheck = new File(basedir, prefix + i);
                if (nextToCheck.exists()) continue;
                allFound = false;
                break;
            }
            if (allFound) {
                return true;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            now = System.currentTimeMillis();
        }
        return false;
    }
}

