/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.operators;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.windowing.assigners.GlobalWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.test.operators.util.CollectionDataStreams;
import org.apache.flink.test.util.AbstractTestBaseJUnit4;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Collector;
import org.junit.Test;

public class TypeHintITCase
extends AbstractTestBaseJUnit4 {
    @Test
    public void testIdentityMapWithMissingTypesAndStringTypeHint() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource<Tuple3<Integer, Long, String>> ds = CollectionDataStreams.getSmall3TupleDataSet(env);
        SingleOutputStreamOperator identityMapDs = ds.map(new Mapper()).returns((TypeHint)new TypeHint<Tuple3<Integer, Long, String>>(){});
        List result = CollectionUtil.iteratorToList((Iterator)identityMapDs.executeAndCollect());
        String expectedResult = "(2,2,Hello)\n(3,2,Hello world)\n(1,1,Hi)\n";
        TestBaseUtils.compareResultAsText((List)result, (String)expectedResult);
    }

    @Test
    public void testIdentityMapWithMissingTypesAndTypeInformationTypeHint() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource<Tuple3<Integer, Long, String>> ds = CollectionDataStreams.getSmall3TupleDataSet(env);
        SingleOutputStreamOperator identityMapDs = ds.map(new Mapper()).returns((TypeInformation)new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}));
        List result = CollectionUtil.iteratorToList((Iterator)identityMapDs.executeAndCollect());
        String expectedResult = "(2,2,Hello)\n(3,2,Hello world)\n(1,1,Hi)\n";
        TestBaseUtils.compareResultAsText((List)result, (String)expectedResult);
    }

    @Test
    public void testFlatMapWithClassTypeHint() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource<Tuple3<Integer, Long, String>> ds = CollectionDataStreams.getSmall3TupleDataSet(env);
        SingleOutputStreamOperator identityMapDs = ds.flatMap(new FlatMapper()).returns(Integer.class);
        List result = CollectionUtil.iteratorToList((Iterator)identityMapDs.executeAndCollect());
        String expectedResult = "2\n3\n1\n";
        TestBaseUtils.compareResultAsText((List)result, (String)expectedResult);
    }

    @Test
    public void testJoinWithTypeInformationTypeHint() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource<Tuple3<Integer, Long, String>> ds1 = CollectionDataStreams.getSmall3TupleDataSet(env);
        DataStreamSource<Tuple3<Integer, Long, String>> ds2 = CollectionDataStreams.getSmall3TupleDataSet(env);
        SingleOutputStreamOperator resultDs = ds1.join(ds2).where((KeySelector & Serializable)x -> (Integer)x.f0).equalTo((KeySelector & Serializable)x -> (Integer)x.f0).window((WindowAssigner)GlobalWindows.createWithEndOfStreamTrigger()).apply((JoinFunction)new Joiner<Tuple3<Integer, Long, String>, Tuple3<Integer, Long, String>, Integer>(){});
        List result = CollectionUtil.iteratorToList((Iterator)resultDs.executeAndCollect());
        String expectedResult = "2\n3\n1\n";
        TestBaseUtils.compareResultAsText((List)result, (String)expectedResult);
    }

    @Test
    public void testFlatJoinWithTypeInformationTypeHint() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource<Tuple3<Integer, Long, String>> ds1 = CollectionDataStreams.getSmall3TupleDataSet(env);
        DataStreamSource<Tuple3<Integer, Long, String>> ds2 = CollectionDataStreams.getSmall3TupleDataSet(env);
        SingleOutputStreamOperator resultDs = ds1.join(ds2).where((KeySelector & Serializable)x -> (Integer)x.f0).equalTo((KeySelector & Serializable)x -> (Integer)x.f0).window((WindowAssigner)GlobalWindows.createWithEndOfStreamTrigger()).apply((FlatJoinFunction)new FlatJoiner<Tuple3<Integer, Long, String>, Tuple3<Integer, Long, String>, Integer>(){});
        List result = CollectionUtil.iteratorToList((Iterator)resultDs.executeAndCollect());
        String expectedResult = "2\n3\n1\n";
        TestBaseUtils.compareResultAsText((List)result, (String)expectedResult);
    }

    @Test
    public void testCoGroupWithTypeInformationTypeHint() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource<Tuple3<Integer, Long, String>> ds1 = CollectionDataStreams.getSmall3TupleDataSet(env);
        DataStreamSource<Tuple3<Integer, Long, String>> ds2 = CollectionDataStreams.getSmall3TupleDataSet(env);
        SingleOutputStreamOperator resultDs = ds1.coGroup(ds2).where((KeySelector & Serializable)x -> (Integer)x.f0).equalTo((KeySelector & Serializable)x -> (Integer)x.f0).window((WindowAssigner)GlobalWindows.createWithEndOfStreamTrigger()).apply((CoGroupFunction)new CoGrouper<Tuple3<Integer, Long, String>, Tuple3<Integer, Long, String>, Integer>(){});
        List result = CollectionUtil.iteratorToList((Iterator)resultDs.executeAndCollect());
        String expectedResult = "2\n3\n1\n";
        TestBaseUtils.compareResultAsText((List)result, (String)expectedResult);
    }

    private static class CoGrouper<IN1, IN2, OUT>
    implements CoGroupFunction<IN1, IN2, OUT> {
        private static final long serialVersionUID = 1L;

        private CoGrouper() {
        }

        public void coGroup(Iterable<IN1> first, Iterable<IN2> second, Collector<OUT> out) throws Exception {
            out.collect(((Tuple3)first.iterator().next()).f0);
        }
    }

    private static class GroupCombiner<IN, OUT>
    implements GroupCombineFunction<IN, OUT> {
        private static final long serialVersionUID = 1L;

        private GroupCombiner() {
        }

        public void combine(Iterable<IN> values, Collector<OUT> out) throws Exception {
            out.collect(((Tuple3)values.iterator().next()).f0);
        }
    }

    private static class GroupReducer<IN, OUT>
    implements GroupReduceFunction<IN, OUT> {
        private static final long serialVersionUID = 1L;

        private GroupReducer() {
        }

        public void reduce(Iterable<IN> values, Collector<OUT> out) throws Exception {
            out.collect(((Tuple3)values.iterator().next()).f0);
        }
    }

    private static class FlatJoiner<IN1, IN2, OUT>
    implements FlatJoinFunction<IN1, IN2, OUT> {
        private static final long serialVersionUID = 1L;

        private FlatJoiner() {
        }

        public void join(IN1 first, IN2 second, Collector<OUT> out) throws Exception {
            out.collect(((Tuple3)first).f0);
        }
    }

    private static class Joiner<IN1, IN2, OUT>
    implements JoinFunction<IN1, IN2, OUT> {
        private static final long serialVersionUID = 1L;

        private Joiner() {
        }

        public OUT join(IN1 first, IN2 second) throws Exception {
            return (OUT)((Tuple3)first).f0;
        }
    }

    private static class FlatMapper<T, V>
    implements FlatMapFunction<T, V> {
        private static final long serialVersionUID = 1L;

        private FlatMapper() {
        }

        public void flatMap(T value, Collector<V> out) throws Exception {
            out.collect(((Tuple3)value).f0);
        }
    }

    private static class Mapper<T, V>
    implements MapFunction<T, V> {
        private static final long serialVersionUID = 1L;

        private Mapper() {
        }

        public V map(T value) throws Exception {
            return (V)value;
        }
    }
}

