/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.misc;

import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.accumulators.LongCounter;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.serialization.SimpleStringEncoder;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.connector.file.sink.FileSink;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.client.JobExecutionException;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.v2.DiscardingSink;
import org.apache.flink.test.util.MiniClusterWithClientResource;
import org.apache.flink.util.Collector;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class MiscellaneousIssuesITCase
extends TestLogger {
    @ClassRule
    public static final MiniClusterWithClientResource MINI_CLUSTER_RESOURCE = new MiniClusterWithClientResource(new MiniClusterResourceConfiguration.Builder().setNumberTaskManagers(2).setNumberSlotsPerTaskManager(3).build());

    @Test
    public void testNullValues() {
        try {
            StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
            env.setParallelism(1);
            SingleOutputStreamOperator data = env.fromData((Object[])new String[]{"hallo"}).map((MapFunction)new MapFunction<String, String>(){

                public String map(String value) throws Exception {
                    return null;
                }
            });
            data.sinkTo((Sink)FileSink.forRowFormat((Path)new Path("/tmp/myTest"), (Encoder)new SimpleStringEncoder()).build());
            try {
                env.execute();
                Assert.fail((String)"this should fail due to null values.");
            }
            catch (JobExecutionException e) {
                Assert.assertTrue((boolean)ExceptionUtils.findThrowable((Throwable)e, NullPointerException.class).isPresent());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDisjointDataflows() {
        try {
            StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
            env.setParallelism(5);
            env.fromSequence(1L, 10L).sinkTo((Sink)new DiscardingSink());
            env.fromSequence(1L, 10L).sinkTo((Sink)new DiscardingSink());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testAccumulatorsAfterNoOp() {
        String accName = "test_accumulator";
        try {
            StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
            env.setParallelism(6);
            env.fromSequence(1L, 1000000L).rebalance().flatMap((FlatMapFunction)new RichFlatMapFunction<Long, Long>(){
                private LongCounter counter;

                public void open(OpenContext openContext) {
                    this.counter = this.getRuntimeContext().getLongCounter("test_accumulator");
                }

                public void flatMap(Long value, Collector<Long> out) {
                    this.counter.add(1L);
                }
            }).sinkTo((Sink)new DiscardingSink());
            JobExecutionResult result = env.execute();
            Assert.assertEquals((Object)1000000L, result.getAllAccumulatorResults().get("test_accumulator"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

