/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.misc;

import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.v2.DiscardingSink;
import org.apache.flink.test.util.JavaProgramTestBaseJUnit4;
import org.junit.Assert;

public class CustomPartitioningITCase
extends JavaProgramTestBaseJUnit4 {
    protected void testProgram() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        Assert.assertTrue((env.getParallelism() > 1 ? 1 : 0) != 0);
        env.fromSequence(1L, 1000L).partitionCustom((Partitioner)new AllZeroPartitioner(), new IdKeySelector()).map((MapFunction)new FailExceptInPartitionZeroMapper()).sinkTo((Sink)new DiscardingSink());
        env.execute();
    }

    private static class IdKeySelector<T>
    implements KeySelector<T, T> {
        private IdKeySelector() {
        }

        public T getKey(T value) {
            return value;
        }
    }

    private static class AllZeroPartitioner
    implements Partitioner<Long> {
        private AllZeroPartitioner() {
        }

        public int partition(Long key, int numPartitions) {
            return 0;
        }
    }

    private static class FailExceptInPartitionZeroMapper
    extends RichMapFunction<Long, Long> {
        private FailExceptInPartitionZeroMapper() {
        }

        public Long map(Long value) throws Exception {
            if (this.getRuntimeContext().getTaskInfo().getIndexOfThisSubtask() == 0) {
                return value;
            }
            throw new Exception("Received data in a partition other than partition 0");
        }
    }
}

