/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.example.failing;

import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestartStrategyOptions;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.test.util.JavaProgramTestBaseJUnit4;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.ExceptionUtils;
import org.junit.Assert;

public class TaskFailureITCase
extends JavaProgramTestBaseJUnit4 {
    private static final String EXCEPTION_STRING = "This is an expected Test Exception";

    protected void testProgram() throws Exception {
        try {
            this.executeTask((MapFunction<Long, Long>)new FailingTestMapper(), 1);
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)ExceptionUtils.findThrowableWithMessage((Throwable)e, (String)"This is an expected Test Exception:1").isPresent());
        }
        this.executeTask(new TestMapper(), 0);
    }

    private void executeTask(MapFunction<Long, Long> mapper, int retries) throws Exception {
        Configuration configuration = new Configuration();
        configuration.set(RestartStrategyOptions.RESTART_STRATEGY, (Object)"fixed-delay");
        configuration.set(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_ATTEMPTS, (Object)retries);
        configuration.set(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_DELAY, (Object)Duration.ofMillis(0L));
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment((Configuration)configuration);
        env.setParallelism(1);
        List result = CollectionUtil.iteratorToList((Iterator)env.fromSequence(1L, 9L).map(mapper).executeAndCollect());
        TestBaseUtils.compareResultAsText((List)result, (String)"1\n2\n3\n4\n5\n6\n7\n8\n9");
    }

    public static class FailingTestMapper
    extends RichMapFunction<Long, Long> {
        private static final long serialVersionUID = 1L;

        public Long map(Long value) throws Exception {
            throw new RuntimeException("This is an expected Test Exception:" + this.getRuntimeContext().getTaskInfo().getAttemptNumber());
        }
    }

    public static class TestMapper
    implements MapFunction<Long, Long> {
        private static final long serialVersionUID = 1L;

        public Long map(Long value) throws Exception {
            return value;
        }
    }
}

