/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.distributedcache;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.connector.file.src.FileSource;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.connector.file.src.reader.TextLineInputFormat;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.test.util.AbstractTestBaseJUnit4;
import org.apache.flink.util.Collector;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class DistributedCacheTest
extends AbstractTestBaseJUnit4 {
    public static final String DATA = "machen\nzeit\nheerscharen\nkeiner\nmeine\n";

    @Test
    public void testParseCachedFilesFromStringAndBack() {
        List<String> cachedFilesStringList = Arrays.asList("{path: /path/to/file1, name: file1, executable: 'true'}", "{path: /path/to/file2, name: file2, executable: 'false'}");
        List<Tuple2> cachedFilesList = Arrays.asList(Tuple2.of((Object)"file1", (Object)new DistributedCache.DistributedCacheEntry("/path/to/file1", Boolean.valueOf(true))), Tuple2.of((Object)"file2", (Object)new DistributedCache.DistributedCacheEntry("/path/to/file2", Boolean.valueOf(false))));
        List parsedCachedFiles = DistributedCache.parseCachedFilesFromString(cachedFilesStringList);
        Assert.assertThat((Object)parsedCachedFiles, (Matcher)Matchers.containsInAnyOrder((Object[])cachedFilesList.toArray()));
        List parsedCachedFileStrings = DistributedCache.parseStringFromCachedFiles(cachedFilesList);
        Assert.assertThat((Object)parsedCachedFileStrings, (Matcher)Matchers.containsInAnyOrder((Object[])cachedFilesStringList.toArray()));
    }

    @Test
    public void testStreamingDistributedCache() throws Exception {
        String textPath = this.createTempFile("count.txt", DATA);
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.registerCachedFile(textPath, "cache_test");
        FileSource source = FileSource.forRecordStreamFormat((StreamFormat)new TextLineInputFormat(), (Path[])new Path[]{new Path(textPath)}).build();
        env.fromSource((Source)source, WatermarkStrategy.noWatermarks(), "file-source").flatMap((FlatMapFunction)new WordChecker());
        env.execute();
    }

    private static class WordChecker
    extends RichFlatMapFunction<String, Tuple1<String>> {
        private static final long serialVersionUID = 1L;
        private final List<String> wordList = new ArrayList<String>();

        private WordChecker() {
        }

        public void open(OpenContext openContext) throws IOException {
            File file = this.getRuntimeContext().getDistributedCache().getFile("cache_test");
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String tempString;
                while ((tempString = reader.readLine()) != null) {
                    this.wordList.add(tempString);
                }
            }
        }

        public void flatMap(String word, Collector<Tuple1<String>> out) throws Exception {
            Assert.assertTrue((String)("Unexpected word in stream! wordFromStream: " + word + ", shouldBeOneOf: " + this.wordList.toString()), (boolean)this.wordList.contains(word));
            out.collect((Object)new Tuple1((Object)word));
        }
    }
}

