/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.checkpointing;

import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.operators.lifecycle.TestJobExecutor;
import org.apache.flink.runtime.operators.lifecycle.TestJobWithDescription;
import org.apache.flink.runtime.operators.lifecycle.command.TestCommand;
import org.apache.flink.runtime.operators.lifecycle.command.TestCommandDispatcher;
import org.apache.flink.runtime.operators.lifecycle.event.CheckpointCompletedEvent;
import org.apache.flink.runtime.operators.lifecycle.event.CheckpointStartedEvent;
import org.apache.flink.runtime.operators.lifecycle.graph.TestJobBuilders;
import org.apache.flink.runtime.state.IncrementalRemoteKeyedStateHandle;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.SnapshotResult;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.StateSnapshotTransformer;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.apache.flink.runtime.state.ttl.mock.MockKeyedStateBackend;
import org.apache.flink.runtime.state.ttl.mock.MockStateBackend;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.util.RestartStrategyUtils;
import org.apache.flink.test.util.AbstractTestBaseJUnit4;
import org.apache.flink.testutils.junit.SharedObjects;
import org.apache.flink.util.function.ThrowingConsumer;
import org.junit.Rule;
import org.junit.Test;

public class StateHandleReuseITCase
extends AbstractTestBaseJUnit4 {
    @Rule
    public final SharedObjects sharedObjects = SharedObjects.create();

    @Test
    public void runTest() throws Exception {
        TestJobExecutor.execute(this.buildJob(), MINI_CLUSTER_RESOURCE).waitForEvent(CheckpointCompletedEvent.class).waitForEvent(CheckpointStartedEvent.class).waitForEvent(CheckpointCompletedEvent.class).sendBroadcastCommand(TestCommand.FINISH_SOURCES, TestCommandDispatcher.TestCommandScope.ALL_SUBTASKS).waitForTermination().assertFinishedSuccessfully();
    }

    private TestJobWithDescription buildJob() throws Exception {
        return TestJobBuilders.COMPLEX_GRAPH_BUILDER.build(this.sharedObjects, (ThrowingConsumer<Configuration, Exception>)((ThrowingConsumer)cfg -> {}), (ThrowingConsumer<StreamExecutionEnvironment, Exception>)((ThrowingConsumer)env -> {
            env.setParallelism(1);
            env.enableCheckpointing(10L);
            RestartStrategyUtils.configureNoRestartStrategy((StreamExecutionEnvironment)env);
            env.enableChangelogStateBackend(false);
        }), (StateBackend)new MockStateBackend((MockKeyedStateBackend.MockSnapshotSupplier)new SingleHandleSnapshotSupplier()));
    }

    private static class SingleHandleSnapshotSupplier
    implements MockKeyedStateBackend.MockSnapshotSupplier {
        private static final long serialVersionUID = 1L;
        private static final IncrementalRemoteKeyedStateHandle handle = new IncrementalRemoteKeyedStateHandle(UUID.randomUUID(), KeyGroupRange.EMPTY_KEY_GROUP_RANGE, 1L, Collections.emptyList(), Collections.emptyList(), (StreamStateHandle)new ByteStreamStateHandle("meta", new byte[]{0}), 0L);

        private SingleHandleSnapshotSupplier() {
        }

        public <K> SnapshotResult<KeyedStateHandle> snapshot(Map<String, Map<K, Map<Object, Object>>> stateValues, Map<String, StateSnapshotTransformer<Object>> stateSnapshotFilters) {
            return SnapshotResult.of((StateObject)handle);
        }
    }
}

