/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.cancelling;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.RpcOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.test.util.MiniClusterWithClientResource;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.ClassRule;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.FiniteDuration;

public abstract class CancelingTestBase
extends TestLogger {
    private static final int MINIMUM_HEAP_SIZE_MB = 192;
    protected static final int PARALLELISM = 4;
    private static final Configuration configuration = CancelingTestBase.getConfiguration();
    @ClassRule
    public static final MiniClusterWithClientResource CLUSTER = new MiniClusterWithClientResource(new MiniClusterResourceConfiguration.Builder().setConfiguration(configuration).setNumberTaskManagers(2).setNumberSlotsPerTaskManager(4).build());

    private static void verifyJvmOptions() {
        long heap = Runtime.getRuntime().maxMemory() >> 20;
        Assert.assertTrue((String)("Insufficient java heap space " + heap + "mb - set JVM option: -Xmx192m"), (heap > 142L ? 1 : 0) != 0);
    }

    private static Configuration getConfiguration() {
        CancelingTestBase.verifyJvmOptions();
        Configuration config = new Configuration();
        config.set(CoreOptions.FILESYTEM_DEFAULT_OVERRIDE, (Object)true);
        config.set(RpcOptions.ASK_TIMEOUT_DURATION, (Object)TestingUtils.DEFAULT_ASK_TIMEOUT);
        config.set(TaskManagerOptions.MEMORY_SEGMENT_SIZE, (Object)MemorySize.parse((String)"4096"));
        return config;
    }

    protected void runAndCancelJob(JobGraph jobGraph, int msecsTillCanceling, int maxTimeTillCanceled) throws Exception {
        long rpcTimeout = ((Duration)configuration.get(RpcOptions.ASK_TIMEOUT_DURATION)).toMillis();
        ClusterClient client = CLUSTER.getClusterClient();
        JobID jobID = (JobID)client.submitJob(jobGraph).get();
        Deadline submissionDeadLine = new FiniteDuration(2L, TimeUnit.MINUTES).fromNow();
        JobStatus jobStatus = (JobStatus)client.getJobStatus(jobID).get(rpcTimeout, TimeUnit.MILLISECONDS);
        while (jobStatus != JobStatus.RUNNING && submissionDeadLine.hasTimeLeft()) {
            Thread.sleep(50L);
            jobStatus = (JobStatus)client.getJobStatus(jobID).get(rpcTimeout, TimeUnit.MILLISECONDS);
        }
        if (jobStatus != JobStatus.RUNNING) {
            Assert.fail((String)"Job not in state RUNNING.");
        }
        Thread.sleep(msecsTillCanceling);
        client.cancel(jobID).get();
        Deadline cancelDeadline = new FiniteDuration((long)maxTimeTillCanceled, TimeUnit.MILLISECONDS).fromNow();
        JobStatus jobStatusAfterCancel = (JobStatus)client.getJobStatus(jobID).get(rpcTimeout, TimeUnit.MILLISECONDS);
        while (jobStatusAfterCancel != JobStatus.CANCELED && cancelDeadline.hasTimeLeft()) {
            Thread.sleep(50L);
            jobStatusAfterCancel = (JobStatus)client.getJobStatus(jobID).get(rpcTimeout, TimeUnit.MILLISECONDS);
        }
        Assert.assertEquals((Object)JobStatus.CANCELED, (Object)jobStatusAfterCancel);
    }
}

