/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.lifecycle.event;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.runtime.operators.lifecycle.event.TestEvent;

public class OperatorFinishedEvent
extends TestEvent {
    final LastReceivedVertexDataInfo receiveInfo;
    public final long lastSent;

    public OperatorFinishedEvent(String operatorId, int subtaskIndex, int attemptNumber, long lastSent, LastReceivedVertexDataInfo receiveInfo) {
        super(operatorId, subtaskIndex, attemptNumber);
        this.receiveInfo = receiveInfo;
        this.lastSent = lastSent;
    }

    public long getLastReceived(String upstreamID, int upstreamIndex) {
        return this.receiveInfo.forUpstream(upstreamID).getOrDefault(upstreamIndex, -1L);
    }

    @Override
    public String toString() {
        return String.format("%s; receive=%s; sent=%d", super.toString(), this.receiveInfo, this.lastSent);
    }

    public static class LastReceivedVertexDataInfo
    implements Serializable {
        private final Map<String, LastVertexDataInfo> byUpstreamOperatorID;

        public LastReceivedVertexDataInfo(Map<String, LastVertexDataInfo> byUpstreamOperatorID) {
            this.byUpstreamOperatorID = byUpstreamOperatorID;
        }

        public Map<Integer, Long> forUpstream(String upstreamID) {
            return this.byUpstreamOperatorID.getOrDefault((Object)upstreamID, (LastVertexDataInfo)new LastVertexDataInfo()).bySubtask;
        }

        public String toString() {
            return String.valueOf(this.byUpstreamOperatorID);
        }
    }

    public static class LastVertexDataInfo
    implements Serializable {
        public final Map<Integer, Long> bySubtask = new HashMap<Integer, Long>();

        public String toString() {
            return String.valueOf(this.bySubtask);
        }
    }
}

