/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.reporter.MetricReporter;
import org.apache.flink.metrics.reporter.MetricReporterFactory;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.test.junit5.MiniClusterExtension;
import org.apache.flink.testutils.junit.extensions.ContextClassLoaderExtension;
import org.apache.flink.util.concurrent.FutureUtils;
import org.junit.Assert;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class SystemResourcesMetricsITCase {
    @RegisterExtension
    @Order(value=1)
    static final ContextClassLoaderExtension CONTEXT_CLASS_LOADER_EXTENSION = ContextClassLoaderExtension.builder().withServiceEntry(MetricReporterFactory.class, new String[]{TestReporter.class.getName()}).build();
    @RegisterExtension
    @Order(value=2)
    static final MiniClusterExtension MINI_CLUSTER_RESOURCE = new MiniClusterExtension(new MiniClusterResourceConfiguration.Builder().setConfiguration(SystemResourcesMetricsITCase.getConfiguration()).setNumberTaskManagers(1).setNumberSlotsPerTaskManager(1).build());

    SystemResourcesMetricsITCase() {
    }

    private static Configuration getConfiguration() {
        Configuration configuration = new Configuration();
        configuration.set(MetricOptions.SYSTEM_RESOURCE_METRICS, (Object)true);
        configuration.set(MetricOptions.REPORTERS_LIST, (Object)"test_reporter");
        configuration.set(MetricOptions.SCOPE_NAMING_JM, (Object)"jobmanager");
        configuration.set(MetricOptions.SCOPE_NAMING_TM, (Object)"taskmanager");
        MetricOptions.forReporter((Configuration)configuration, (String)"test_reporter").set(MetricOptions.REPORTER_FACTORY_CLASS, (Object)TestReporter.class.getName());
        return configuration;
    }

    @Test
    void startTaskManagerAndCheckForRegisteredSystemMetrics() throws Exception {
        Assert.assertEquals((long)1L, (long)TestReporter.OPENED_REPORTERS.size());
        TestReporter reporter = TestReporter.OPENED_REPORTERS.iterator().next();
        reporter.patternsExhaustedFuture.get(10L, TimeUnit.SECONDS);
    }

    private static List<String> getExpectedPatterns() {
        String[] expectedGauges = new String[]{"System.CPU.Idle", "System.CPU.Sys", "System.CPU.User", "System.CPU.IOWait", "System.CPU.Irq", "System.CPU.SoftIrq", "System.CPU.Steal", "System.CPU.Nice", "System.Memory.Available", "System.Memory.Total", "System.Swap.Used", "System.Swap.Total", "System.Network.*ReceiveRate", "System.Network.*SendRate"};
        String[] expectedHosts = new String[]{"taskmanager.", "jobmanager."};
        ArrayList<String> patterns = new ArrayList<String>();
        for (String expectedHost : expectedHosts) {
            for (String expectedGauge : expectedGauges) {
                patterns.add(expectedHost + expectedGauge);
            }
        }
        return patterns;
    }

    public static final class TestReporter
    implements MetricReporter,
    MetricReporterFactory {
        public static final Set<TestReporter> OPENED_REPORTERS = ConcurrentHashMap.newKeySet();
        private final Map<String, CompletableFuture<Void>> patternFutures = SystemResourcesMetricsITCase.getExpectedPatterns().stream().collect(Collectors.toMap(pattern -> pattern, pattern -> new CompletableFuture()));
        private final CompletableFuture<Void> patternsExhaustedFuture = FutureUtils.waitForAll(this.patternFutures.values());

        public void open(MetricConfig config) {
            OPENED_REPORTERS.add(this);
        }

        public void close() {
            OPENED_REPORTERS.remove(this);
        }

        public void notifyOfAddedMetric(Metric metric, String metricName, MetricGroup group) {
            String metricIdentifier = group.getMetricIdentifier(metricName, CharacterFilter.NO_OP_FILTER);
            for (String expectedPattern : this.patternFutures.keySet()) {
                if (!metricIdentifier.matches(expectedPattern)) continue;
                this.patternFutures.get(expectedPattern).complete(null);
            }
        }

        public void notifyOfRemovedMetric(Metric metric, String metricName, MetricGroup group) {
        }

        public MetricReporter createMetricReporter(Properties properties) {
            return this;
        }
    }
}

