/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.core.testutils.BlockerSync;
import org.apache.flink.core.testutils.CheckedThread;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.reporter.AbstractReporter;
import org.apache.flink.metrics.reporter.MetricReporter;
import org.apache.flink.metrics.reporter.MetricReporterFactory;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.legacy.PrintSinkFunction;
import org.apache.flink.streaming.api.functions.sink.legacy.SinkFunction;
import org.apache.flink.streaming.api.functions.source.legacy.SourceFunction;
import org.apache.flink.test.junit5.MiniClusterExtension;
import org.apache.flink.testutils.junit.extensions.ContextClassLoaderExtension;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class JobManagerMetricsITCase {
    private static final String JOB_MANAGER_METRICS_PREFIX = "localhost.jobmanager.";
    private static final BlockerSync sync = new BlockerSync();
    private CheckedThread jobExecuteThread;
    @RegisterExtension
    @Order(value=1)
    static final ContextClassLoaderExtension CONTEXT_CLASS_LOADER_EXTENSION = ContextClassLoaderExtension.builder().withServiceEntry(MetricReporterFactory.class, new String[]{TestReporter.class.getName()}).build();
    @RegisterExtension
    @Order(value=2)
    static final MiniClusterExtension MINI_CLUSTER_RESOURCE = new MiniClusterExtension(new MiniClusterResourceConfiguration.Builder().setConfiguration(JobManagerMetricsITCase.getConfiguration()).setNumberTaskManagers(1).setNumberSlotsPerTaskManager(1).build());

    JobManagerMetricsITCase() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.jobExecuteThread = new CheckedThread(){

            public void go() throws Exception {
                StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
                env.addSource((SourceFunction)new SourceFunction<String>(){

                    public void run(SourceFunction.SourceContext<String> ctx) throws Exception {
                        sync.block();
                    }

                    public void cancel() {
                        sync.releaseBlocker();
                    }
                }).addSink((SinkFunction)new PrintSinkFunction());
                env.execute();
            }
        };
        this.jobExecuteThread.start();
        sync.awaitBlocker();
    }

    @Test
    void testJobManagerMetrics() throws Exception {
        Assert.assertEquals((long)1L, (long)TestReporter.OPENED_REPORTERS.size());
        TestReporter reporter = TestReporter.OPENED_REPORTERS.iterator().next();
        List<String> expectedPatterns = JobManagerMetricsITCase.getExpectedPatterns();
        Collection<String> gaugeNames = reporter.getGauges().values();
        for (String string : expectedPatterns) {
            boolean found = false;
            for (String gaugeName : gaugeNames) {
                if (!gaugeName.matches(string)) continue;
                found = true;
            }
            if (found) continue;
            Assert.fail((String)String.format("Failed to find gauge [%s] in registered gauges [%s]", string, gaugeNames));
        }
        for (Map.Entry entry : reporter.getGauges().entrySet()) {
            if (((String)entry.getValue()).contains("taskSlotsAvailable")) {
                Assert.assertEquals((Object)0L, (Object)((Gauge)entry.getKey()).getValue());
                continue;
            }
            if (((String)entry.getValue()).contains("taskSlotsTotal")) {
                Assert.assertEquals((Object)1L, (Object)((Gauge)entry.getKey()).getValue());
                continue;
            }
            if (((String)entry.getValue()).contains("numRegisteredTaskManagers")) {
                Assert.assertEquals((Object)1L, (Object)((Gauge)entry.getKey()).getValue());
                continue;
            }
            if (!((String)entry.getValue()).contains("numRunningJobs")) continue;
            Assert.assertEquals((Object)1L, (Object)((Gauge)entry.getKey()).getValue());
        }
        sync.releaseBlocker();
        this.jobExecuteThread.sync();
    }

    private static Configuration getConfiguration() {
        Configuration configuration = new Configuration();
        MetricOptions.forReporter((Configuration)configuration, (String)"test_reporter").set(MetricOptions.REPORTER_FACTORY_CLASS, (Object)TestReporter.class.getName());
        return configuration;
    }

    private static List<String> getExpectedPatterns() {
        String[] expectedGauges = new String[]{"taskSlotsAvailable", "taskSlotsTotal", "numRegisteredTaskManagers", "numRunningJobs"};
        ArrayList<String> patterns = new ArrayList<String>();
        for (String expectedGauge : expectedGauges) {
            patterns.add(JOB_MANAGER_METRICS_PREFIX + expectedGauge);
        }
        return patterns;
    }

    public static final class TestReporter
    extends AbstractReporter
    implements MetricReporterFactory {
        public static final Set<TestReporter> OPENED_REPORTERS = ConcurrentHashMap.newKeySet();

        public String filterCharacters(String input) {
            return input;
        }

        public void open(MetricConfig config) {
            OPENED_REPORTERS.add(this);
        }

        public void close() {
            OPENED_REPORTERS.remove((Object)this);
        }

        public Map<Gauge<?>, String> getGauges() {
            return this.gauges;
        }

        public MetricReporter createMetricReporter(Properties properties) {
            return this;
        }
    }
}

