/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.upserttest.table;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SimpleStringSchema;
import org.apache.flink.connector.upserttest.sink.UpsertTestFileUtil;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.test.junit5.MiniClusterExtension;
import org.apache.flink.util.TestLoggerExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={TestLoggerExtension.class})
class UpsertTestDynamicTableSinkITCase {
    @RegisterExtension
    public static final MiniClusterExtension MINI_CLUSTER_RESOURCE = new MiniClusterExtension(new MiniClusterResourceConfiguration.Builder().setNumberTaskManagers(1).setNumberSlotsPerTaskManager(1).build());

    UpsertTestDynamicTableSinkITCase() {
    }

    @Test
    void testWritingDocumentsInBatchMode(@TempDir File tempDir) throws Exception {
        TableEnvironment tEnv = TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.inBatchMode());
        String format = "json";
        File outputFile = new File(tempDir, "records.out");
        String outputFilepath = outputFile.toString();
        String createTable = String.format("CREATE TABLE UpsertFileSinkTable (\n    user_id INT,\n    user_name STRING,\n    user_count BIGINT,\n    PRIMARY KEY (user_id) NOT ENFORCED\n  ) WITH (\n    'connector' = '%s',\n    'key.format' = '%s',\n    'value.format' = '%s',\n    'output-filepath' = '%s'\n  );", "upsert-files", format, format, outputFilepath);
        tEnv.executeSql(createTable);
        String insertSql = "INSERT INTO UpsertFileSinkTable\nSELECT user_id, user_name, COUNT(*) AS user_count\nFROM (VALUES (1, 'Bob'), (22, 'Tom'), (42, 'Kim'), (42, 'Kim'), (42, 'Kim'), (1, 'Bob'))\n  AS UserCountTable(user_id, user_name)\nGROUP BY user_id, user_name";
        tEnv.executeSql(insertSql).await();
        int numberOfResultRecords = UpsertTestFileUtil.getNumberOfRecords((File)outputFile);
        Assertions.assertThat((int)numberOfResultRecords).isEqualTo(3);
        SimpleStringSchema deserializationSchema = new SimpleStringSchema();
        Map records = UpsertTestFileUtil.readRecords((File)outputFile, (DeserializationSchema)deserializationSchema, (DeserializationSchema)deserializationSchema);
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("{\"user_id\":1}", "{\"user_id\":1,\"user_name\":\"Bob\",\"user_count\":2}");
        expected.put("{\"user_id\":22}", "{\"user_id\":22,\"user_name\":\"Tom\",\"user_count\":1}");
        expected.put("{\"user_id\":42}", "{\"user_id\":42,\"user_name\":\"Kim\",\"user_count\":3}");
        Assertions.assertThat((Map)records).isEqualTo(expected);
    }
}

