/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.functions;

import java.io.File;
import java.io.Serializable;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.serialization.SimpleStringEncoder;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.connector.file.sink.FileSink;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class ClosureCleanerITCase {
    @TempDir
    private java.nio.file.Path tempPath;
    private String resultPath;
    private String result;

    ClosureCleanerITCase() {
    }

    @BeforeEach
    void before() throws Exception {
        File tempFolder = TempDirUtils.newFolder((java.nio.file.Path)this.tempPath);
        this.resultPath = tempFolder.toURI().toString();
    }

    @AfterEach
    void after() throws Exception {
        TestBaseUtils.compareResultsByLinesInMemory((String)this.result, (String)this.resultPath);
    }

    @Test
    void testObject() throws Exception {
        TestObject.run(this.resultPath);
        this.result = "30";
    }

    @Test
    void testClass() throws Exception {
        new TestClass().run(this.resultPath);
        this.result = "30";
    }

    @Test
    void testClassWithoutDefaulConstructor() throws Exception {
        new TestClassWithoutDefaultConstructor(5).run(this.resultPath);
        this.result = "30";
    }

    @Test
    void testClassWithoutFieldAccess() throws Exception {
        new TestClassWithoutFieldAccess().run(this.resultPath);
        this.result = "30";
    }

    static class TestClassWithoutFieldAccess {
        private NonSerializable nonSer = new NonSerializable();

        TestClassWithoutFieldAccess() {
        }

        public void run(String resultPath) throws Exception {
            NonSerializable nonSer2 = new NonSerializable();
            int x = 5;
            StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
            env.setRuntimeMode(RuntimeExecutionMode.BATCH);
            DataStreamSource nums = env.fromSequence(1L, 4L);
            nums.map((MapFunction & Serializable)num -> num + (long)x).setParallelism(1).fullWindowPartition().reduce(Long::sum).sinkTo((Sink)FileSink.forRowFormat((Path)new Path(resultPath), (Encoder)new SimpleStringEncoder()).build());
            env.execute();
        }
    }

    static class TestClassWithoutDefaultConstructor {
        private int x;
        private NonSerializable nonSer = new NonSerializable();

        public TestClassWithoutDefaultConstructor(int x) {
            this.x = x;
        }

        public void run(String resultPath) throws Exception {
            NonSerializable nonSer2 = new NonSerializable();
            int x = 5;
            StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
            env.setRuntimeMode(RuntimeExecutionMode.BATCH);
            DataStreamSource nums = env.fromSequence(1L, 4L);
            nums.map((MapFunction & Serializable)num -> num + (long)x).setParallelism(1).fullWindowPartition().reduce(Long::sum).sinkTo((Sink)FileSink.forRowFormat((Path)new Path(resultPath), (Encoder)new SimpleStringEncoder()).build());
            env.execute();
        }
    }

    static class TestClass
    implements Serializable {
        private int x = 5;

        TestClass() {
        }

        private int getX() {
            return this.x;
        }

        public void run(String resultPath) throws Exception {
            NonSerializable nonSer = new NonSerializable();
            StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
            env.setRuntimeMode(RuntimeExecutionMode.BATCH);
            DataStreamSource nums = env.fromSequence(1L, 4L);
            nums.map((MapFunction & Serializable)num -> num + (long)this.getX()).setParallelism(1).fullWindowPartition().reduce(Long::sum).sinkTo((Sink)FileSink.forRowFormat((Path)new Path(resultPath), (Encoder)new SimpleStringEncoder()).build());
            env.execute();
        }
    }

    static class TestObject {
        TestObject() {
        }

        public static void run(String resultPath) throws Exception {
            NonSerializable nonSer = new NonSerializable();
            int x = 5;
            StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
            env.setRuntimeMode(RuntimeExecutionMode.BATCH);
            DataStreamSource nums = env.fromSequence(1L, 4L);
            nums.map((MapFunction & Serializable)num -> num + (long)x).setParallelism(1).fullWindowPartition().reduce(Long::sum).sinkTo((Sink)FileSink.forRowFormat((Path)new Path(resultPath), (Encoder)new SimpleStringEncoder()).build());
            env.execute();
        }
    }

    static class NonSerializable {
        NonSerializable() {
        }
    }
}

