/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.recovery;

import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.runtime.client.JobExecutionException;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.test.util.MiniClusterWithClientResource;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public abstract class SimpleRecoveryITCaseBase
extends TestLogger {
    @ClassRule
    public static final MiniClusterWithClientResource MINI_CLUSTER_WITH_CLIENT_RESOURCE = new MiniClusterWithClientResource(new MiniClusterResourceConfiguration.Builder().setNumberTaskManagers(4).setNumberSlotsPerTaskManager(1).build());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailedRunThenSuccessfulRun() throws Exception {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            env.setParallelism(4);
            env.setRestartStrategy(RestartStrategies.noRestart());
            try {
                env.generateSequence(1L, 10L).rebalance().map(new FailingMapper1()).reduce(Long::sum).collect();
                Assert.fail((String)"The program should have failed, but run successfully");
            }
            catch (JobExecutionException jobExecutionException) {
                // empty catch block
            }
            env = ExecutionEnvironment.getExecutionEnvironment();
            env.setParallelism(4);
            env.setRestartStrategy(RestartStrategies.noRestart());
            List resultCollection = env.generateSequence(1L, 10L).rebalance().map(new FailingMapper1()).reduce(Long::sum).collect();
            long sum = 0L;
            Iterator iterator = resultCollection.iterator();
            while (iterator.hasNext()) {
                long l = (Long)iterator.next();
                sum += l;
            }
            Assert.assertEquals((long)55L, (long)sum);
        }
        finally {
            FailingMapper1.failuresBeforeSuccess = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestart() throws Exception {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            env.setParallelism(4);
            List resultCollection = env.generateSequence(1L, 10L).rebalance().map(new FailingMapper2()).reduce(Long::sum).collect();
            long sum = 0L;
            Iterator iterator = resultCollection.iterator();
            while (iterator.hasNext()) {
                long l = (Long)iterator.next();
                sum += l;
            }
            Assert.assertEquals((long)55L, (long)sum);
        }
        finally {
            FailingMapper2.failuresBeforeSuccess = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestartMultipleTimes() throws Exception {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            env.setParallelism(4);
            List resultCollection = env.generateSequence(1L, 10L).rebalance().map(new FailingMapper3()).reduce(Long::sum).collect();
            long sum = 0L;
            Iterator iterator = resultCollection.iterator();
            while (iterator.hasNext()) {
                long l = (Long)iterator.next();
                sum += l;
            }
            Assert.assertEquals((long)55L, (long)sum);
        }
        finally {
            FailingMapper3.failuresBeforeSuccess = 3;
        }
    }

    private static class FailingMapper3<T>
    extends RichMapFunction<T, T> {
        private static volatile int failuresBeforeSuccess = 3;

        private FailingMapper3() {
        }

        public T map(T value) throws Exception {
            if (failuresBeforeSuccess > 0 && this.getRuntimeContext().getTaskInfo().getIndexOfThisSubtask() == 1) {
                --failuresBeforeSuccess;
                throw new Exception("Test Failure");
            }
            return value;
        }
    }

    private static class FailingMapper2<T>
    extends RichMapFunction<T, T> {
        private static volatile int failuresBeforeSuccess = 1;

        private FailingMapper2() {
        }

        public T map(T value) throws Exception {
            if (failuresBeforeSuccess > 0 && this.getRuntimeContext().getTaskInfo().getIndexOfThisSubtask() == 1) {
                --failuresBeforeSuccess;
                throw new Exception("Test Failure");
            }
            return value;
        }
    }

    private static class FailingMapper1<T>
    extends RichMapFunction<T, T> {
        private static volatile int failuresBeforeSuccess = 1;

        private FailingMapper1() {
        }

        public T map(T value) throws Exception {
            if (failuresBeforeSuccess > 0 && this.getRuntimeContext().getTaskInfo().getIndexOfThisSubtask() == 1) {
                --failuresBeforeSuccess;
                throw new Exception("Test Failure");
            }
            return value;
        }
    }
}

