/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.optimizer.examples;

import java.util.Arrays;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.operators.DualInputOperator;
import org.apache.flink.api.common.operators.GenericDataSourceBase;
import org.apache.flink.api.common.operators.SingleInputOperator;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.optimizer.plan.DualInputPlanNode;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plan.SingleInputPlanNode;
import org.apache.flink.optimizer.plan.SinkPlanNode;
import org.apache.flink.optimizer.util.CompilerTestBase;
import org.apache.flink.optimizer.util.OperatorResolver;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.apache.flink.runtime.operators.util.LocalStrategy;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.Test;

public class RelationalQueryCompilerTest
extends CompilerTestBase {
    private static final String ORDERS = "Orders";
    private static final String LINEITEM = "LineItems";
    private static final String MAPPER_NAME = "FilterO";
    private static final String JOIN_NAME = "JoinLiO";
    private static final String REDUCE_NAME = "AggLiO";
    private static final String SINK = "Output";
    private final FieldList set0 = new FieldList(0);
    private final FieldList set01 = new FieldList(new int[]{0, 1});
    private final ExecutionConfig defaultExecutionConfig = new ExecutionConfig();

    @Test
    public void testQueryNoStatistics() {
        try {
            Plan p = RelationalQueryCompilerTest.getTPCH3Plan();
            p.setExecutionConfig(this.defaultExecutionConfig);
            OptimizedPlan plan = this.compileNoStats(p);
            CompilerTestBase.OptimizerPlanNodeResolver or = RelationalQueryCompilerTest.getOptimizerPlanNodeResolver((OptimizedPlan)plan);
            SinkPlanNode sink = (SinkPlanNode)or.getNode(SINK);
            SingleInputPlanNode reducer = (SingleInputPlanNode)or.getNode(REDUCE_NAME);
            SingleInputPlanNode combiner = reducer.getPredecessor() instanceof SingleInputPlanNode ? (SingleInputPlanNode)reducer.getPredecessor() : null;
            DualInputPlanNode join = (DualInputPlanNode)or.getNode(JOIN_NAME);
            SingleInputPlanNode filteringMapper = (SingleInputPlanNode)or.getNode(MAPPER_NAME);
            this.checkStandardStrategies(filteringMapper, join, combiner, reducer, sink);
            Assert.assertTrue((boolean)this.checkRepartitionShipStrategies(join, reducer, combiner));
            Assert.assertTrue((this.checkHashJoinStrategies(join, reducer, true) || this.checkHashJoinStrategies(join, reducer, false) ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testQueryAnyValidPlan() throws Exception {
        this.testQueryGeneric(0x40000000L, 0x200000000L, 0.05f, 0.05f, true, true, true, false, true);
    }

    @Test
    public void testQueryWithSizeZeroInputs() throws Exception {
        this.testQueryGeneric(0L, 0L, 0.1f, 0.5f, true, true, true, false, true);
    }

    @Test
    public void testQueryWithStatsForBroadcastHash() throws Exception {
        this.testQueryGeneric(0x10000000000L, 0x10000000000L, 0.01f, 0.05f, true, false, true, false, false);
    }

    @Test
    public void testQueryWithStatsForRepartitionAny() throws Exception {
        this.testQueryGeneric(0x640000000000L, 0x640000000000L, 0.1f, 0.5f, false, true, true, true, true);
    }

    @Test
    public void testQueryWithStatsForRepartitionMerge() throws Exception {
        Plan p = RelationalQueryCompilerTest.getTPCH3Plan();
        p.setExecutionConfig(this.defaultExecutionConfig);
        OperatorResolver cr = RelationalQueryCompilerTest.getContractResolver((Plan)p);
        DualInputOperator match = (DualInputOperator)cr.getNode(JOIN_NAME);
        match.getCompilerHints().setFilterFactor(100.0f);
        this.testQueryGeneric(0x640000000000L, 0x640000000000L, 0.01f, 100.0f, false, true, false, false, true);
    }

    private void testQueryGeneric(long orderSize, long lineItemSize, float ordersFilterFactor, float joinFilterFactor, boolean broadcastOkay, boolean partitionedOkay, boolean hashJoinFirstOkay, boolean hashJoinSecondOkay, boolean mergeJoinOkay) throws Exception {
        Plan p = RelationalQueryCompilerTest.getTPCH3Plan();
        p.setExecutionConfig(this.defaultExecutionConfig);
        this.testQueryGeneric(p, orderSize, lineItemSize, ordersFilterFactor, joinFilterFactor, broadcastOkay, partitionedOkay, hashJoinFirstOkay, hashJoinSecondOkay, mergeJoinOkay);
    }

    private void testQueryGeneric(Plan p, long orderSize, long lineitemSize, float orderSelectivity, float joinSelectivity, boolean broadcastOkay, boolean partitionedOkay, boolean hashJoinFirstOkay, boolean hashJoinSecondOkay, boolean mergeJoinOkay) {
        try {
            OperatorResolver cr = RelationalQueryCompilerTest.getContractResolver((Plan)p);
            GenericDataSourceBase ordersSource = (GenericDataSourceBase)cr.getNode(ORDERS);
            GenericDataSourceBase lineItemSource = (GenericDataSourceBase)cr.getNode(LINEITEM);
            SingleInputOperator mapper = (SingleInputOperator)cr.getNode(MAPPER_NAME);
            DualInputOperator joiner = (DualInputOperator)cr.getNode(JOIN_NAME);
            this.setSourceStatistics(ordersSource, orderSize, 100.0f);
            this.setSourceStatistics(lineItemSource, lineitemSize, 140.0f);
            mapper.getCompilerHints().setAvgOutputRecordSize(16.0f);
            mapper.getCompilerHints().setFilterFactor(orderSelectivity);
            joiner.getCompilerHints().setFilterFactor(joinSelectivity);
            OptimizedPlan plan = this.compileWithStats(p);
            CompilerTestBase.OptimizerPlanNodeResolver or = RelationalQueryCompilerTest.getOptimizerPlanNodeResolver((OptimizedPlan)plan);
            SinkPlanNode sink = (SinkPlanNode)or.getNode(SINK);
            SingleInputPlanNode reducer = (SingleInputPlanNode)or.getNode(REDUCE_NAME);
            SingleInputPlanNode combiner = reducer.getPredecessor() instanceof SingleInputPlanNode ? (SingleInputPlanNode)reducer.getPredecessor() : null;
            DualInputPlanNode join = (DualInputPlanNode)or.getNode(JOIN_NAME);
            SingleInputPlanNode filteringMapper = (SingleInputPlanNode)or.getNode(MAPPER_NAME);
            this.checkStandardStrategies(filteringMapper, join, combiner, reducer, sink);
            if (this.checkBroadcastShipStrategies(join, reducer, combiner)) {
                Assert.assertTrue((String)"Broadcast join incorrectly chosen.", (boolean)broadcastOkay);
                if (this.checkHashJoinStrategies(join, reducer, true)) {
                    Assert.assertTrue((String)"Hash join (build orders) incorrectly chosen", (boolean)hashJoinFirstOkay);
                } else if (this.checkHashJoinStrategies(join, reducer, false)) {
                    Assert.assertTrue((String)"Hash join (build lineitem) incorrectly chosen", (boolean)hashJoinSecondOkay);
                } else if (this.checkBroadcastMergeJoin(join, reducer)) {
                    Assert.assertTrue((String)"Merge join incorrectly chosen", (boolean)mergeJoinOkay);
                } else {
                    Assert.fail((String)"Plan has no correct hash join or merge join strategies.");
                }
            } else if (this.checkRepartitionShipStrategies(join, reducer, combiner)) {
                Assert.assertTrue((String)"Partitioned join incorrectly chosen.", (boolean)partitionedOkay);
                if (this.checkHashJoinStrategies(join, reducer, true)) {
                    Assert.assertTrue((String)"Hash join (build orders) incorrectly chosen", (boolean)hashJoinFirstOkay);
                } else if (this.checkHashJoinStrategies(join, reducer, false)) {
                    Assert.assertTrue((String)"Hash join (build lineitem) incorrectly chosen", (boolean)hashJoinSecondOkay);
                } else if (this.checkRepartitionMergeJoin(join, reducer)) {
                    Assert.assertTrue((String)"Merge join incorrectly chosen", (boolean)mergeJoinOkay);
                } else {
                    Assert.fail((String)"Plan has no correct hash join or merge join strategies.");
                }
            } else {
                Assert.fail((String)"Plan has neither correct BC join or partitioned join configuration.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private void checkStandardStrategies(SingleInputPlanNode map, DualInputPlanNode join, SingleInputPlanNode combiner, SingleInputPlanNode reducer, SinkPlanNode sink) {
        Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)map.getInput().getShipStrategy());
        Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)sink.getInput().getShipStrategy());
        Assert.assertEquals((Object)DriverStrategy.FLAT_MAP, (Object)map.getDriverStrategy());
        Assert.assertEquals((Object)DriverStrategy.SORTED_GROUP_REDUCE, (Object)reducer.getDriverStrategy());
        Assert.assertEquals((Object)DriverStrategy.NONE, (Object)sink.getDriverStrategy());
        if (combiner != null) {
            Assert.assertEquals((Object)DriverStrategy.SORTED_GROUP_COMBINE, (Object)combiner.getDriverStrategy());
            Assert.assertEquals((Object)LocalStrategy.NONE, (Object)combiner.getInput().getLocalStrategy());
        }
    }

    private boolean checkBroadcastShipStrategies(DualInputPlanNode join, SingleInputPlanNode reducer, SingleInputPlanNode combiner) {
        if (ShipStrategyType.BROADCAST == join.getInput1().getShipStrategy() && ShipStrategyType.FORWARD == join.getInput2().getShipStrategy() && ShipStrategyType.PARTITION_HASH == reducer.getInput().getShipStrategy()) {
            Assert.assertNotNull((String)"Plan should have a combiner", (Object)combiner);
            Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)combiner.getInput().getShipStrategy());
            return true;
        }
        return false;
    }

    private boolean checkRepartitionShipStrategies(DualInputPlanNode join, SingleInputPlanNode reducer, SingleInputPlanNode combiner) {
        if (ShipStrategyType.PARTITION_HASH == join.getInput1().getShipStrategy() && ShipStrategyType.PARTITION_HASH == join.getInput2().getShipStrategy() && ShipStrategyType.FORWARD == reducer.getInput().getShipStrategy()) {
            Assert.assertNull((String)"Plan should not have a combiner", (Object)combiner);
            return true;
        }
        return false;
    }

    private boolean checkHashJoinStrategies(DualInputPlanNode join, SingleInputPlanNode reducer, boolean buildFirst) {
        if (buildFirst && DriverStrategy.HYBRIDHASH_BUILD_FIRST == join.getDriverStrategy() || !buildFirst && DriverStrategy.HYBRIDHASH_BUILD_SECOND == join.getDriverStrategy()) {
            Assert.assertEquals((Object)this.set0, (Object)join.getKeysForInput1());
            Assert.assertEquals((Object)this.set0, (Object)join.getKeysForInput2());
            Assert.assertEquals((Object)LocalStrategy.NONE, (Object)join.getInput1().getLocalStrategy());
            Assert.assertEquals((Object)LocalStrategy.NONE, (Object)join.getInput2().getLocalStrategy());
            Assert.assertEquals((Object)LocalStrategy.COMBININGSORT, (Object)reducer.getInput().getLocalStrategy());
            Assert.assertEquals((Object)this.set01, (Object)reducer.getInput().getLocalStrategyKeys());
            Assert.assertEquals((Object)this.set01, (Object)reducer.getKeys(0));
            Assert.assertTrue((boolean)Arrays.equals(reducer.getInput().getLocalStrategySortOrder(), reducer.getSortOrders(0)));
            return true;
        }
        return false;
    }

    private boolean checkBroadcastMergeJoin(DualInputPlanNode join, SingleInputPlanNode reducer) {
        if (DriverStrategy.INNER_MERGE == join.getDriverStrategy()) {
            Assert.assertEquals((Object)this.set0, (Object)join.getKeysForInput1());
            Assert.assertEquals((Object)this.set0, (Object)join.getKeysForInput2());
            Assert.assertEquals((Object)LocalStrategy.SORT, (Object)join.getInput1().getLocalStrategy());
            Assert.assertEquals((Object)LocalStrategy.SORT, (Object)join.getInput2().getLocalStrategy());
            Assert.assertEquals((Object)LocalStrategy.COMBININGSORT, (Object)reducer.getInput().getLocalStrategy());
            Assert.assertEquals((Object)this.set0, (Object)join.getInput1().getLocalStrategyKeys());
            Assert.assertEquals((Object)this.set0, (Object)join.getInput2().getLocalStrategyKeys());
            Assert.assertTrue((boolean)Arrays.equals(join.getInput1().getLocalStrategySortOrder(), join.getInput2().getLocalStrategySortOrder()));
            Assert.assertEquals((Object)this.set01, (Object)reducer.getInput().getLocalStrategyKeys());
            Assert.assertEquals((Object)this.set01, (Object)reducer.getKeys(0));
            Assert.assertTrue((boolean)Arrays.equals(reducer.getInput().getLocalStrategySortOrder(), reducer.getSortOrders(0)));
            return true;
        }
        return false;
    }

    private boolean checkRepartitionMergeJoin(DualInputPlanNode join, SingleInputPlanNode reducer) {
        if (DriverStrategy.INNER_MERGE == join.getDriverStrategy()) {
            Assert.assertEquals((Object)this.set0, (Object)join.getKeysForInput1());
            Assert.assertEquals((Object)this.set0, (Object)join.getKeysForInput2());
            Assert.assertEquals((Object)LocalStrategy.SORT, (Object)join.getInput1().getLocalStrategy());
            Assert.assertEquals((Object)LocalStrategy.SORT, (Object)join.getInput2().getLocalStrategy());
            Assert.assertEquals((Object)LocalStrategy.NONE, (Object)reducer.getInput().getLocalStrategy());
            Assert.assertEquals((Object)this.set01, (Object)join.getInput1().getLocalStrategyKeys());
            Assert.assertEquals((Object)this.set0, (Object)join.getInput2().getLocalStrategyKeys());
            Assert.assertTrue((join.getInput1().getLocalStrategySortOrder()[0] == join.getInput2().getLocalStrategySortOrder()[0] ? 1 : 0) != 0);
            Assert.assertEquals((Object)this.set01, (Object)reducer.getKeys(0));
            Assert.assertTrue((boolean)Arrays.equals(join.getInput1().getLocalStrategySortOrder(), reducer.getSortOrders(0)));
            return true;
        }
        return false;
    }

    public static Plan getTPCH3Plan() throws Exception {
        return RelationalQueryCompilerTest.tpch3(new String[]{DEFAULT_PARALLELISM_STRING, IN_FILE, IN_FILE, OUT_FILE});
    }

    public static Plan tpch3(String[] args) throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(Integer.parseInt(args[0]));
        Operator orders = env.readCsvFile(args[1]).fieldDelimiter("|").lineDelimiter("\n").includeFields("101011001").types(Long.class, String.class, String.class, String.class, Integer.class).name(ORDERS);
        Operator lineItems = env.readCsvFile(args[2]).fieldDelimiter("|").lineDelimiter("\n").includeFields("100001").types(Long.class, Double.class).name(LINEITEM);
        Operator filterO = orders.flatMap((FlatMapFunction)new FilterO()).name(MAPPER_NAME);
        Operator joinLiO = filterO.join((DataSet)lineItems).where(new int[]{0}).equalTo(new int[]{0}).with((FlatJoinFunction)new JoinLiO()).name(JOIN_NAME);
        Operator aggLiO = joinLiO.groupBy(new int[]{0, 1}).reduceGroup((GroupReduceFunction)new AggLiO()).name(REDUCE_NAME);
        aggLiO.writeAsCsv(args[3], "\n", "|").name(SINK);
        return env.createProgramPlan();
    }

    @FunctionAnnotation.ForwardedFields(value={"f0; f1"})
    private static class AggLiO
    implements GroupReduceFunction<Tuple3<Long, Integer, Double>, Tuple3<Long, Integer, Double>>,
    GroupCombineFunction<Tuple3<Long, Integer, Double>, Tuple3<Long, Integer, Double>> {
        private AggLiO() {
        }

        public void reduce(Iterable<Tuple3<Long, Integer, Double>> values, Collector<Tuple3<Long, Integer, Double>> out) throws Exception {
        }

        public void combine(Iterable<Tuple3<Long, Integer, Double>> values, Collector<Tuple3<Long, Integer, Double>> out) throws Exception {
        }
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"f0; f1"})
    private static class JoinLiO
    implements FlatJoinFunction<Tuple2<Long, Integer>, Tuple2<Long, Double>, Tuple3<Long, Integer, Double>> {
        private JoinLiO() {
        }

        public void join(Tuple2<Long, Integer> first, Tuple2<Long, Double> second, Collector<Tuple3<Long, Integer, Double>> out) throws Exception {
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"f0; f4->f1"})
    private static class FilterO
    implements FlatMapFunction<Tuple5<Long, String, String, String, Integer>, Tuple2<Long, Integer>> {
        private FilterO() {
        }

        public void flatMap(Tuple5<Long, String, String, String, Integer> value, Collector<Tuple2<Long, Integer>> out) throws Exception {
        }
    }
}

