/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.iterative;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichCoGroupFunction;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.io.LocalCollectionOutputFormat;
import org.apache.flink.api.java.operators.CoGroupOperator;
import org.apache.flink.api.java.operators.DeltaIteration;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.examples.java.graph.ConnectedComponents;
import org.apache.flink.test.testdata.ConnectedComponentsData;
import org.apache.flink.test.util.JavaProgramTestBaseJUnit4;
import org.apache.flink.util.Collector;

public class CoGroupConnectedComponentsSecondITCase
extends JavaProgramTestBaseJUnit4 {
    private static final long SEED = 3287269182979823L;
    private static final int NUM_VERTICES = 1000;
    private static final int NUM_EDGES = 10000;

    protected void testProgram() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        MapOperator vertices = env.fromElements((Object[])ConnectedComponentsData.getEnumeratingVertices((int)1000).split("\n")).map((MapFunction)new VertexParser());
        FlatMapOperator edges = env.fromElements((Object[])ConnectedComponentsData.getRandomOddEvenEdges((int)10000, (int)1000, (long)3287269182979823L).split("\n")).flatMap((FlatMapFunction)new EdgeParser());
        MapOperator verticesWithInitialId = vertices.map((MapFunction)new ConnectedComponents.DuplicateValue());
        DeltaIteration iteration = verticesWithInitialId.iterateDelta((DataSet)verticesWithInitialId, 100, new int[]{0});
        CoGroupOperator changes = iteration.getWorkset().join((DataSet)edges).where(new int[]{0}).equalTo(new int[]{0}).with((JoinFunction)new ConnectedComponents.NeighborWithComponentIDJoin()).coGroup((DataSet)iteration.getSolutionSet()).where(new int[]{0}).equalTo(new int[]{0}).with((CoGroupFunction)new MinIdAndUpdate());
        DataSet result = iteration.closeWith((DataSet)changes, (DataSet)changes);
        ArrayList resutTuples = new ArrayList();
        result.output((OutputFormat)new LocalCollectionOutputFormat(resutTuples));
        env.execute();
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"0"})
    @FunctionAnnotation.ForwardedFieldsSecond(value={"0"})
    private static final class MinIdAndUpdate
    extends RichCoGroupFunction<Tuple2<Long, Long>, Tuple2<Long, Long>, Tuple2<Long, Long>> {
        private MinIdAndUpdate() {
        }

        public void coGroup(Iterable<Tuple2<Long, Long>> candidates, Iterable<Tuple2<Long, Long>> current, Collector<Tuple2<Long, Long>> out) {
            Iterator<Tuple2<Long, Long>> iterator = current.iterator();
            if (!iterator.hasNext()) {
                throw new RuntimeException("Error: Id not encountered before.");
            }
            Tuple2<Long, Long> old = iterator.next();
            long minimumComponentID = Long.MAX_VALUE;
            for (Tuple2<Long, Long> candidate : candidates) {
                long candidateComponentID = (Long)candidate.f1;
                if (candidateComponentID >= minimumComponentID) continue;
                minimumComponentID = candidateComponentID;
            }
            if (minimumComponentID < (Long)old.f1) {
                old.f1 = minimumComponentID;
                out.collect(old);
            }
        }
    }

    private static final class EdgeParser
    extends RichFlatMapFunction<String, Tuple2<Long, Long>> {
        private EdgeParser() {
        }

        public void flatMap(String value, Collector<Tuple2<Long, Long>> out) throws Exception {
            String[] parts = value.split(" ");
            long v1 = Long.parseLong(parts[0]);
            long v2 = Long.parseLong(parts[1]);
            out.collect((Object)new Tuple2((Object)v1, (Object)v2));
            out.collect((Object)new Tuple2((Object)v2, (Object)v1));
        }
    }

    private static final class VertexParser
    extends RichMapFunction<String, Long> {
        private VertexParser() {
        }

        public Long map(String value) throws Exception {
            return Long.parseLong(value);
        }
    }
}

