/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.example.java;

import java.io.File;
import java.util.UUID;
import org.apache.flink.examples.java.graph.PageRank;
import org.apache.flink.test.util.MultipleProgramsTestBaseJUnit4;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.util.FileUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PageRankITCase
extends MultipleProgramsTestBaseJUnit4 {
    private String verticesPath;
    private String edgesPath;
    private String resultPath;
    private String expected;
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    public PageRankITCase(MultipleProgramsTestBaseJUnit4.TestExecutionMode mode) {
        super(mode);
    }

    @Before
    public void before() throws Exception {
        File folder = this.tempFolder.newFolder();
        File resultFile = new File(folder, UUID.randomUUID().toString());
        this.resultPath = resultFile.toURI().toString();
        File verticesFile = this.tempFolder.newFile();
        FileUtils.writeFileUtf8((File)verticesFile, (String)"1\n2\n5\n3\n4");
        File edgesFile = this.tempFolder.newFile();
        FileUtils.writeFileUtf8((File)edgesFile, (String)"2 1\n5 2\n5 4\n4 3\n4 2\n1 4\n1 2\n1 3\n3 5\n");
        this.verticesPath = verticesFile.toURI().toString();
        this.edgesPath = edgesFile.toURI().toString();
    }

    @After
    public void after() throws Exception {
        TestBaseUtils.compareKeyValuePairsWithDelta((String)this.expected, (String)this.resultPath, (String)" ", (double)0.01);
    }

    @Test
    public void testPageRankSmallNumberOfIterations() throws Exception {
        PageRank.main((String[])new String[]{"--pages", this.verticesPath, "--links", this.edgesPath, "--output", this.resultPath, "--numPages", "5", "--iterations", "3"});
        this.expected = "1 0.237\n2 0.248\n3 0.173\n4 0.175\n5 0.165";
    }

    @Test
    public void testPageRankWithConvergenceCriterion() throws Exception {
        PageRank.main((String[])new String[]{"--pages", this.verticesPath, "--links", this.edgesPath, "--output", this.resultPath, "--numPages", "5", "--vertices", "1000"});
        this.expected = "1 0.238\n2 0.244\n3 0.170\n4 0.171\n5 0.174";
    }
}

