/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.example.client;

import java.time.Duration;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.Semaphore;
import org.apache.flink.api.common.JobID;
import org.apache.flink.client.deployment.StandaloneClusterId;
import org.apache.flink.client.program.rest.RestClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.core.testutils.CheckedThread;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphTestUtils;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.testutils.MiniClusterResource;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class JobRetrievalITCase
extends TestLogger {
    private static final Semaphore lock = new Semaphore(1);
    @ClassRule
    public static final MiniClusterResource CLUSTER = new MiniClusterResource(new MiniClusterResourceConfiguration.Builder().setNumberTaskManagers(1).setNumberSlotsPerTaskManager(4).build());
    private RestClusterClient<StandaloneClusterId> client;

    @Before
    public void setUp() throws Exception {
        Configuration clientConfig = new Configuration();
        clientConfig.set(RestOptions.RETRY_MAX_ATTEMPTS, (Object)0);
        clientConfig.set(RestOptions.RETRY_DELAY, (Object)Duration.ofMillis(0L));
        clientConfig.addAll((Configuration)CLUSTER.getClientConfiguration());
        this.client = new RestClusterClient(clientConfig, (Object)StandaloneClusterId.getInstance());
    }

    @After
    public void tearDown() {
        if (this.client != null) {
            this.client.close();
        }
    }

    @Test
    public void testJobRetrieval() throws Exception {
        JobVertex imalock = new JobVertex("imalock");
        imalock.setInvokableClass(SemaphoreInvokable.class);
        imalock.setParallelism(1);
        JobGraph jobGraph = JobGraphTestUtils.streamingJobGraph((JobVertex[])new JobVertex[]{imalock});
        final JobID jobId = jobGraph.getJobID();
        lock.acquire();
        this.client.submitJob(jobGraph).get();
        CheckedThread resumingThread = new CheckedThread("Flink-Job-Retriever"){

            public void go() throws Exception {
                Assert.assertNotNull(JobRetrievalITCase.this.client.requestJobResult(jobId).get());
            }
        };
        while (((Collection)this.client.listJobs().get()).isEmpty()) {
            Thread.sleep(50L);
        }
        resumingThread.start();
        while (resumingThread.getState() != Thread.State.WAITING) {
            Thread.sleep(10L);
        }
        lock.release();
        resumingThread.sync();
    }

    @Test
    public void testNonExistingJobRetrieval() throws Exception {
        block2: {
            JobID jobID = new JobID();
            try {
                this.client.requestJobResult(jobID).get();
                Assert.fail();
            }
            catch (Exception exception) {
                Optional expectedCause = ExceptionUtils.findThrowable((Throwable)exception, candidate -> candidate.getMessage() != null && candidate.getMessage().contains("Could not find Flink job"));
                if (expectedCause.isPresent()) break block2;
                throw exception;
            }
        }
    }

    public static class SemaphoreInvokable
    extends AbstractInvokable {
        public SemaphoreInvokable(Environment environment) {
            super(environment);
        }

        public void invoke() throws Exception {
            lock.acquire();
            lock.release();
        }
    }
}

