/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.util;

import java.io.Serializable;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.Utils;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.util.CollectionDataSets$;
import org.apache.flink.api.scala.utils.package$;
import org.apache.flink.test.util.MultipleProgramsTestBaseJUnit4;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0001\u0002\u0001\u001f\t\u0011B)\u0019;b'\u0016$X\u000b^5mg&#6)Y:f\u0015\t\u0019A!\u0001\u0003vi&d'BA\u0003\u0007\u0003\u0015\u00198-\u00197b\u0015\t9\u0001\"A\u0002ba&T!!\u0003\u0006\u0002\u000b\u0019d\u0017N\\6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012+5\t!C\u0003\u0002\u0004')\u0011A\u0003C\u0001\u0005i\u0016\u001cH/\u0003\u0002\u0017%\tqR*\u001e7uSBdW\r\u0015:pOJ\fWn\u001d+fgR\u0014\u0015m]3K+:LG\u000f\u000e\u0005\t1\u0001\u0011\t\u0011)A\u00053\u0005!Qn\u001c3f!\tQRD\u0004\u0002\u00127%\u0011ADE\u0001\u001f\u001bVdG/\u001b9mKB\u0013xn\u001a:b[N$Vm\u001d;CCN,'*\u00168jiRJ!AH\u0010\u0003#Q+7\u000f^#yK\u000e,H/[8o\u001b>$WM\u0003\u0002\u001d%!)\u0011\u0005\u0001C\u0001E\u00051A(\u001b8jiz\"\"aI\u0013\u0011\u0005\u0011\u0002Q\"\u0001\u0002\t\u000ba\u0001\u0003\u0019A\r\t\u000b\u001d\u0002A\u0011\u0001\u0015\u0002!Q,7\u000f\u001e.ja^KG\u000f[%oI\u0016DH#A\u0015\u0011\u0005)bS\"A\u0016\u000b\u0003\u0015I!!L\u0016\u0003\tUs\u0017\u000e\u001e\u0015\u0004M=r\u0004c\u0001\u00161e%\u0011\u0011g\u000b\u0002\u0007i\"\u0014xn^:\u0011\u0005MZdB\u0001\u001b:\u001d\t)\u0004(D\u00017\u0015\t9d\"\u0001\u0004=e>|GOP\u0005\u0002\u000b%\u0011!hK\u0001\ba\u0006\u001c7.Y4f\u0013\taTHA\u0005Fq\u000e,\u0007\u000f^5p]*\u0011!hK\u0012\u0002e!\u0012a\u0005\u0011\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u00072\tQA[;oSRL!!\u0012\"\u0003\tQ+7\u000f\u001e\u0005\u0006\u000f\u0002!\t\u0001K\u0001\u0014i\u0016\u001cHOW5q/&$\b.\u00168jcV,\u0017\n\u001a\u0015\u0004\r>r\u0004F\u0001$A\u0011\u0015Y\u0005\u0001\"\u0001)\u0003\t\"Xm\u001d;J]R,w-\u001a:ECR\f7+\u001a;DQ\u0016\u001c7n];n\u0011\u0006\u001c\bnQ8eK\"\u0012!\n\u0011\u0005\u0006\u001d\u0002!\t\u0001K\u0001\u001ei\u0016\u001cHoQ8v]R,E.Z7f]R\u001c\b+\u001a:QCJ$\u0018\u000e^5p]\"\u001aQj\f )\u00055\u0003\u0005\u0006\u0002\u0001S1f\u0003\"a\u0015,\u000e\u0003QS!!\u0016\"\u0002\rI,hN\\3s\u0013\t9FKA\u0004Sk:<\u0016\u000e\u001e5\u0002\u000bY\fG.^3$\u0003i\u0003\"a\u00170\u000e\u0003qS!!\u0018\"\u0002\u000fI,hN\\3sg&\u0011q\f\u0018\u0002\u000e!\u0006\u0014\u0018-\\3uKJL'0\u001a3")
public class DataSetUtilsITCase
extends MultipleProgramsTestBaseJUnit4 {
    @Test
    public void testZipWithIndex() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        long expectedSize = 100L;
        DataSet numbers = env.generateSequence(0L, expectedSize - 1L);
        Seq result = package$.MODULE$.DataSetUtils(numbers, (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), ClassTag$.MODULE$.Long()).zipWithIndex().collect();
        Assert.assertEquals((long)expectedSize, (long)result.size());
        ((TraversableLike)((IterableLike)result.sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1._1$mcJ$sp()), (Ordering)Ordering.Long$.MODULE$)).zipWithIndex(Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)DataSetUtilsITCase.$anonfun$testZipWithIndex$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            DataSetUtilsITCase.$anonfun$testZipWithIndex$3(x$2);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testZipWithUniqueId() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        long expectedSize = 100L;
        DataSet numbers = env.generateSequence(1L, expectedSize);
        Set result = ((TraversableOnce)package$.MODULE$.DataSetUtils(numbers, (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), ClassTag$.MODULE$.Long()).zipWithUniqueId().collect().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3._1$mcJ$sp()), Seq$.MODULE$.canBuildFrom())).toSet();
        Assert.assertEquals((long)expectedSize, (long)result.size());
    }

    @Test
    public void testIntegerDataSetChecksumHashCode() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Object> ds = CollectionDataSets$.MODULE$.getIntDataSet(env);
        Utils.ChecksumHashCode checksum = package$.MODULE$.DataSetUtils(ds, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE), ClassTag$.MODULE$.Int()).checksumHashCode();
        Assert.assertEquals((long)checksum.getCount(), (long)15L);
        Assert.assertEquals((long)checksum.getChecksum(), (long)55L);
    }

    @Test
    public void testCountElementsPerPartition() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        long expectedSize = 100L;
        DataSet numbers = env.generateSequence(0L, expectedSize - 1L);
        DataSet ds = package$.MODULE$.DataSetUtils(numbers, (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), ClassTag$.MODULE$.Long()).countElementsPerPartition();
        Assert.assertEquals((long)env.getParallelism(), (long)ds.collect().size());
        Assert.assertEquals((long)expectedSize, (long)((Tuple2)ds.sum(1).collect().head())._2$mcJ$sp());
    }

    public static final /* synthetic */ boolean $anonfun$testZipWithIndex$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2;
        Tuple2 tuple22 = check$ifrefutable$1;
        boolean bl = tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testZipWithIndex$3(Tuple2 x$2) {
        int expected;
        Tuple2 tuple2;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = x$2;
                if (tuple22 == null) break block2;
                tuple2 = (Tuple2)tuple22._1();
                expected = tuple22._2$mcI$sp();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        long index = tuple2._1$mcJ$sp();
        Assert.assertEquals((long)expected, (long)index);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public DataSetUtilsITCase(MultipleProgramsTestBaseJUnit4.TestExecutionMode mode) {
        super(mode);
    }
}

