/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.operators;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichFilterFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.AggregateDataSet;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.operators.PartitionITCase$;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.api.scala.util.CollectionDataSets;
import org.apache.flink.api.scala.util.CollectionDataSets$;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.test.util.MultipleProgramsTestBaseJUnit4;
import org.apache.flink.test.util.TestBaseUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple1;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001B\u0001\u0003\u0001=\u0011q\u0002U1si&$\u0018n\u001c8J)\u000e\u000b7/\u001a\u0006\u0003\u0007\u0011\t\u0011b\u001c9fe\u0006$xN]:\u000b\u0005\u00151\u0011!B:dC2\f'BA\u0004\t\u0003\r\t\u0007/\u001b\u0006\u0003\u0013)\tQA\u001a7j].T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011C\u0001\u0001\u0011!\t\tb#D\u0001\u0013\u0015\t\u0019B#\u0001\u0003vi&d'BA\u000b\t\u0003\u0011!Xm\u001d;\n\u0005]\u0011\"AH'vYRL\u0007\u000f\\3Qe><'/Y7t)\u0016\u001cHOQ1tK*+f.\u001b;5\u0011!I\u0002A!A!\u0002\u0013Q\u0012\u0001B7pI\u0016\u0004\"a\u0007\u0010\u000f\u0005Ea\u0012BA\u000f\u0013\u0003yiU\u000f\u001c;ja2,\u0007K]8he\u0006l7\u000fV3ti\n\u000b7/\u001a&V]&$H'\u0003\u0002 A\t\tB+Z:u\u000bb,7-\u001e;j_:lu\u000eZ3\u000b\u0005u\u0011\u0002\"\u0002\u0012\u0001\t\u0003\u0019\u0013A\u0002\u001fj]&$h\b\u0006\u0002%MA\u0011Q\u0005A\u0007\u0002\u0005!)\u0011$\ta\u00015!9\u0001\u0006\u0001a\u0001\n\u0013I\u0013A\u0003:fgVdG\u000fU1uQV\t!\u0006\u0005\u0002,g9\u0011A&\r\t\u0003[Aj\u0011A\f\u0006\u0003_9\ta\u0001\u0010:p_Rt$\"A\u0003\n\u0005I\u0002\u0014A\u0002)sK\u0012,g-\u0003\u00025k\t11\u000b\u001e:j]\u001eT!A\r\u0019\t\u000f]\u0002\u0001\u0019!C\u0005q\u0005q!/Z:vYR\u0004\u0016\r\u001e5`I\u0015\fHCA\u001d>!\tQ4(D\u00011\u0013\ta\u0004G\u0001\u0003V]&$\bb\u0002 7\u0003\u0003\u0005\rAK\u0001\u0004q\u0012\n\u0004B\u0002!\u0001A\u0003&!&A\u0006sKN,H\u000e\u001e)bi\"\u0004\u0003b\u0002\"\u0001\u0001\u0004%I!K\u0001\tKb\u0004Xm\u0019;fI\"9A\t\u0001a\u0001\n\u0013)\u0015\u0001D3ya\u0016\u001cG/\u001a3`I\u0015\fHCA\u001dG\u0011\u001dq4)!AA\u0002)Ba\u0001\u0013\u0001!B\u0013Q\u0013!C3ya\u0016\u001cG/\u001a3!\u0011\u001dQ\u0005A1A\u0005\n-\u000b1b\u0018;f[B4u\u000e\u001c3feV\tA\n\u0005\u0002N%6\taJ\u0003\u0002P!\u0006)!/\u001e7fg*\u0011\u0011\u000bD\u0001\u0006UVt\u0017\u000e^\u0005\u0003':\u0013q\u0002V3na>\u0014\u0018M]=G_2$WM\u001d\u0005\u0007+\u0002\u0001\u000b\u0011\u0002'\u0002\u0019}#X-\u001c9G_2$WM\u001d\u0011\t\u000b]\u0003A\u0011A&\u0002\u0015Q,W\u000e\u001d$pY\u0012,'\u000f\u000b\u0002W3B\u0011!lW\u0007\u0002!&\u0011A\f\u0015\u0002\u0005%VdW\rC\u0003_\u0001\u0011\u0005q,\u0001\u0004cK\u001a|'/\u001a\u000b\u0002s!\u0012Q,\u0019\t\u00035\nL!a\u0019)\u0003\r\t+gm\u001c:f\u0011\u0015)\u0007\u0001\"\u0001`\u0003\u0015\tg\r^3sQ\t!w\r\u0005\u0002[Q&\u0011\u0011\u000e\u0015\u0002\u0006\u0003\u001a$XM\u001d\u0005\u0006W\u0002!\taX\u0001\u0017i\u0016\u001cH/R7qifD\u0015m\u001d5QCJ$\u0018\u000e^5p]\"\u0012!.\u001c\t\u00035:L!a\u001c)\u0003\tQ+7\u000f\u001e\u0005\u0006c\u0002!\taX\u0001\u0018i\u0016\u001cH/R7qif\u0014\u0016M\\4f!\u0006\u0014H/\u001b;j_:D#\u0001]7\t\u000bQ\u0004A\u0011A0\u0002;Q,7\u000f\u001e%bg\"\u0004\u0016M\u001d;ji&|gNQ=UkBdWMR5fY\u0012D#a]7\t\u000b]\u0004A\u0011A0\u0002=Q,7\u000f\u001e*b]\u001e,\u0007+\u0019:uSRLwN\u001c\"z)V\u0004H.\u001a$jK2$\u0007F\u0001<n\u0011\u0015Q\b\u0001\"\u0001`\u0003y!Xm\u001d;ICND\u0007+\u0019:uSRLwN\u001c\"z\u0017\u0016L8+\u001a7fGR|'\u000f\u000b\u0002z[\")Q\u0010\u0001C\u0001?\u0006yB/Z:u%\u0006tw-\u001a)beRLG/[8o\u0005f\\U-_*fY\u0016\u001cGo\u001c:)\u0005ql\u0007BBA\u0001\u0001\u0011\u0005q,A\u000buKN$hi\u001c:dK\u0012\u0014VMY1mC:\u001c\u0017N\\4)\u0005}l\u0007BBA\u0004\u0001\u0011\u0005q,A\u001buKN$X*\u00199QCJ$\u0018\u000e^5p]\u00063G/\u001a:SKB\f'\u000f^5uS>t\u0007*Y:D_J\u0014Xm\u0019;QCJ\fG\u000e\\3mSNl\u0007fAA\u0003[\"1\u0011Q\u0002\u0001\u0005\u0002}\u000ba\u0007^3ti6\u000b\u0007\u000fU1si&$\u0018n\u001c8BMR,'OU3qCJ$\u0018\u000e^5p]\"\u000b7oQ8se\u0016\u001cG\u000fU1sC2dW\r\\5t[JB3!a\u0003n\u0011\u0019\t\u0019\u0002\u0001C\u0001?\u0006aC/Z:u\u001b\u0006\u0004\u0018I\u001a;feJ+\u0007/\u0019:uSRLwN\u001c%bg\u000e{'O]3diB\u000b'/\u00197mK2L7/\u001c\u0015\u0004\u0003#i\u0007BBA\r\u0001\u0011\u0005q,A\u0017uKN$X*\u00199BMR,'OU3qCJ$\u0018\u000e^5p]\"\u000b7oQ8se\u0016\u001cG\u000fU1sC2dW\r\\5t[JB3!a\u0006n\u0011\u0019\ty\u0002\u0001C\u0001?\u0006yC/Z:u\r&dG/\u001a:BMR,'OU3qCJ$\u0018\u000e^5p]\"\u000b7oQ8se\u0016\u001cG\u000fU1sC2dW\r\\5t[\"\u001a\u0011QD7\t\r\u0005\u0015\u0002\u0001\"\u0001`\u0003A\"Xm\u001d;GS2$XM]!gi\u0016\u0014(+\u001a9beRLG/[8o\u0011\u0006\u001c8i\u001c:sK\u000e$\b+\u0019:bY2,G.[:ne!\u001a\u00111E7\t\r\u0005-\u0002\u0001\"\u0001`\u0003m!Xm\u001d;ICND\u0007+\u0019:uSRLwN\u001c(fgR,G\rU8k_\"\u001a\u0011\u0011F7\t\r\u0005E\u0002\u0001\"\u0001`\u0003q!Xm\u001d;SC:<W\rU1si&$\u0018n\u001c8OKN$X\r\u001a)pU>D3!a\fnQ\u001d\u0001\u0011qGA\"\u0003\u000b\u0002B!!\u000f\u0002@5\u0011\u00111\b\u0006\u0004\u0003{\u0001\u0016A\u0002:v]:,'/\u0003\u0003\u0002B\u0005m\"a\u0002*v]^KG\u000f[\u0001\u0006m\u0006dW/Z\u0012\u0003\u0003\u000f\u0002B!!\u0013\u0002P5\u0011\u00111\n\u0006\u0004\u0003\u001b\u0002\u0016a\u0002:v]:,'o]\u0005\u0005\u0003#\nYEA\u0007QCJ\fW.\u001a;fe&TX\r\u001a")
public class PartitionITCase
extends MultipleProgramsTestBaseJUnit4 {
    private final MultipleProgramsTestBaseJUnit4.TestExecutionMode mode;
    private String resultPath;
    private String expected;
    private final TemporaryFolder _tempFolder;

    private String resultPath() {
        return this.resultPath;
    }

    private void resultPath_$eq(String x$1) {
        this.resultPath = x$1;
    }

    private String expected() {
        return this.expected;
    }

    private void expected_$eq(String x$1) {
        this.expected = x$1;
    }

    private TemporaryFolder _tempFolder() {
        return this._tempFolder;
    }

    @Rule
    public TemporaryFolder tempFolder() {
        return this._tempFolder();
    }

    @Before
    public void before() {
        this.resultPath_$eq(this.tempFolder().newFile().toURI().toString());
    }

    @After
    public void after() {
        TestBaseUtils.compareResultsByLinesInMemory((String)this.expected(), (String)this.resultPath());
    }

    @Test
    public void testEmptyHashPartition() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet ds = env.fromCollection((Iterable)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), ClassTag$.MODULE$.apply(Tuple1.class), (TypeInformation)new CaseClassTypeInfo<Tuple1<String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$14 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple1<String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple1<String>> unused = new ScalaCaseClassSerializer<Tuple1<String>>(this, fieldSerializers){

                    public Tuple1<String> createInstance(Object[] fields) {
                        return new Tuple1((Object)((String)fields[0]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple1<String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.api.scala.operators.PartitionITCase$$anon$14 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        DataSet unique = ds.partitionByHash((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        unique.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("");
    }

    @Test
    public void testEmptyRangePartition() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet ds = env.fromCollection((Iterable)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), ClassTag$.MODULE$.apply(Tuple1.class), (TypeInformation)new CaseClassTypeInfo<Tuple1<String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$15 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple1<String>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple1<String>> unused = new ScalaCaseClassSerializer<Tuple1<String>>(this, fieldSerializers){

                    public Tuple1<String> createInstance(Object[] fields) {
                        return new Tuple1((Object)((String)fields[0]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple1<String>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.api.scala.operators.PartitionITCase$$anon$15 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        DataSet unique = ds.partitionByRange((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        unique.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("");
    }

    @Test
    public void testHashPartitionByTupleField() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet unique = ds.partitionByHash((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})).mapPartition((Function1 & Serializable & scala.Serializable)x$1 -> x$1.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)PartitionITCase.$anonfun$testHashPartitionByTupleField$2(x$2))).toSet(), (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), ClassTag$.MODULE$.Long());
        unique.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("1\n2\n3\n4\n5\n6\n");
    }

    @Test
    public void testRangePartitionByTupleField() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet unique = ds.partitionByRange((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})).mapPartition((Function1 & Serializable & scala.Serializable)x$3 -> x$3.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)PartitionITCase.$anonfun$testRangePartitionByTupleField$2(x$4))).toSet(), (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), ClassTag$.MODULE$.Long());
        unique.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("1\n2\n3\n4\n5\n6\n");
    }

    @Test
    public void testHashPartitionByKeySelector() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet unique = ds.partitionByHash((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)PartitionITCase.$anonfun$testHashPartitionByKeySelector$1(x$5)), (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE)).mapPartition((Function1 & Serializable & scala.Serializable)x$6 -> x$6.map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)PartitionITCase.$anonfun$testHashPartitionByKeySelector$3(x$7))).toSet(), (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), ClassTag$.MODULE$.Long());
        unique.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("1\n2\n3\n4\n5\n6\n");
    }

    @Test
    public void testRangePartitionByKeySelector() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet unique = ds.partitionByRange((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)PartitionITCase.$anonfun$testRangePartitionByKeySelector$1(x$8)), (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE)).mapPartition((Function1 & Serializable & scala.Serializable)x$9 -> x$9.map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)PartitionITCase.$anonfun$testRangePartitionByKeySelector$3(x$10))).toSet(), (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), ClassTag$.MODULE$.Long());
        unique.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("1\n2\n3\n4\n5\n6\n");
    }

    @Test
    public void testForcedRebalancing() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet ds = env.generateSequence(1L, 3000L);
        DataSet skewed = ds.filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$11 -> x$11 > 780L);
        DataSet rebalanced = skewed.rebalance();
        DataSet countsInPartition = rebalanced.map((MapFunction)new RichMapFunction<Object, Tuple2<Object, Object>>(null){

            public Tuple2<Object, Object> map(long in) {
                return new Tuple2.mcIJ.sp(this.getRuntimeContext().getTaskInfo().getIndexOfThisSubtask(), 1L);
            }
        }, (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$16 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.api.scala.operators.PartitionITCase$$anon$16 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).groupBy((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})).reduce((Function2 & Serializable & scala.Serializable)(v1, v2) -> new Tuple2.mcIJ.sp(v1._1$mcI$sp(), v1._2$mcJ$sp() + v2._2$mcJ$sp())).map((Function1 & Serializable & scala.Serializable)in -> new Tuple2.mcIJ.sp(in._1$mcI$sp(), in._2$mcJ$sp() / 10L), (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$17 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.api.scala.operators.PartitionITCase$$anon$17 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        countsInPartition.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        int numPerPartition = 2220 / env.getParallelism() / 10;
        this.expected_$eq("");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), env.getParallelism()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.expected_$eq(new StringBuilder(0).append(this.expected()).append(new StringBuilder(4).append("(").append(i).append(",").append(numPerPartition).append(")\n").toString()).toString()));
    }

    @Test
    public void testMapPartitionAfterRepartitionHasCorrectParallelism() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        env.setParallelism(1);
        DataSet unique = ds.partitionByHash((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})).setParallelism(4).mapPartition((Function1 & Serializable & scala.Serializable)x$12 -> x$12.map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)PartitionITCase.$anonfun$testMapPartitionAfterRepartitionHasCorrectParallelism$2(x$13))).toSet(), (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), ClassTag$.MODULE$.Long());
        unique.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("1\n2\n3\n4\n5\n6\n");
    }

    @Test
    public void testMapPartitionAfterRepartitionHasCorrectParallelism2() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        env.setParallelism(1);
        DataSet unique = ds.partitionByRange((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})).setParallelism(4).mapPartition((Function1 & Serializable & scala.Serializable)x$14 -> x$14.map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToLong((long)PartitionITCase.$anonfun$testMapPartitionAfterRepartitionHasCorrectParallelism2$2(x$15))).toSet(), (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), ClassTag$.MODULE$.Long());
        unique.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("1\n2\n3\n4\n5\n6\n");
    }

    @Test
    public void testMapAfterRepartitionHasCorrectParallelism() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        env.setParallelism(1);
        AggregateDataSet count = ds.partitionByHash((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})).setParallelism(4).map((MapFunction)new RichMapFunction<Tuple3<Object, Object, String>, Tuple1<Object>>(null){
            private boolean first;

            public boolean first() {
                return this.first;
            }

            public void first_$eq(boolean x$1) {
                this.first = x$1;
            }

            public Tuple1<Object> map(Tuple3<Object, Object, String> in) {
                Tuple1.mcI.sp sp2;
                if (this.first()) {
                    this.first_$eq(false);
                    sp2 = new Tuple1.mcI.sp(1);
                } else {
                    sp2 = new Tuple1.mcI.sp(0);
                }
                return sp2;
            }
            {
                this.first = true;
            }
        }, (TypeInformation)new CaseClassTypeInfo<Tuple1<Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$18 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple1<Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple1<Object>> unused = new ScalaCaseClassSerializer<Tuple1<Object>>(this, fieldSerializers){

                    public Tuple1<Object> createInstance(Object[] fields) {
                        return new Tuple1.mcI.sp(BoxesRunTime.unboxToInt((Object)fields[0]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple1<Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.api.scala.operators.PartitionITCase$$anon$18 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, ClassTag$.MODULE$.apply(Tuple1.class)).sum(0);
        count.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        MultipleProgramsTestBaseJUnit4.TestExecutionMode testExecutionMode = this.mode;
        MultipleProgramsTestBaseJUnit4.TestExecutionMode testExecutionMode2 = MultipleProgramsTestBaseJUnit4.TestExecutionMode.COLLECTION;
        this.expected_$eq(!(testExecutionMode != null ? !testExecutionMode.equals(testExecutionMode2) : testExecutionMode2 != null) ? "(1)\n" : "(4)\n");
    }

    @Test
    public void testMapAfterRepartitionHasCorrectParallelism2() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        env.setParallelism(1);
        AggregateDataSet count = ds.partitionByRange((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})).setParallelism(4).map((MapFunction)new RichMapFunction<Tuple3<Object, Object, String>, Tuple1<Object>>(null){
            private boolean first;

            public boolean first() {
                return this.first;
            }

            public void first_$eq(boolean x$1) {
                this.first = x$1;
            }

            public Tuple1<Object> map(Tuple3<Object, Object, String> in) {
                Tuple1.mcI.sp sp2;
                if (this.first()) {
                    this.first_$eq(false);
                    sp2 = new Tuple1.mcI.sp(1);
                } else {
                    sp2 = new Tuple1.mcI.sp(0);
                }
                return sp2;
            }
            {
                this.first = true;
            }
        }, (TypeInformation)new CaseClassTypeInfo<Tuple1<Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$19 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple1<Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple1<Object>> unused = new ScalaCaseClassSerializer<Tuple1<Object>>(this, fieldSerializers){

                    public Tuple1<Object> createInstance(Object[] fields) {
                        return new Tuple1.mcI.sp(BoxesRunTime.unboxToInt((Object)fields[0]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple1<Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.api.scala.operators.PartitionITCase$$anon$19 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, ClassTag$.MODULE$.apply(Tuple1.class)).sum(0);
        count.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        MultipleProgramsTestBaseJUnit4.TestExecutionMode testExecutionMode = this.mode;
        MultipleProgramsTestBaseJUnit4.TestExecutionMode testExecutionMode2 = MultipleProgramsTestBaseJUnit4.TestExecutionMode.COLLECTION;
        this.expected_$eq(!(testExecutionMode != null ? !testExecutionMode.equals(testExecutionMode2) : testExecutionMode2 != null) ? "(1)\n" : "(4)\n");
    }

    @Test
    public void testFilterAfterRepartitionHasCorrectParallelism() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        env.setParallelism(1);
        AggregateDataSet count = ds.partitionByHash((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})).setParallelism(4).filter((FilterFunction)new RichFilterFunction<Tuple3<Object, Object, String>>(null){
            private boolean first;

            public boolean first() {
                return this.first;
            }

            public void first_$eq(boolean x$1) {
                this.first = x$1;
            }

            public boolean filter(Tuple3<Object, Object, String> in) {
                boolean bl;
                if (this.first()) {
                    this.first_$eq(false);
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }
            {
                this.first = true;
            }
        }).map((Function1 & Serializable & scala.Serializable)x$16 -> new Tuple1.mcI.sp(1), (TypeInformation)new CaseClassTypeInfo<Tuple1<Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$20 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple1<Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple1<Object>> unused = new ScalaCaseClassSerializer<Tuple1<Object>>(this, fieldSerializers){

                    public Tuple1<Object> createInstance(Object[] fields) {
                        return new Tuple1.mcI.sp(BoxesRunTime.unboxToInt((Object)fields[0]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple1<Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.api.scala.operators.PartitionITCase$$anon$20 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, ClassTag$.MODULE$.apply(Tuple1.class)).sum(0);
        count.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        MultipleProgramsTestBaseJUnit4.TestExecutionMode testExecutionMode = this.mode;
        MultipleProgramsTestBaseJUnit4.TestExecutionMode testExecutionMode2 = MultipleProgramsTestBaseJUnit4.TestExecutionMode.COLLECTION;
        this.expected_$eq(!(testExecutionMode != null ? !testExecutionMode.equals(testExecutionMode2) : testExecutionMode2 != null) ? "(1)\n" : "(4)\n");
    }

    @Test
    public void testFilterAfterRepartitionHasCorrectParallelism2() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        env.setParallelism(1);
        AggregateDataSet count = ds.partitionByRange((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})).setParallelism(4).filter((FilterFunction)new RichFilterFunction<Tuple3<Object, Object, String>>(null){
            private boolean first;

            public boolean first() {
                return this.first;
            }

            public void first_$eq(boolean x$1) {
                this.first = x$1;
            }

            public boolean filter(Tuple3<Object, Object, String> in) {
                boolean bl;
                if (this.first()) {
                    this.first_$eq(false);
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }
            {
                this.first = true;
            }
        }).map((Function1 & Serializable & scala.Serializable)x$17 -> new Tuple1.mcI.sp(1), (TypeInformation)new CaseClassTypeInfo<Tuple1<Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$21 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple1<Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$8[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple1<Object>> unused = new ScalaCaseClassSerializer<Tuple1<Object>>(this, fieldSerializers){

                    public Tuple1<Object> createInstance(Object[] fields) {
                        return new Tuple1.mcI.sp(BoxesRunTime.unboxToInt((Object)fields[0]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple1<Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$8(org.apache.flink.api.scala.operators.PartitionITCase$$anon$21 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, ClassTag$.MODULE$.apply(Tuple1.class)).sum(0);
        count.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        MultipleProgramsTestBaseJUnit4.TestExecutionMode testExecutionMode = this.mode;
        MultipleProgramsTestBaseJUnit4.TestExecutionMode testExecutionMode2 = MultipleProgramsTestBaseJUnit4.TestExecutionMode.COLLECTION;
        this.expected_$eq(!(testExecutionMode != null ? !testExecutionMode.equals(testExecutionMode2) : testExecutionMode2 != null) ? "(1)\n" : "(4)\n");
    }

    @Test
    public void testHashPartitionNestedPojo() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setParallelism(3);
        DataSet<CollectionDataSets.POJO> ds = CollectionDataSets$.MODULE$.getDuplicatePojoDataSet(env);
        DataSet uniqLongs = ds.partitionByHash("nestedPojo.longNumber", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).setParallelism(4).mapPartition((Function1 & Serializable & scala.Serializable)x$18 -> x$18.map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToLong((long)PartitionITCase.$anonfun$testHashPartitionNestedPojo$2(x$19))).toSet(), (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), ClassTag$.MODULE$.Long());
        uniqLongs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("10000\n20000\n30000\n");
    }

    @Test
    public void testRangePartitionNestedPojo() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setParallelism(3);
        DataSet<CollectionDataSets.POJO> ds = CollectionDataSets$.MODULE$.getDuplicatePojoDataSet(env);
        DataSet uniqLongs = ds.partitionByRange("nestedPojo.longNumber", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).setParallelism(4).mapPartition((Function1 & Serializable & scala.Serializable)x$20 -> x$20.map((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToLong((long)PartitionITCase.$anonfun$testRangePartitionNestedPojo$2(x$21))).toSet(), (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), ClassTag$.MODULE$.Long());
        uniqLongs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("10000\n20000\n30000\n");
    }

    public static final /* synthetic */ long $anonfun$testHashPartitionByTupleField$2(Tuple3 x$2) {
        return BoxesRunTime.unboxToLong((Object)x$2._2());
    }

    public static final /* synthetic */ long $anonfun$testRangePartitionByTupleField$2(Tuple3 x$4) {
        return BoxesRunTime.unboxToLong((Object)x$4._2());
    }

    public static final /* synthetic */ long $anonfun$testHashPartitionByKeySelector$1(Tuple3 x$5) {
        return BoxesRunTime.unboxToLong((Object)x$5._2());
    }

    public static final /* synthetic */ long $anonfun$testHashPartitionByKeySelector$3(Tuple3 x$7) {
        return BoxesRunTime.unboxToLong((Object)x$7._2());
    }

    public static final /* synthetic */ long $anonfun$testRangePartitionByKeySelector$1(Tuple3 x$8) {
        return BoxesRunTime.unboxToLong((Object)x$8._2());
    }

    public static final /* synthetic */ long $anonfun$testRangePartitionByKeySelector$3(Tuple3 x$10) {
        return BoxesRunTime.unboxToLong((Object)x$10._2());
    }

    public static final /* synthetic */ long $anonfun$testMapPartitionAfterRepartitionHasCorrectParallelism$2(Tuple3 x$13) {
        return BoxesRunTime.unboxToLong((Object)x$13._2());
    }

    public static final /* synthetic */ long $anonfun$testMapPartitionAfterRepartitionHasCorrectParallelism2$2(Tuple3 x$15) {
        return BoxesRunTime.unboxToLong((Object)x$15._2());
    }

    public static final /* synthetic */ long $anonfun$testHashPartitionNestedPojo$2(CollectionDataSets.POJO x$19) {
        return x$19.nestedPojo().longNumber();
    }

    public static final /* synthetic */ long $anonfun$testRangePartitionNestedPojo$2(CollectionDataSets.POJO x$21) {
        return x$21.nestedPojo().longNumber();
    }

    public PartitionITCase(MultipleProgramsTestBaseJUnit4.TestExecutionMode mode) {
        this.mode = mode;
        super(mode);
        this.resultPath = null;
        this.expected = null;
        this._tempFolder = new TemporaryFolder();
    }
}

