/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.migration;

import java.util.Collection;
import java.util.LinkedList;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.FlinkVersion;
import org.apache.flink.test.checkpointing.utils.SnapshotMigrationTestBase;
import org.apache.flink.test.util.MigrationTest;
import org.junit.runners.Parameterized;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;

public final class StatefulJobSavepointMigrationITCase$
implements Serializable {
    public static StatefulJobSavepointMigrationITCase$ MODULE$;
    private final int NUM_ELEMENTS;

    static {
        new StatefulJobSavepointMigrationITCase$();
    }

    @Parameterized.Parameters(name="Test snapshot: {0}")
    public Collection<SnapshotMigrationTestBase.SnapshotSpec> createSpecsForTestRuns() {
        return this.internalParameters(null);
    }

    public Collection<SnapshotMigrationTestBase.SnapshotSpec> createSpecsForTestDataGeneration(FlinkVersion version) {
        return this.internalParameters(version);
    }

    /*
     * WARNING - void declaration
     */
    private Collection<SnapshotMigrationTestBase.SnapshotSpec> internalParameters(@Nullable FlinkVersion targetGeneratingVersion) {
        void var3_3;
        BiFunction<FlinkVersion, FlinkVersion, Collection<FlinkVersion>> getFlinkVersions = new BiFunction<FlinkVersion, FlinkVersion, Collection<FlinkVersion>>(targetGeneratingVersion){
            private final FlinkVersion targetGeneratingVersion$1;

            public <V> BiFunction<FlinkVersion, FlinkVersion, V> andThen(Function<? super Collection<FlinkVersion>, ? extends V> x$1) {
                return BiFunction.super.andThen(x$1);
            }

            public Collection<FlinkVersion> apply(FlinkVersion minInclVersion, FlinkVersion maxInclVersion) {
                return this.targetGeneratingVersion$1 != null ? (Collection)FlinkVersion.rangeOf((FlinkVersion)minInclVersion, (FlinkVersion)maxInclVersion).stream().filter(v -> v.equals((Object)$this.targetGeneratingVersion$1)).collect(Collectors.toList()) : FlinkVersion.rangeOf((FlinkVersion)minInclVersion, (FlinkVersion)maxInclVersion);
            }
            {
                this.targetGeneratingVersion$1 = targetGeneratingVersion$1;
            }
        };
        LinkedList<SnapshotMigrationTestBase.SnapshotSpec> parameters = new LinkedList<SnapshotMigrationTestBase.SnapshotSpec>();
        parameters.addAll(SnapshotMigrationTestBase.SnapshotSpec.withVersions("jobmanager", SnapshotMigrationTestBase.SnapshotType.SAVEPOINT_CANONICAL, (Collection)getFlinkVersions.apply(FlinkVersion.v1_8, FlinkVersion.v1_13)));
        parameters.addAll(SnapshotMigrationTestBase.SnapshotSpec.withVersions("hashmap", SnapshotMigrationTestBase.SnapshotType.SAVEPOINT_CANONICAL, (Collection)getFlinkVersions.apply(FlinkVersion.v1_14, MigrationTest.getMostRecentlyPublishedVersion())));
        parameters.addAll(SnapshotMigrationTestBase.SnapshotSpec.withVersions("rocksdb", SnapshotMigrationTestBase.SnapshotType.SAVEPOINT_CANONICAL, (Collection)getFlinkVersions.apply(FlinkVersion.v1_15, MigrationTest.getMostRecentlyPublishedVersion())));
        parameters.addAll(SnapshotMigrationTestBase.SnapshotSpec.withVersions("hashmap", SnapshotMigrationTestBase.SnapshotType.SAVEPOINT_NATIVE, (Collection)getFlinkVersions.apply(FlinkVersion.v1_15, MigrationTest.getMostRecentlyPublishedVersion())));
        parameters.addAll(SnapshotMigrationTestBase.SnapshotSpec.withVersions("rocksdb", SnapshotMigrationTestBase.SnapshotType.SAVEPOINT_NATIVE, (Collection)getFlinkVersions.apply(FlinkVersion.v1_15, MigrationTest.getMostRecentlyPublishedVersion())));
        parameters.addAll(SnapshotMigrationTestBase.SnapshotSpec.withVersions("hashmap", SnapshotMigrationTestBase.SnapshotType.CHECKPOINT, (Collection)getFlinkVersions.apply(FlinkVersion.v1_15, MigrationTest.getMostRecentlyPublishedVersion())));
        parameters.addAll(SnapshotMigrationTestBase.SnapshotSpec.withVersions("rocksdb", SnapshotMigrationTestBase.SnapshotType.CHECKPOINT, (Collection)getFlinkVersions.apply(FlinkVersion.v1_15, MigrationTest.getMostRecentlyPublishedVersion())));
        return var3_3;
    }

    public int NUM_ELEMENTS() {
        return this.NUM_ELEMENTS;
    }

    public String getSnapshotPath(SnapshotMigrationTestBase.SnapshotSpec snapshotSpec) {
        StringBuilder stringBuilder;
        StringBuilder path = new StringBuilder("stateful-scala-udf-migration-itcase");
        path.$plus$plus$eq(new java.lang.StringBuilder(6).append("-flink").append(snapshotSpec.getFlinkVersion()).toString());
        path.$plus$plus$eq(new java.lang.StringBuilder(1).append("-").append(snapshotSpec.getStateBackendType()).toString());
        SnapshotMigrationTestBase.SnapshotType snapshotType = snapshotSpec.getSnapshotType();
        if (((Object)((Object)SnapshotMigrationTestBase.SnapshotType.SAVEPOINT_CANONICAL)).equals((Object)snapshotType)) {
            stringBuilder = path.$plus$plus$eq("-savepoint");
        } else if (((Object)((Object)SnapshotMigrationTestBase.SnapshotType.SAVEPOINT_NATIVE)).equals((Object)snapshotType)) {
            stringBuilder = path.$plus$plus$eq("-savepoint-native");
        } else if (((Object)((Object)SnapshotMigrationTestBase.SnapshotType.CHECKPOINT)).equals((Object)snapshotType)) {
            stringBuilder = path.$plus$plus$eq("-checkpoint");
        } else {
            throw new UnsupportedOperationException();
        }
        return path.toString();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private StatefulJobSavepointMigrationITCase$() {
        MODULE$ = this;
        this.NUM_ELEMENTS = 4;
    }
}

