/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.iterative;

import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.DistinctOperator;
import org.apache.flink.api.java.operators.IterativeDataSet;
import org.apache.flink.test.util.JavaProgramTestBase;

public class IterationIncompleteStaticPathConsumptionITCase
extends JavaProgramTestBase {
    protected void testProgram() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource edges = env.fromElements((Object[])new Path[]{new Path(2L, 1L), new Path(4L, 1L), new Path(6L, 3L), new Path(8L, 3L), new Path(10L, 1L), new Path(12L, 1L), new Path(14L, 3L), new Path(16L, 3L), new Path(18L, 1L), new Path(20L, 1L)});
        IterativeDataSet currentPaths = edges.iterate(10);
        DistinctOperator newPaths = currentPaths.join((DataSet)edges, JoinOperatorBase.JoinHint.REPARTITION_SORT_MERGE).where(new String[]{"to"}).equalTo(new String[]{"from"}).with((JoinFunction)new PathConnector()).union((DataSet)currentPaths).distinct(new String[]{"from", "to"});
        DataSet result = currentPaths.closeWith((DataSet)newPaths);
        result.output((OutputFormat)new DiscardingOutputFormat());
        env.execute();
    }

    public static class Path {
        public long from;
        public long to;

        public Path() {
        }

        public Path(long from, long to) {
            this.from = from;
            this.to = to;
        }

        public String toString() {
            return "(" + this.from + "," + this.to + ")";
        }
    }

    private static class PathConnector
    implements JoinFunction<Path, Path, Path> {
        private PathConnector() {
        }

        public Path join(Path path, Path edge) {
            return new Path(path.from, edge.to);
        }
    }
}

