/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.completeness;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeInformationTestBase;
import org.apache.flink.formats.avro.typeutils.AvroTypeInfo;
import org.apache.flink.formats.avro.typeutils.GenericRecordAvroTypeInfo;
import org.apache.flink.table.dataview.ListViewTypeInfo;
import org.apache.flink.table.dataview.MapViewTypeInfo;
import org.apache.flink.table.runtime.typeutils.BigDecimalTypeInfo;
import org.apache.flink.table.runtime.typeutils.DecimalDataTypeInfo;
import org.apache.flink.table.runtime.typeutils.ExternalTypeInfo;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.typeutils.LegacyInstantTypeInfo;
import org.apache.flink.table.runtime.typeutils.LegacyLocalDateTimeTypeInfo;
import org.apache.flink.table.runtime.typeutils.LegacyTimestampTypeInfo;
import org.apache.flink.table.runtime.typeutils.SortedMapTypeInfo;
import org.apache.flink.table.runtime.typeutils.StringDataTypeInfo;
import org.apache.flink.table.runtime.typeutils.TimestampDataTypeInfo;
import org.apache.flink.table.typeutils.TimeIndicatorTypeInfo;
import org.apache.flink.table.typeutils.TimeIntervalTypeInfo;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class TypeInfoTestCoverageTest
extends TestLogger {
    @Test
    public void testTypeInfoTestCoverage() {
        Reflections reflections = new Reflections("org.apache.flink", new Scanner[0]);
        Set typeInfos = reflections.getSubTypesOf(TypeInformation.class);
        Set typeInfoTestNames = reflections.getSubTypesOf(TypeInformationTestBase.class).stream().map(Class::getName).collect(Collectors.toSet());
        List<String> typeInfoTestBaseWhitelist = Arrays.asList(LegacyTimestampTypeInfo.class.getName(), InternalTypeInfo.class.getName(), LegacyLocalDateTimeTypeInfo.class.getName(), TimeIntervalTypeInfo.class.getName(), TimeIndicatorTypeInfo.class.getName(), TimestampDataTypeInfo.class.getName(), MapViewTypeInfo.class.getName(), LegacyInstantTypeInfo.class.getName(), ListViewTypeInfo.class.getName(), StringDataTypeInfo.class.getName(), SortedMapTypeInfo.class.getName(), ExternalTypeInfo.class.getName(), BigDecimalTypeInfo.class.getName(), DecimalDataTypeInfo.class.getName(), GenericRecordAvroTypeInfo.class.getName(), AvroTypeInfo.class.getName());
        for (Class typeInfo : typeInfos) {
            String testToFind;
            if (Modifier.isAbstract(typeInfo.getModifiers()) || Modifier.isPrivate(typeInfo.getModifiers()) || typeInfo.getName().contains("Test$") || typeInfo.getName().contains("TestBase$") || typeInfo.getName().contains("ITCase$") || typeInfo.getName().contains("$$anon") || typeInfo.getName().contains("queryablestate") || typeInfoTestNames.contains(testToFind = typeInfo.getName() + "Test") || typeInfoTestBaseWhitelist.contains(typeInfo.getName())) continue;
            Assert.fail((String)("Could not find test '" + testToFind + "' that covers '" + typeInfo.getName() + "'."));
        }
    }
}

