/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.broadcastvars;

import java.util.List;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.test.util.JavaProgramTestBase;
import org.junit.Assert;

public class BroadcastUnionITCase
extends JavaProgramTestBase {
    private static final String BC_NAME = "bc";

    protected void testProgram() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(4);
        DataSource input = env.generateSequence(1L, 10L);
        DataSource bc1 = env.generateSequence(1L, 5L);
        DataSource bc2 = env.generateSequence(6L, 10L);
        List result = ((MapOperator)input.map((MapFunction)new Mapper()).withBroadcastSet((DataSet)bc1.union((DataSet)bc2), BC_NAME)).reduce((ReduceFunction)new Reducer()).collect();
        Assert.assertEquals((Object)3025L, result.get(0));
    }

    private static class Reducer
    implements ReduceFunction<Long> {
        private Reducer() {
        }

        public Long reduce(Long value1, Long value2) throws Exception {
            return value1 + value2;
        }
    }

    private static class Mapper
    extends RichMapFunction<Long, Long> {
        private List<Long> values;

        private Mapper() {
        }

        public void open(OpenContext openContext) {
            this.values = this.getRuntimeContext().getBroadcastVariable(BroadcastUnionITCase.BC_NAME);
        }

        public Long map(Long value) throws Exception {
            long sum = 0L;
            for (Long v : this.values) {
                sum += value * v;
            }
            return sum;
        }
    }
}

