/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.operators;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.operators.DistinctITCase$;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.api.scala.util.CollectionDataSets;
import org.apache.flink.api.scala.util.CollectionDataSets$;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.test.util.MultipleProgramsTestBase;
import org.apache.flink.test.util.TestBaseUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef$;
import scala.Tuple1;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005%c\u0001B\u0001\u0003\u0001=\u0011a\u0002R5ti&t7\r^%U\u0007\u0006\u001cXM\u0003\u0002\u0004\t\u0005Iq\u000e]3sCR|'o\u001d\u0006\u0003\u000b\u0019\tQa]2bY\u0006T!a\u0002\u0005\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\n\u0015\u0005)a\r\\5oW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E1R\"\u0001\n\u000b\u0005M!\u0012\u0001B;uS2T!!\u0006\u0005\u0002\tQ,7\u000f^\u0005\u0003/I\u0011\u0001$T;mi&\u0004H.\u001a)s_\u001e\u0014\u0018-\\:UKN$()Y:f\u0011!I\u0002A!A!\u0002\u0013Q\u0012\u0001B7pI\u0016\u0004\"aG\u0016\u000f\u0005qIcBA\u000f)\u001d\tqrE\u0004\u0002 M9\u0011\u0001%\n\b\u0003C\u0011j\u0011A\t\u0006\u0003G9\ta\u0001\u0010:p_Rt\u0014\"A\u0007\n\u0005-a\u0011BA\u0005\u000b\u0013\t)\u0002\"\u0003\u0002\u0014)%\u0011!FE\u0001\u0019\u001bVdG/\u001b9mKB\u0013xn\u001a:b[N$Vm\u001d;CCN,\u0017B\u0001\u0017.\u0005E!Vm\u001d;Fq\u0016\u001cW\u000f^5p]6{G-\u001a\u0006\u0003UIAQa\f\u0001\u0005\u0002A\na\u0001P5oSRtDCA\u00194!\t\u0011\u0004!D\u0001\u0003\u0011\u0015Ib\u00061\u0001\u001b\u0011\u001d)\u0004\u00011A\u0005\nY\n!B]3tk2$\b+\u0019;i+\u00059\u0004C\u0001\u001d>\u001d\tI4\b\u0005\u0002\"u)\tQ!\u0003\u0002=u\u00051\u0001K]3eK\u001aL!AP \u0003\rM#(/\u001b8h\u0015\ta$\bC\u0004B\u0001\u0001\u0007I\u0011\u0002\"\u0002\u001dI,7/\u001e7u!\u0006$\bn\u0018\u0013fcR\u00111i\u0012\t\u0003\t\u0016k\u0011AO\u0005\u0003\rj\u0012A!\u00168ji\"9\u0001\nQA\u0001\u0002\u00049\u0014a\u0001=%c!1!\n\u0001Q!\n]\n1B]3tk2$\b+\u0019;iA!9A\n\u0001a\u0001\n\u00131\u0014\u0001C3ya\u0016\u001cG/\u001a3\t\u000f9\u0003\u0001\u0019!C\u0005\u001f\u0006aQ\r\u001f9fGR,Gm\u0018\u0013fcR\u00111\t\u0015\u0005\b\u00116\u000b\t\u00111\u00018\u0011\u0019\u0011\u0006\u0001)Q\u0005o\u0005IQ\r\u001f9fGR,G\r\t\u0005\b)\u0002\u0011\r\u0011\"\u0003V\u0003-yF/Z7q\r>dG-\u001a:\u0016\u0003Y\u0003\"a\u0016/\u000e\u0003aS!!\u0017.\u0002\u000bI,H.Z:\u000b\u0005mc\u0011!\u00026v]&$\u0018BA/Y\u0005=!V-\u001c9pe\u0006\u0014\u0018PR8mI\u0016\u0014\bBB0\u0001A\u0003%a+\u0001\u0007`i\u0016l\u0007OR8mI\u0016\u0014\b\u0005C\u0003b\u0001\u0011\u0005Q+\u0001\u0006uK6\u0004hi\u001c7eKJD#\u0001Y2\u0011\u0005\u0011,W\"\u0001.\n\u0005\u0019T&\u0001\u0002*vY\u0016DQ\u0001\u001b\u0001\u0005\u0002%\faAY3g_J,G#A\")\u0005\u001d\\\u0007C\u00013m\u0013\ti'L\u0001\u0004CK\u001a|'/\u001a\u0005\u0006_\u0002!\t![\u0001\u0006C\u001a$XM\u001d\u0015\u0003]F\u0004\"\u0001\u001a:\n\u0005MT&!B!gi\u0016\u0014\b\"B;\u0001\t\u0003I\u0017!\u000e;fgR\u001cuN\u001d:fGRtWm]:PM\u0012K7\u000f^5oGR|e\u000eV;qY\u0016\u001cx+\u001b;i\u0017\u0016Lh)[3mIN+G.Z2u_JD#\u0001^<\u0011\u0005\u0011D\u0018BA=[\u0005\u0011!Vm\u001d;\t\u000bm\u0004A\u0011A5\u0002\u0013R,7\u000f^\"peJ,7\r\u001e8fgN|e\rR5ti&t7\r^(o)V\u0004H.Z:XSRD7*Z=GS\u0016dGmU3mK\u000e$xN\u001d(pi\u0006cGNR5fY\u0012\u001c8+\u001a7fGR,G\r\u000b\u0002{o\")a\u0010\u0001C\u0001S\u0006\tD/Z:u\u0007>\u0014(/Z2u]\u0016\u001c8o\u00144ESN$\u0018N\\2u\u001f:$V\u000f\u001d7fg^KG\u000f[&fs\u0016CHO]1di>\u0014\bFA?x\u0011\u0019\t\u0019\u0001\u0001C\u0001S\u00061D/Z:u\u0007>\u0014(/Z2u]\u0016\u001c8o\u00144ESN$\u0018N\\2u\u001f:\u001cUo\u001d;p[RK\b/Z,ji\"$\u0016\u0010]3FqR\u0014\u0018m\u0019;pe\"\u001a\u0011\u0011A<\t\r\u0005%\u0001\u0001\"\u0001j\u0003\u0005\"Xm\u001d;D_J\u0014Xm\u0019;oKN\u001cxJ\u001a#jgRLgn\u0019;P]R+\b\u000f\\3tQ\r\t9a\u001e\u0005\u0007\u0003\u001f\u0001A\u0011A5\u0002\tR,7\u000f^\"peJ,7\r\u001e8fgN|e\rR5ti&t7\r^(o\u0007V\u001cHo\\7UsB,w+\u001b;i)V\u0004H.\u001a*fiV\u0014h.\u001b8h)f\u0004X-\u0012=ue\u0006\u001cGo\u001c:)\u0007\u00055q\u000f\u0003\u0004\u0002\u0016\u0001!\t![\u00016i\u0016\u001cHoQ8se\u0016\u001cGO\\3tg>3G)[:uS:\u001cGo\u00148UkBdWm],ji\"4\u0015.\u001a7e\u000bb\u0004(/Z:tS>t7\u000fK\u0002\u0002\u0014]Da!a\u0007\u0001\t\u0003I\u0017\u0001\t;fgR\u001cuN\u001d:fGRtWm]:PM\u0012K7\u000f^5oGR|e\u000eU8k_ND3!!\u0007x\u0011\u0019\t\t\u0003\u0001C\u0001S\u0006\tC/Z:u\u0007>\u0014(/Z2u]\u0016\u001c8o\u00144ESN$\u0018N\\2u\u001f:\fEo\\7jG\"\u001a\u0011qD<\t\r\u0005\u001d\u0002\u0001\"\u0001j\u0003I\"Xm\u001d;D_J\u0014Xm\u0019;oKN\u001cxJ\u001a#jgRLgn\u0019;P]\u0006#x.\\5d/&$\bnU3mK\u000e$\u0018\t\u001c7DQ\u0006\u0014\bfAA\u0013o\":\u0001!!\f\u0002:\u0005m\u0002\u0003BA\u0018\u0003ki!!!\r\u000b\u0007\u0005M\",\u0001\u0004sk:tWM]\u0005\u0005\u0003o\t\tDA\u0004Sk:<\u0016\u000e\u001e5\u0002\u000bY\fG.^3$\u0005\u0005u\u0002\u0003BA \u0003\u000bj!!!\u0011\u000b\u0007\u0005\r#,A\u0004sk:tWM]:\n\t\u0005\u001d\u0013\u0011\t\u0002\u000e!\u0006\u0014\u0018-\\3uKJL'0\u001a3")
public class DistinctITCase
extends MultipleProgramsTestBase {
    private String resultPath = null;
    private String expected = null;
    private final TemporaryFolder _tempFolder = new TemporaryFolder();

    private String resultPath() {
        return this.resultPath;
    }

    private void resultPath_$eq(String x$1) {
        this.resultPath = x$1;
    }

    private String expected() {
        return this.expected;
    }

    private void expected_$eq(String x$1) {
        this.expected = x$1;
    }

    private TemporaryFolder _tempFolder() {
        return this._tempFolder;
    }

    @Rule
    public TemporaryFolder tempFolder() {
        return this._tempFolder();
    }

    @Before
    public void before() {
        this.resultPath_$eq(this.tempFolder().newFile().toURI().toString());
    }

    @After
    public void after() {
        TestBaseUtils.compareResultsByLinesInMemory((String)this.expected(), (String)this.resultPath());
    }

    @Test
    public void testCorrectnessOfDistinctOnTuplesWithKeyFieldSelector() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env);
        DataSet distinctDs = ds.union(ds).distinct((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        String x$6 = this.resultPath();
        FileSystem.WriteMode x$7 = FileSystem.WriteMode.OVERWRITE;
        String x$8 = distinctDs.writeAsCsv$default$2();
        String x$9 = distinctDs.writeAsCsv$default$3();
        distinctDs.writeAsCsv(x$6, x$8, x$9, x$7);
        env.execute();
        this.expected_$eq("1,1,Hi\n2,2,Hello\n3,2,Hello world\n");
    }

    @Test
    public void testCorrectnessOfDistinctOnTuplesWithKeyFieldSelectorNotAllFieldsSelected() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple5<Object, Object, Object, String, Object>> ds = CollectionDataSets$.MODULE$.getSmall5TupleDataSet(env);
        DataSet distinctDs = ds.union(ds).distinct((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)DistinctITCase.$anonfun$testCorrectnessOfDistinctOnTuplesWithKeyFieldSelectorNotAllFieldsSelected$1(x$1)), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE), ClassTag$.MODULE$.Int());
        distinctDs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("1\n2\n");
    }

    @Test
    public void testCorrectnessOfDistinctOnTuplesWithKeyExtractor() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple5<Object, Object, Object, String, Object>> ds = CollectionDataSets$.MODULE$.getSmall5TupleDataSet(env);
        DataSet reduceDs = ds.union(ds).distinct((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)DistinctITCase.$anonfun$testCorrectnessOfDistinctOnTuplesWithKeyExtractor$1(x$2)), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE)).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)DistinctITCase.$anonfun$testCorrectnessOfDistinctOnTuplesWithKeyExtractor$2(x$3)), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE), ClassTag$.MODULE$.Int());
        reduceDs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("1\n2\n");
    }

    @Test
    public void testCorrectnessOfDistinctOnCustomTypeWithTypeExtractor() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<CollectionDataSets.CustomType> ds = CollectionDataSets$.MODULE$.getCustomTypeDataSet(env);
        DataSet reduceDs = ds.distinct((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.myInt()), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE)).map((Function1 & Serializable & scala.Serializable)t -> new Tuple1.mcI.sp(t.myInt()), (TypeInformation)new CaseClassTypeInfo<Tuple1<Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple1<Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple1<Object>> unused = new ScalaCaseClassSerializer<Tuple1<Object>>(this, fieldSerializers){

                    public Tuple1<Object> createInstance(Object[] fields) {
                        return new Tuple1.mcI.sp(BoxesRunTime.unboxToInt((Object)fields[0]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple1<Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.api.scala.operators.DistinctITCase$$anon$5 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, ClassTag$.MODULE$.apply(Tuple1.class));
        String x$10 = this.resultPath();
        FileSystem.WriteMode x$11 = FileSystem.WriteMode.OVERWRITE;
        String x$12 = reduceDs.writeAsCsv$default$2();
        String x$13 = reduceDs.writeAsCsv$default$3();
        reduceDs.writeAsCsv(x$10, x$12, x$13, x$11);
        env.execute();
        this.expected_$eq("1\n2\n3\n4\n5\n6\n");
    }

    @Test
    public void testCorrectnessOfDistinctOnTuples() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.getSmall3TupleDataSet(env);
        DataSet distinctDs = ds.union(ds).distinct();
        String x$14 = this.resultPath();
        FileSystem.WriteMode x$15 = FileSystem.WriteMode.OVERWRITE;
        String x$16 = distinctDs.writeAsCsv$default$2();
        String x$17 = distinctDs.writeAsCsv$default$3();
        distinctDs.writeAsCsv(x$14, x$16, x$17, x$15);
        env.execute();
        this.expected_$eq("1,1,Hi\n2,2,Hello\n3,2,Hello world\n");
    }

    @Test
    public void testCorrectnessOfDistinctOnCustomTypeWithTupleReturningTypeExtractor() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple5<Object, Object, Object, String, Object>> ds = CollectionDataSets$.MODULE$.get5TupleDataSet(env);
        DataSet reduceDs = ds.distinct((Function1 & Serializable & scala.Serializable)t -> new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)t._1()), BoxesRunTime.unboxToLong((Object)t._5())), (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.api.scala.operators.DistinctITCase$$anon$6 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).map((Function1 & Serializable & scala.Serializable)t -> new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)t._1()), BoxesRunTime.unboxToLong((Object)t._5())), (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.api.scala.operators.DistinctITCase$$anon$7 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        String x$18 = this.resultPath();
        FileSystem.WriteMode x$19 = FileSystem.WriteMode.OVERWRITE;
        String x$20 = reduceDs.writeAsCsv$default$2();
        String x$21 = reduceDs.writeAsCsv$default$3();
        reduceDs.writeAsCsv(x$18, x$20, x$21, x$19);
        env.execute();
        this.expected_$eq("1,1\n2,1\n2,2\n3,2\n3,3\n4,1\n4,2\n5,1\n5,2\n5,3\n");
    }

    @Test
    public void testCorrectnessOfDistinctOnTuplesWithFieldExpressions() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple5<Object, Object, Object, String, Object>> ds = CollectionDataSets$.MODULE$.getSmall5TupleDataSet(env);
        DataSet reduceDs = ds.union(ds).distinct("_1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).map((Function1 & Serializable & scala.Serializable)t -> new Tuple1.mcI.sp(BoxesRunTime.unboxToInt((Object)t._1())), (TypeInformation)new CaseClassTypeInfo<Tuple1<Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple1<Object>> createSerializer(SerializerConfig serializerConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(serializerConfig);
                });
                ScalaCaseClassSerializer<Tuple1<Object>> unused = new ScalaCaseClassSerializer<Tuple1<Object>>(this, fieldSerializers){

                    public Tuple1<Object> createInstance(Object[] fields) {
                        return new Tuple1.mcI.sp(BoxesRunTime.unboxToInt((Object)fields[0]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            public TypeSerializer<Tuple1<Object>> createSerializer(ExecutionConfig executionConfig) {
                return this.createSerializer(executionConfig.getSerializerConfig());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.api.scala.operators.DistinctITCase$$anon$8 org.apache.flink.api.common.serialization.SerializerConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, ClassTag$.MODULE$.apply(Tuple1.class));
        String x$22 = this.resultPath();
        FileSystem.WriteMode x$23 = FileSystem.WriteMode.OVERWRITE;
        String x$24 = reduceDs.writeAsCsv$default$2();
        String x$25 = reduceDs.writeAsCsv$default$3();
        reduceDs.writeAsCsv(x$22, x$24, x$25, x$23);
        env.execute();
        this.expected_$eq("1\n2\n");
    }

    @Test
    public void testCorrectnessOfDistinctOnPojos() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<CollectionDataSets.POJO> ds = CollectionDataSets$.MODULE$.getDuplicatePojoDataSet(env);
        DataSet reduceDs = ds.distinct("nestedPojo.longNumber", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)DistinctITCase.$anonfun$testCorrectnessOfDistinctOnPojos$1(x$5)), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE), ClassTag$.MODULE$.Int());
        reduceDs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("10000\n20000\n30000\n");
    }

    @Test
    public void testCorrectnessOfDistinctOnAtomic() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Object> ds = CollectionDataSets$.MODULE$.getIntDataSet(env);
        DataSet reduceDs = ds.distinct();
        reduceDs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("1\n2\n3\n4\n5");
    }

    @Test
    public void testCorrectnessOfDistinctOnAtomicWithSelectAllChar() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<String> ds = CollectionDataSets$.MODULE$.getStringDataSet(env);
        DataSet reduceDs = ds.union(ds).distinct("_", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        reduceDs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("I am fine.\nLuke Skywalker\nLOL\nHello world, how are you?\nHi\nHello world\nHello\nRandom comment\n");
    }

    public static final /* synthetic */ int $anonfun$testCorrectnessOfDistinctOnTuplesWithKeyFieldSelectorNotAllFieldsSelected$1(Tuple5 x$1) {
        return BoxesRunTime.unboxToInt((Object)x$1._1());
    }

    public static final /* synthetic */ int $anonfun$testCorrectnessOfDistinctOnTuplesWithKeyExtractor$1(Tuple5 x$2) {
        return BoxesRunTime.unboxToInt((Object)x$2._1());
    }

    public static final /* synthetic */ int $anonfun$testCorrectnessOfDistinctOnTuplesWithKeyExtractor$2(Tuple5 x$3) {
        return BoxesRunTime.unboxToInt((Object)x$3._1());
    }

    public static final /* synthetic */ int $anonfun$testCorrectnessOfDistinctOnPojos$1(CollectionDataSets.POJO x$5) {
        return (int)x$5.nestedPojo().longNumber();
    }

    public DistinctITCase(MultipleProgramsTestBase.TestExecutionMode mode) {
        super(mode);
    }
}

