/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.web;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.flink.test.util.MultipleProgramsTestBase;
import org.apache.flink.test.util.TestBaseUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class WebFrontendITCase
extends MultipleProgramsTestBase {
    public WebFrontendITCase(MultipleProgramsTestBase.TestExecutionMode m) {
        super(m);
    }

    @Parameterized.Parameters(name="Execution mode = {0}")
    public static Collection<MultipleProgramsTestBase.TestExecutionMode[]> executionModes() {
        ArrayList<MultipleProgramsTestBase.TestExecutionMode[]> c = new ArrayList<MultipleProgramsTestBase.TestExecutionMode[]>(1);
        c.add(new MultipleProgramsTestBase.TestExecutionMode[]{MultipleProgramsTestBase.TestExecutionMode.CLUSTER});
        return c;
    }

    @Test
    public void getNumberOfTaskManagers() {
        try {
            Assert.assertEquals((Object)("{\"taskmanagers\": " + cluster.getTaskManagers().size() + ", \"slots\": 4}"), (Object)TestBaseUtils.getFromHTTP((String)"http://localhost:8081/jobsInfo?get=taskmanagers"));
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void getTaskmanagers() {
        try {
            String json = WebFrontendITCase.getFromHTTP((String)"http://localhost:8081/setupInfo?get=taskmanagers");
            JSONObject parsed = new JSONObject(json);
            Object taskManagers = parsed.get("taskmanagers");
            Assert.assertNotNull((Object)taskManagers);
            Assert.assertTrue((boolean)(taskManagers instanceof JSONArray));
            JSONArray tma = (JSONArray)taskManagers;
            Assert.assertEquals((long)cluster.numTaskManagers(), (long)tma.length());
            Object taskManager = tma.get(0);
            Assert.assertNotNull((Object)taskManager);
            Assert.assertTrue((boolean)(taskManager instanceof JSONObject));
            Assert.assertEquals((long)4L, (long)((JSONObject)taskManager).getInt("freeSlots"));
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void getLogfiles() {
        try {
            String logPath = cluster.configuration().getString("jobmanager.web.logpath", null);
            Assert.assertNotNull((Object)logPath);
            FileUtils.writeStringToFile((File)new File(logPath, "jobmanager-main.log"), (String)"test content");
            String logs = WebFrontendITCase.getFromHTTP((String)"http://localhost:8081/logInfo");
            Assert.assertTrue((boolean)logs.contains("test content"));
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void getConfiguration() {
        try {
            String config = WebFrontendITCase.getFromHTTP((String)"http://localhost:8081/setupInfo?get=globalC");
            JSONObject parsed = new JSONObject(config);
            Assert.assertEquals((Object)logDir.toString(), (Object)parsed.getString("jobmanager.web.logpath"));
            Assert.assertEquals((Object)cluster.configuration().getString("taskmanager.numberOfTaskSlots", null), (Object)parsed.getString("taskmanager.numberOfTaskSlots"));
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    static {
        startWebServer = true;
    }
}

