/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util;

import org.apache.flink.runtime.client.JobExecutionException;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.test.util.ForkableFlinkMiniCluster;
import org.apache.flink.test.util.RecordAPITestBase;
import org.junit.Assert;

public abstract class FailingTestBase
extends RecordAPITestBase {
    protected abstract JobGraph getFailingJobGraph() throws Exception;

    protected String getFailingJarFilePath() {
        return null;
    }

    protected abstract int getTimeout();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJob() throws Exception {
        this.startCluster();
        try {
            try {
                this.preSubmit();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
                Assert.fail((String)("Pre-submit work caused an error: " + e.getMessage()));
            }
            SubmissionThread st = new SubmissionThread(Thread.currentThread(), this.executor, this.getFailingJobGraph(), this.getJobGraph());
            st.start();
            try {
                Thread.sleep(this.getTimeout() * 1000);
                Assert.fail((String)"Failing job and successful job did not fail.");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Exception cte = st.error;
            if (cte != null) {
                cte.printStackTrace();
                Assert.fail((String)("Task Canceling failed: " + cte.getMessage()));
            }
            try {
                this.postSubmit();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
                Assert.fail((String)("Post-submit work caused an error: " + e.getMessage()));
            }
        }
        finally {
            this.stopCluster();
        }
    }

    private class SubmissionThread
    extends Thread {
        private final Thread timeoutThread;
        private final ForkableFlinkMiniCluster executor;
        private final JobGraph failingJob;
        private final JobGraph job;
        private volatile Exception error;

        public SubmissionThread(Thread timeoutThread, ForkableFlinkMiniCluster executor, JobGraph failingJob, JobGraph job) {
            this.timeoutThread = timeoutThread;
            this.executor = executor;
            this.failingJob = failingJob;
            this.job = job;
        }

        @Override
        public void run() {
            try {
                this.executor.submitJobAndWait(this.failingJob, false);
                this.error = new Exception("The job did not fail.");
            }
            catch (JobExecutionException jobExecutionException) {
            }
            catch (Exception e) {
                this.error = e;
            }
            try {
                this.executor.submitJobAndWait(this.job, false);
            }
            catch (Exception e) {
                this.error = e;
            }
            this.timeoutThread.interrupt();
        }
    }
}

