/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.recovery;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.api.common.ExecutionMode;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.ReduceOperator;
import org.apache.flink.test.recovery.AbstractProcessFailureRecoveryTest;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ProcessFailureBatchRecoveryITCase
extends AbstractProcessFailureRecoveryTest {
    private final ExecutionMode executionMode;

    public ProcessFailureBatchRecoveryITCase(ExecutionMode executionMode) {
        this.executionMode = executionMode;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> executionMode() {
        return Arrays.asList({ExecutionMode.PIPELINED}, {ExecutionMode.BATCH});
    }

    @Override
    public void testProgram(int jobManagerPort, final File coordinateDir) throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.createRemoteEnvironment((String)"localhost", (int)jobManagerPort, (String[])new String[0]);
        env.setParallelism(4);
        env.setNumberOfExecutionRetries(1);
        env.getConfig().setExecutionMode(this.executionMode);
        env.getConfig().disableSysoutLogging();
        long NUM_ELEMENTS = 100000L;
        ReduceOperator result = env.generateSequence(1L, 100000L).rebalance().map((MapFunction)new RichMapFunction<Long, Long>(){
            private final File proceedFile;
            private boolean markerCreated;
            private boolean checkForProceedFile;
            {
                this.proceedFile = new File(coordinateDir, "proceed");
                this.markerCreated = false;
                this.checkForProceedFile = true;
            }

            public Long map(Long value) throws Exception {
                if (!this.markerCreated) {
                    int taskIndex = this.getRuntimeContext().getIndexOfThisSubtask();
                    AbstractProcessFailureRecoveryTest.touchFile(new File(coordinateDir, "ready_" + taskIndex));
                    this.markerCreated = true;
                }
                if (this.checkForProceedFile) {
                    if (this.proceedFile.exists()) {
                        this.checkForProceedFile = false;
                    } else {
                        Thread.sleep(100L);
                    }
                }
                return value;
            }
        }).reduce((ReduceFunction)new ReduceFunction<Long>(){

            public Long reduce(Long value1, Long value2) {
                return value1 + value2;
            }
        });
        long sum = (Long)result.collect().get(0);
        Assert.assertEquals((long)5000050000L, (long)sum);
    }
}

