/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.recordJobs.sort;

import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.Program;
import org.apache.flink.api.common.ProgramDescription;
import org.apache.flink.api.common.distributions.DataDistribution;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.java.record.operators.FileDataSink;
import org.apache.flink.api.java.record.operators.FileDataSource;
import org.apache.flink.test.recordJobs.sort.tsUtil.TeraDistribution;
import org.apache.flink.test.recordJobs.sort.tsUtil.TeraInputFormat;
import org.apache.flink.test.recordJobs.sort.tsUtil.TeraKey;
import org.apache.flink.test.recordJobs.sort.tsUtil.TeraOutputFormat;

public final class TeraSort
implements Program,
ProgramDescription {
    private static final long serialVersionUID = 1L;

    public String getDescription() {
        return "Parameters: [numSubStasks] [input] [output]";
    }

    public Plan getPlan(String ... args) throws IllegalArgumentException {
        int numSubTasks = args.length > 0 ? Integer.parseInt(args[0]) : 1;
        String input = args.length > 1 ? args[1] : "";
        String output = args.length > 2 ? args[2] : "";
        FileDataSource source = new FileDataSource((FileInputFormat)new TeraInputFormat(), input, "Data Source");
        source.setParallelism(numSubTasks);
        FileDataSink sink = new FileDataSink((FileOutputFormat)new TeraOutputFormat(), output, "Data Sink");
        sink.setParallelism(numSubTasks);
        sink.setGlobalOrder(new Ordering(0, TeraKey.class, Order.ASCENDING), (DataDistribution)new TeraDistribution());
        sink.setInput((Operator)source);
        return new Plan((GenericDataSinkBase)sink, "TeraSort");
    }
}

