/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.recordJobs.relational.query1Util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.flink.api.java.record.functions.MapFunction;
import org.apache.flink.test.recordJobs.util.Tuple;
import org.apache.flink.types.Record;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.Value;
import org.apache.flink.util.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineItemFilter
extends MapFunction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(LineItemFilter.class);
    private static final String DATE_CONSTANT = "1998-09-03";
    private static final DateFormat format = new SimpleDateFormat("yyyy-MM-dd");
    private final Date constantDate;

    public LineItemFilter() {
        try {
            this.constantDate = format.parse(DATE_CONSTANT);
        }
        catch (ParseException e) {
            LOG.error("Date constant could not be parsed.", (Throwable)e);
            throw new RuntimeException("Date constant could not be parsed.");
        }
    }

    public void map(Record record, Collector<Record> out) throws Exception {
        Tuple value = (Tuple)record.getField(1, Tuple.class);
        if (value != null && value.getNumberOfColumns() >= 11) {
            String shipDateString = value.getStringValueAt(10);
            try {
                Date shipDate = format.parse(shipDateString);
                if (shipDate.before(this.constantDate)) {
                    String returnFlag = value.getStringValueAt(8);
                    record.setField(0, (Value)new StringValue((CharSequence)returnFlag));
                    out.collect((Object)record);
                }
            }
            catch (ParseException e) {
                LOG.warn("ParseException while parsing the shipping date.", (Throwable)e);
            }
        }
    }
}

