/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.recordJobs.relational;

import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.Program;
import org.apache.flink.api.common.ProgramDescription;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.java.record.functions.MapFunction;
import org.apache.flink.api.java.record.functions.ReduceFunction;
import org.apache.flink.api.java.record.operators.FileDataSink;
import org.apache.flink.api.java.record.operators.FileDataSource;
import org.apache.flink.api.java.record.operators.MapOperator;
import org.apache.flink.api.java.record.operators.ReduceOperator;
import org.apache.flink.test.recordJobs.relational.query1Util.GroupByReturnFlag;
import org.apache.flink.test.recordJobs.relational.query1Util.LineItemFilter;
import org.apache.flink.test.recordJobs.util.IntTupleDataInFormat;
import org.apache.flink.test.recordJobs.util.StringTupleDataOutFormat;
import org.apache.flink.types.StringValue;

public class TPCHQuery1
implements Program,
ProgramDescription {
    private static final long serialVersionUID = 1L;
    private int parallelism = 1;
    private String lineItemInputPath;
    private String outputPath;

    public Plan getPlan(String ... args) throws IllegalArgumentException {
        if (args.length != 3) {
            this.parallelism = 1;
            this.lineItemInputPath = "";
            this.outputPath = "";
        } else {
            this.parallelism = Integer.parseInt(args[0]);
            this.lineItemInputPath = args[1];
            this.outputPath = args[2];
        }
        FileDataSource lineItems = new FileDataSource((FileInputFormat)new IntTupleDataInFormat(), this.lineItemInputPath, "LineItems");
        lineItems.setParallelism(this.parallelism);
        FileDataSink result = new FileDataSink((FileOutputFormat)new StringTupleDataOutFormat(), this.outputPath, "Output");
        result.setParallelism(this.parallelism);
        MapOperator lineItemFilter = MapOperator.builder((MapFunction)new LineItemFilter()).name("LineItem Filter").build();
        lineItemFilter.setParallelism(this.parallelism);
        ReduceOperator groupByReturnFlag = ReduceOperator.builder((ReduceFunction)new GroupByReturnFlag(), StringValue.class, (int)0).name("groupyBy").build();
        lineItemFilter.setInput((Operator)lineItems);
        groupByReturnFlag.setInput((Operator)lineItemFilter);
        result.setInput((Operator)groupByReturnFlag);
        return new Plan((GenericDataSinkBase)result, "TPC-H 1");
    }

    public String getDescription() {
        return "Parameters: [parallelism] [lineitem-input] [output]";
    }
}

