/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.recordJobs.kmeans.udfs;

import java.io.IOException;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.Key;

public final class CoordVector
implements Key<CoordVector> {
    private static final long serialVersionUID = 1L;
    private double[] coordinates;

    public CoordVector() {
        this.coordinates = null;
    }

    public CoordVector(Double[] coordinates) {
        this.coordinates = new double[coordinates.length];
        for (int i = 0; i < coordinates.length; ++i) {
            this.coordinates[i] = coordinates[i];
        }
    }

    public CoordVector(double[] coordinates) {
        this.coordinates = coordinates;
    }

    public double[] getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(double[] coordinates) {
        this.coordinates = coordinates;
    }

    public double computeEuclidianDistance(CoordVector cv) {
        if (cv.coordinates.length != this.coordinates.length) {
            return -1.0;
        }
        double quadSum = 0.0;
        for (int i = 0; i < this.coordinates.length; ++i) {
            double diff = this.coordinates[i] - cv.coordinates[i];
            quadSum += diff * diff;
        }
        return Math.sqrt(quadSum);
    }

    public void read(DataInputView in) throws IOException {
        int length = in.readInt();
        this.coordinates = new double[length];
        for (int i = 0; i < length; ++i) {
            this.coordinates[i] = in.readDouble();
        }
    }

    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.coordinates.length);
        for (int i = 0; i < this.coordinates.length; ++i) {
            out.writeDouble(this.coordinates[i]);
        }
    }

    public int compareTo(CoordVector o) {
        if (o.coordinates.length > this.coordinates.length) {
            return -1;
        }
        if (o.coordinates.length < this.coordinates.length) {
            return 1;
        }
        for (int i = 0; i < this.coordinates.length; ++i) {
            if (o.coordinates[i] > this.coordinates[i]) {
                return -1;
            }
            if (!(o.coordinates[i] < this.coordinates[i])) continue;
            return 1;
        }
        return 0;
    }
}

