/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.recordJobs.graph.pageRankUtil;

import org.apache.flink.api.java.record.io.TextInputFormat;
import org.apache.flink.test.recordJobs.graph.pageRankUtil.AsciiLongArrayView;
import org.apache.flink.test.recordJobs.graph.pageRankUtil.LongArrayView;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.Record;
import org.apache.flink.types.Value;

public class ImprovedAdjacencyListInputFormat
extends TextInputFormat {
    private static final long serialVersionUID = 1L;
    private final LongValue vertexID = new LongValue();
    private final AsciiLongArrayView arrayView = new AsciiLongArrayView();
    private final LongArrayView adjacentVertices = new LongArrayView();

    public Record readRecord(Record target, byte[] bytes, int offset, int numBytes) {
        if (numBytes == 0) {
            return null;
        }
        this.arrayView.set(bytes, offset, numBytes);
        int numElements = this.arrayView.numElements();
        this.adjacentVertices.allocate(numElements - 1);
        try {
            int pos = 0;
            while (this.arrayView.next()) {
                if (pos == 0) {
                    this.vertexID.setValue(this.arrayView.element());
                } else {
                    this.adjacentVertices.setQuick(pos - 1, this.arrayView.element());
                }
                ++pos;
            }
            if (pos != numElements) {
                throw new IllegalStateException("Should have gotten " + numElements + " elements, but saw " + pos);
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error parsing: " + this.arrayView.toString(), e);
        }
        target.clear();
        target.addField((Value)this.vertexID);
        target.addField((Value)this.adjacentVertices);
        return target;
    }
}

