/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.recordJobs.graph.pageRankUtil;

import java.io.Serializable;
import org.apache.flink.api.java.record.functions.JoinFunction;
import org.apache.flink.test.recordJobs.graph.pageRankUtil.LongArrayView;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.Record;
import org.apache.flink.types.Value;
import org.apache.flink.util.Collector;

public class DotProductMatch
extends JoinFunction
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Record record = new Record();
    private LongValue vertexID = new LongValue();
    private DoubleValue partialRank = new DoubleValue();
    private DoubleValue rank = new DoubleValue();
    private LongArrayView adjacentNeighbors = new LongArrayView();

    public void join(Record pageWithRank, Record adjacencyList, Collector<Record> collector) throws Exception {
        this.rank = (DoubleValue)pageWithRank.getField(1, (Value)this.rank);
        this.adjacentNeighbors = (LongArrayView)adjacencyList.getField(1, (Value)this.adjacentNeighbors);
        int numNeighbors = this.adjacentNeighbors.size();
        double rankToDistribute = this.rank.getValue() / (double)numNeighbors;
        this.partialRank.setValue(rankToDistribute);
        this.record.setField(1, (Value)this.partialRank);
        for (int n = 0; n < numNeighbors; ++n) {
            this.vertexID.setValue(this.adjacentNeighbors.getQuick(n));
            this.record.setField(0, (Value)this.vertexID);
            collector.collect((Object)this.record);
        }
    }
}

