/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.operators;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.base.FileDataSourceBase;
import org.apache.flink.api.java.record.functions.ReduceFunction;
import org.apache.flink.api.java.record.io.DelimitedInputFormat;
import org.apache.flink.api.java.record.operators.FileDataSink;
import org.apache.flink.api.java.record.operators.FileDataSource;
import org.apache.flink.api.java.record.operators.ReduceOperator;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.optimizer.DataStatistics;
import org.apache.flink.optimizer.Optimizer;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plantranslate.JobGraphGenerator;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.test.operators.io.ContractITCaseIOFormats;
import org.apache.flink.test.util.RecordAPITestBase;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.Record;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.Value;
import org.apache.flink.util.Collector;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ReduceITCase
extends RecordAPITestBase {
    String inPath = null;
    String resultPath = null;
    private static final String IN = "1 1\n2 2\n2 8\n4 4\n4 4\n6 6\n7 7\n8 8\n1 1\n2 2\n2 2\n4 4\n4 4\n6 3\n5 9\n8 8\n1 1\n2 2\n2 2\n3 0\n4 4\n5 9\n7 7\n8 8\n1 1\n9 1\n5 9\n4 4\n4 4\n6 6\n7 7\n8 8\n";
    private static final String RESULT = "1 4\n2 18\n3 0\n4 28\n5 27\n6 15\n7 21\n8 32\n9 1\n";

    public ReduceITCase(Configuration testConfig) {
        super(testConfig);
    }

    protected void preSubmit() throws Exception {
        this.inPath = this.createTempFile("in.txt", IN);
        this.resultPath = this.getTempDirPath("result");
    }

    protected JobGraph getJobGraph() throws Exception {
        FileDataSource input = new FileDataSource((FileInputFormat)new ContractITCaseIOFormats.ContractITCaseInputFormat(), this.inPath);
        DelimitedInputFormat.configureDelimitedFormat((FileDataSourceBase)input).recordDelimiter('\n');
        input.setParallelism(this.config.getInteger("ReduceTest#NoSubtasks", 1));
        ReduceOperator testReducer = ReduceOperator.builder((ReduceFunction)new TestReducer(), StringValue.class, (int)0).build();
        testReducer.setParallelism(this.config.getInteger("ReduceTest#NoSubtasks", 1));
        testReducer.getParameters().setString("LOCAL_STRATEGY", this.config.getString("ReduceTest#LocalStrategy", ""));
        testReducer.getParameters().setString("INPUT_SHIP_STRATEGY", this.config.getString("ReduceTest#ShipStrategy", ""));
        FileDataSink output = new FileDataSink((FileOutputFormat)new ContractITCaseIOFormats.ContractITCaseOutputFormat(), this.resultPath);
        output.setParallelism(1);
        output.setInput((Operator)testReducer);
        testReducer.setInput((Operator)input);
        Plan plan = new Plan((GenericDataSinkBase)output);
        plan.setExecutionConfig(new ExecutionConfig());
        Optimizer pc = new Optimizer(new DataStatistics(), this.config);
        OptimizedPlan op = pc.compile(plan);
        JobGraphGenerator jgg = new JobGraphGenerator();
        return jgg.compileJobGraph(op);
    }

    protected void postSubmit() throws Exception {
        ReduceITCase.compareResultsByLinesInMemory((String)RESULT, (String)this.resultPath);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConfigurations() throws FileNotFoundException, IOException {
        LinkedList<Configuration> tConfigs = new LinkedList<Configuration>();
        String[] localStrategies = new String[]{"LOCAL_STRATEGY_SORT"};
        String[] shipStrategies = new String[]{"SHIP_REPARTITION_HASH"};
        for (String localStrategy : localStrategies) {
            for (String shipStrategy : shipStrategies) {
                Configuration config = new Configuration();
                config.setString("ReduceTest#LocalStrategy", localStrategy);
                config.setString("ReduceTest#ShipStrategy", shipStrategy);
                config.setInteger("ReduceTest#NoSubtasks", 4);
                tConfigs.add(config);
            }
        }
        return ReduceITCase.toParameterList(tConfigs);
    }

    @ReduceOperator.Combinable
    public static class TestReducer
    extends ReduceFunction
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private StringValue reduceValue = new StringValue();
        private StringValue combineValue = new StringValue();

        public void combine(Iterator<Record> records, Collector<Record> out) {
            Record record = null;
            int sum = 0;
            while (records.hasNext()) {
                record = records.next();
                this.combineValue = (StringValue)record.getField(1, (Value)this.combineValue);
                sum += Integer.parseInt(this.combineValue.toString());
            }
            this.combineValue.setValue((CharSequence)(sum + ""));
            record.setField(1, (Value)this.combineValue);
            out.collect((Object)record);
        }

        public void reduce(Iterator<Record> records, Collector<Record> out) {
            Record record = null;
            int sum = 0;
            while (records.hasNext()) {
                record = records.next();
                this.reduceValue = (StringValue)record.getField(1, (Value)this.reduceValue);
                sum += Integer.parseInt(this.reduceValue.toString());
            }
            record.setField(1, (Value)new IntValue(sum));
            out.collect((Object)record);
        }
    }
}

