/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.javaApiOperators;

import java.util.List;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.test.javaApiOperators.util.CollectionDataSets;
import org.apache.flink.test.util.MultipleProgramsTestBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MapITCase
extends MultipleProgramsTestBase {
    private String resultPath;
    private String expected;
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    static final String testKey = "testVariable";
    static final int testValue = 666;

    public MapITCase(MultipleProgramsTestBase.TestExecutionMode mode) {
        super(mode);
    }

    @Before
    public void before() throws Exception {
        this.resultPath = this.tempFolder.newFile().toURI().toString();
    }

    @After
    public void after() throws Exception {
        MapITCase.compareResultsByLinesInMemory((String)this.expected, (String)this.resultPath);
    }

    @Test
    public void testIdentityMapWithBasicType() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<String> ds = CollectionDataSets.getStringDataSet(env);
        MapOperator identityMapDs = ds.map((MapFunction)new Mapper1());
        identityMapDs.writeAsText(this.resultPath);
        env.execute();
        this.expected = "Hi\nHello\nHello world\nHello world, how are you?\nI am fine.\nLuke Skywalker\nRandom comment\nLOL\n";
    }

    @Test
    public void testIdentityMapWithTuple() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
        MapOperator identityMapDs = ds.map((MapFunction)new Mapper2());
        identityMapDs.writeAsCsv(this.resultPath);
        env.execute();
        this.expected = "1,1,Hi\n2,2,Hello\n3,2,Hello world\n4,3,Hello world, how are you?\n5,3,I am fine.\n6,3,Luke Skywalker\n7,4,Comment#1\n8,4,Comment#2\n9,4,Comment#3\n10,4,Comment#4\n11,5,Comment#5\n12,5,Comment#6\n13,5,Comment#7\n14,5,Comment#8\n15,5,Comment#9\n16,6,Comment#10\n17,6,Comment#11\n18,6,Comment#12\n19,6,Comment#13\n20,6,Comment#14\n21,6,Comment#15\n";
    }

    @Test
    public void testTypeConversionMapperCustomToTuple() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<CollectionDataSets.CustomType> ds = CollectionDataSets.getCustomTypeDataSet(env);
        MapOperator typeConversionMapDs = ds.map((MapFunction)new Mapper3());
        typeConversionMapDs.writeAsCsv(this.resultPath);
        env.execute();
        this.expected = "1,0,Hi\n2,1,Hello\n2,2,Hello world\n3,3,Hello world, how are you?\n3,4,I am fine.\n3,5,Luke Skywalker\n4,6,Comment#1\n4,7,Comment#2\n4,8,Comment#3\n4,9,Comment#4\n5,10,Comment#5\n5,11,Comment#6\n5,12,Comment#7\n5,13,Comment#8\n5,14,Comment#9\n6,15,Comment#10\n6,16,Comment#11\n6,17,Comment#12\n6,18,Comment#13\n6,19,Comment#14\n6,20,Comment#15\n";
    }

    @Test
    public void testTypeConversionMapperTupleToBasic() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
        MapOperator typeConversionMapDs = ds.map((MapFunction)new Mapper4());
        typeConversionMapDs.writeAsText(this.resultPath);
        env.execute();
        this.expected = "Hi\nHello\nHello world\nHello world, how are you?\nI am fine.\nLuke Skywalker\nComment#1\nComment#2\nComment#3\nComment#4\nComment#5\nComment#6\nComment#7\nComment#8\nComment#9\nComment#10\nComment#11\nComment#12\nComment#13\nComment#14\nComment#15\n";
    }

    @Test
    public void testMapperOnTupleIncrementIntegerFieldReorderSecondAndThirdFields() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
        MapOperator tupleMapDs = ds.map((MapFunction)new Mapper5());
        tupleMapDs.writeAsCsv(this.resultPath);
        env.execute();
        this.expected = "2,Hi,1\n3,Hello,2\n4,Hello world,2\n5,Hello world, how are you?,3\n6,I am fine.,3\n7,Luke Skywalker,3\n8,Comment#1,4\n9,Comment#2,4\n10,Comment#3,4\n11,Comment#4,4\n12,Comment#5,5\n13,Comment#6,5\n14,Comment#7,5\n15,Comment#8,5\n16,Comment#9,5\n17,Comment#10,6\n18,Comment#11,6\n19,Comment#12,6\n20,Comment#13,6\n21,Comment#14,6\n22,Comment#15,6\n";
    }

    @Test
    public void testMapperOnCustomLowercaseString() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<CollectionDataSets.CustomType> ds = CollectionDataSets.getCustomTypeDataSet(env);
        MapOperator customMapDs = ds.map((MapFunction)new Mapper6());
        customMapDs.writeAsText(this.resultPath);
        env.execute();
        this.expected = "1,0,hi\n2,1,hello\n2,2,hello world\n3,3,hello world, how are you?\n3,4,i am fine.\n3,5,luke skywalker\n4,6,comment#1\n4,7,comment#2\n4,8,comment#3\n4,9,comment#4\n5,10,comment#5\n5,11,comment#6\n5,12,comment#7\n5,13,comment#8\n5,14,comment#9\n6,15,comment#10\n6,16,comment#11\n6,17,comment#12\n6,18,comment#13\n6,19,comment#14\n6,20,comment#15\n";
    }

    @Test
    public void test() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
        MapOperator inputObjMapDs = ds.map((MapFunction)new Mapper7());
        inputObjMapDs.writeAsCsv(this.resultPath);
        env.execute();
        this.expected = "2,1,Hi\n3,2,Hello\n4,2,Hello world\n5,3,Hello world, how are you?\n6,3,I am fine.\n7,3,Luke Skywalker\n8,4,Comment#1\n9,4,Comment#2\n10,4,Comment#3\n11,4,Comment#4\n12,5,Comment#5\n13,5,Comment#6\n14,5,Comment#7\n15,5,Comment#8\n16,5,Comment#9\n17,6,Comment#10\n18,6,Comment#11\n19,6,Comment#12\n20,6,Comment#13\n21,6,Comment#14\n22,6,Comment#15\n";
    }

    @Test
    public void testMapWithBroadcastSet() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Integer> ints = CollectionDataSets.getIntegerDataSet(env);
        DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
        SingleInputUdfOperator bcMapDs = ds.map((MapFunction)new RichMapper1()).withBroadcastSet(ints, "ints");
        bcMapDs.writeAsCsv(this.resultPath);
        env.execute();
        this.expected = "55,1,Hi\n55,2,Hello\n55,2,Hello world\n55,3,Hello world, how are you?\n55,3,I am fine.\n55,3,Luke Skywalker\n55,4,Comment#1\n55,4,Comment#2\n55,4,Comment#3\n55,4,Comment#4\n55,5,Comment#5\n55,5,Comment#6\n55,5,Comment#7\n55,5,Comment#8\n55,5,Comment#9\n55,6,Comment#10\n55,6,Comment#11\n55,6,Comment#12\n55,6,Comment#13\n55,6,Comment#14\n55,6,Comment#15\n";
    }

    @Test
    public void testPassingConfigurationObject() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.getSmall3TupleDataSet(env);
        Configuration conf = new Configuration();
        conf.setInteger(testKey, 666);
        SingleInputUdfOperator bcMapDs = ds.map((MapFunction)new RichMapper2()).withParameters(conf);
        bcMapDs.writeAsCsv(this.resultPath);
        env.execute();
        this.expected = "1,1,Hi\n2,2,Hello\n3,2,Hello world";
    }

    public static class RichMapper2
    extends RichMapFunction<Tuple3<Integer, Long, String>, Tuple3<Integer, Long, String>> {
        private static final long serialVersionUID = 1L;

        public void open(Configuration config) {
            int val = config.getInteger(MapITCase.testKey, -1);
            Assert.assertEquals((long)666L, (long)val);
        }

        public Tuple3<Integer, Long, String> map(Tuple3<Integer, Long, String> value) {
            return value;
        }
    }

    public static class RichMapper1
    extends RichMapFunction<Tuple3<Integer, Long, String>, Tuple3<Integer, Long, String>> {
        private static final long serialVersionUID = 1L;
        private final Tuple3<Integer, Long, String> out = new Tuple3();
        private Integer f2Replace = 0;

        public void open(Configuration config) {
            List ints = this.getRuntimeContext().getBroadcastVariable("ints");
            int sum = 0;
            for (Integer i : ints) {
                sum += i.intValue();
            }
            this.f2Replace = sum;
        }

        public Tuple3<Integer, Long, String> map(Tuple3<Integer, Long, String> value) throws Exception {
            this.out.setFields((Object)this.f2Replace, value.f1, value.f2);
            return this.out;
        }
    }

    public static class Mapper7
    implements MapFunction<Tuple3<Integer, Long, String>, Tuple3<Integer, Long, String>> {
        private static final long serialVersionUID = 1L;

        public Tuple3<Integer, Long, String> map(Tuple3<Integer, Long, String> value) throws Exception {
            Integer incr = (Integer)value.f0 + 1;
            value.setField((Object)incr, 0);
            return value;
        }
    }

    public static class Mapper6
    implements MapFunction<CollectionDataSets.CustomType, CollectionDataSets.CustomType> {
        private static final long serialVersionUID = 1L;
        private final CollectionDataSets.CustomType out = new CollectionDataSets.CustomType();

        public CollectionDataSets.CustomType map(CollectionDataSets.CustomType value) throws Exception {
            this.out.myInt = value.myInt;
            this.out.myLong = value.myLong;
            this.out.myString = value.myString.toLowerCase();
            return this.out;
        }
    }

    public static class Mapper5
    implements MapFunction<Tuple3<Integer, Long, String>, Tuple3<Integer, String, Long>> {
        private static final long serialVersionUID = 1L;
        private final Tuple3<Integer, String, Long> out = new Tuple3();

        public Tuple3<Integer, String, Long> map(Tuple3<Integer, Long, String> value) throws Exception {
            Integer incr = (Integer)value.f0 + 1;
            this.out.setFields((Object)incr, value.f2, value.f1);
            return this.out;
        }
    }

    public static class Mapper4
    implements MapFunction<Tuple3<Integer, Long, String>, String> {
        private static final long serialVersionUID = 1L;

        public String map(Tuple3<Integer, Long, String> value) throws Exception {
            return (String)value.getField(2);
        }
    }

    public static class Mapper3
    implements MapFunction<CollectionDataSets.CustomType, Tuple3<Integer, Long, String>> {
        private static final long serialVersionUID = 1L;
        private final Tuple3<Integer, Long, String> out = new Tuple3();

        public Tuple3<Integer, Long, String> map(CollectionDataSets.CustomType value) throws Exception {
            this.out.setField((Object)value.myInt, 0);
            this.out.setField((Object)value.myLong, 1);
            this.out.setField((Object)value.myString, 2);
            return this.out;
        }
    }

    public static class Mapper2
    implements MapFunction<Tuple3<Integer, Long, String>, Tuple3<Integer, Long, String>> {
        private static final long serialVersionUID = 1L;

        public Tuple3<Integer, Long, String> map(Tuple3<Integer, Long, String> value) throws Exception {
            return value;
        }
    }

    public static class Mapper1
    implements MapFunction<String, String> {
        private static final long serialVersionUID = 1L;

        public String map(String value) throws Exception {
            return value;
        }
    }
}

