/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.javaApiOperators;

import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.operators.AggregateOperator;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.ProjectOperator;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.test.javaApiOperators.util.CollectionDataSets;
import org.apache.flink.test.util.MultipleProgramsTestBase;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FirstNITCase
extends MultipleProgramsTestBase {
    private String resultPath;
    private String expected;
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    public FirstNITCase(MultipleProgramsTestBase.TestExecutionMode mode) {
        super(mode);
    }

    @Before
    public void before() throws Exception {
        this.resultPath = this.tempFolder.newFile().toURI().toString();
    }

    @After
    public void after() throws Exception {
        FirstNITCase.compareResultsByLinesInMemory((String)this.expected, (String)this.resultPath);
    }

    @Test
    public void testFirstNOnUngroupedDS() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
        AggregateOperator seven = ds.first(7).map((MapFunction)new OneMapper()).sum(0);
        seven.writeAsText(this.resultPath);
        env.execute();
        this.expected = "(7)\n";
    }

    @Test
    public void testFirstNOnGroupedDS() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
        AggregateOperator first = ds.groupBy(new int[]{1}).first(4).map((MapFunction)new OneMapper2()).groupBy(new int[]{0}).sum(1);
        first.writeAsText(this.resultPath);
        env.execute();
        this.expected = "(1,1)\n(2,2)\n(3,3)\n(4,4)\n(5,4)\n(6,4)\n";
    }

    @Test
    public void testFirstNOnGroupedAndSortedDS() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
        ProjectOperator first = ds.groupBy(new int[]{1}).sortGroup(0, Order.DESCENDING).first(3).project(new int[]{1, 0});
        first.writeAsText(this.resultPath);
        env.execute();
        this.expected = "(1,1)\n(2,3)\n(2,2)\n(3,6)\n(3,5)\n(3,4)\n(4,10)\n(4,9)\n(4,8)\n(5,15)\n(5,14)\n(5,13)\n(6,21)\n(6,20)\n(6,19)\n";
    }

    @Test
    public void testFaultyCast() throws Exception {
        ExecutionEnvironment ee = ExecutionEnvironment.getExecutionEnvironment();
        DataSource b = ee.fromElements((Object[])new String[]{"a", "b"});
        GroupReduceOperator a = b.groupBy((KeySelector)new KeySelector<String, Long>(){

            public Long getKey(String value) throws Exception {
                return 1L;
            }
        }).sortGroup((KeySelector)new KeySelector<String, Double>(){

            public Double getKey(String value) throws Exception {
                return 1.0;
            }
        }, Order.DESCENDING).first(1);
        b.writeAsText(this.resultPath);
        ee.execute();
        this.expected = "a\nb";
    }

    public static class OneMapper2
    implements MapFunction<Tuple3<Integer, Long, String>, Tuple2<Long, Integer>> {
        private static final long serialVersionUID = 1L;
        private final Tuple2<Long, Integer> one = new Tuple2((Object)0L, (Object)1);

        public Tuple2<Long, Integer> map(Tuple3<Integer, Long, String> value) {
            this.one.f0 = value.f1;
            return this.one;
        }
    }

    public static class OneMapper
    implements MapFunction<Tuple3<Integer, Long, String>, Tuple1<Integer>> {
        private static final long serialVersionUID = 1L;
        private final Tuple1<Integer> one = new Tuple1((Object)1);

        public Tuple1<Integer> map(Tuple3<Integer, Long, String> value) {
            return this.one;
        }
    }
}

