/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.iterative.nephele.danglingpagerank;

import org.apache.flink.api.common.aggregators.Aggregator;
import org.apache.flink.test.iterative.nephele.danglingpagerank.PageRankStats;

public class PageRankStatsAggregator
implements Aggregator<PageRankStats> {
    private double diff = 0.0;
    private double rank = 0.0;
    private double danglingRank = 0.0;
    private long numDanglingVertices = 0L;
    private long numVertices = 0L;
    private long edges = 0L;
    private double summedRank = 0.0;
    private double finalDiff = 0.0;

    public PageRankStats getAggregate() {
        return new PageRankStats(this.diff, this.rank, this.danglingRank, this.numDanglingVertices, this.numVertices, this.edges, this.summedRank, this.finalDiff);
    }

    public void aggregate(double diffDelta, double rankDelta, double danglingRankDelta, long danglingVerticesDelta, long verticesDelta, long edgesDelta, double summedRankDelta, double finalDiffDelta) {
        this.diff += diffDelta;
        this.rank += rankDelta;
        this.danglingRank += danglingRankDelta;
        this.numDanglingVertices += danglingVerticesDelta;
        this.numVertices += verticesDelta;
        this.edges += edgesDelta;
        this.summedRank += summedRankDelta;
        this.finalDiff += finalDiffDelta;
    }

    public void aggregate(PageRankStats pageRankStats) {
        this.diff += pageRankStats.diff();
        this.rank += pageRankStats.rank();
        this.danglingRank += pageRankStats.danglingRank();
        this.numDanglingVertices += pageRankStats.numDanglingVertices();
        this.numVertices += pageRankStats.numVertices();
        this.edges += pageRankStats.edges();
        this.summedRank += pageRankStats.summedRank();
        this.finalDiff += pageRankStats.finalDiff();
    }

    public void reset() {
        this.diff = 0.0;
        this.rank = 0.0;
        this.danglingRank = 0.0;
        this.numDanglingVertices = 0L;
        this.numVertices = 0L;
        this.edges = 0L;
        this.summedRank = 0.0;
        this.finalDiff = 0.0;
    }
}

