/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.iterative.nephele.customdanglingpagerank.types;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.base.LongComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.test.iterative.nephele.customdanglingpagerank.types.VertexWithRankAndDangling;

public final class VertexWithRankAndDanglingComparator
extends TypeComparator<VertexWithRankAndDangling> {
    private static final long serialVersionUID = 1L;
    private long reference;
    private TypeComparator[] comparators = new TypeComparator[]{new LongComparator(true)};

    public int hash(VertexWithRankAndDangling record) {
        long value = record.getVertexID();
        return 43 + (int)(value ^ value >>> 32);
    }

    public void setReference(VertexWithRankAndDangling toCompare) {
        this.reference = toCompare.getVertexID();
    }

    public boolean equalToReference(VertexWithRankAndDangling candidate) {
        return candidate.getVertexID() == this.reference;
    }

    public int compareToReference(TypeComparator<VertexWithRankAndDangling> referencedComparator) {
        VertexWithRankAndDanglingComparator comp = (VertexWithRankAndDanglingComparator)referencedComparator;
        long diff = comp.reference - this.reference;
        return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
    }

    public int compare(VertexWithRankAndDangling first, VertexWithRankAndDangling second) {
        long diff = first.getVertexID() - second.getVertexID();
        return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
    }

    public int compareSerialized(DataInputView source1, DataInputView source2) throws IOException {
        long diff = source1.readLong() - source2.readLong();
        return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
    }

    public boolean supportsNormalizedKey() {
        return true;
    }

    public int getNormalizeKeyLen() {
        return 8;
    }

    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return keyBytes < 8;
    }

    public void putNormalizedKey(VertexWithRankAndDangling record, MemorySegment target, int offset, int len) {
        block5: {
            long value;
            block4: {
                value = record.getVertexID() - Long.MIN_VALUE;
                if (len != 8) break block4;
                target.putLongBigEndian(offset, value);
                break block5;
            }
            if (len <= 0) break block5;
            if (len < 8) {
                int i = 0;
                while (len > 0) {
                    target.put(offset + i, (byte)(value >>> (3 - i << 3) & 0xFFL));
                    --len;
                    ++i;
                }
            } else {
                target.putLongBigEndian(offset, value);
                for (int i = 8; i < len; ++i) {
                    target.put(offset + i, (byte)0);
                }
            }
        }
    }

    public boolean invertNormalizedKey() {
        return false;
    }

    public boolean supportsSerializationWithKeyNormalization() {
        return true;
    }

    public void writeWithKeyNormalization(VertexWithRankAndDangling record, DataOutputView target) throws IOException {
        target.writeLong(record.getVertexID() - Long.MIN_VALUE);
        target.writeDouble(record.getRank());
        target.writeBoolean(record.isDangling());
    }

    public VertexWithRankAndDangling readWithKeyDenormalization(VertexWithRankAndDangling reuse, DataInputView source) throws IOException {
        reuse.setVertexID(source.readLong() + Long.MIN_VALUE);
        reuse.setRank(source.readDouble());
        reuse.setDangling(source.readBoolean());
        return reuse;
    }

    public VertexWithRankAndDanglingComparator duplicate() {
        return new VertexWithRankAndDanglingComparator();
    }

    public int extractKeys(Object record, Object[] target, int index) {
        target[index] = ((VertexWithRankAndDangling)record).getVertexID();
        return 1;
    }

    public TypeComparator[] getFlatComparators() {
        return this.comparators;
    }
}

