/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.iterative.nephele.customdanglingpagerank.types;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.test.iterative.nephele.customdanglingpagerank.types.VertexWithAdjacencyList;

public final class VertexWithAdjacencyListSerializer
extends TypeSerializerSingleton<VertexWithAdjacencyList> {
    private static final long serialVersionUID = 1L;

    public boolean isImmutableType() {
        return false;
    }

    public VertexWithAdjacencyList createInstance() {
        return new VertexWithAdjacencyList();
    }

    public VertexWithAdjacencyList copy(VertexWithAdjacencyList from) {
        VertexWithAdjacencyList copy = new VertexWithAdjacencyList(from.getVertexID(), new long[from.getNumTargets()]);
        copy.setNumTargets(from.getNumTargets());
        System.arraycopy(from.getTargets(), 0, copy.getTargets(), 0, from.getNumTargets());
        return copy;
    }

    public VertexWithAdjacencyList copy(VertexWithAdjacencyList from, VertexWithAdjacencyList reuse) {
        if (reuse.getTargets().length < from.getTargets().length) {
            reuse.setTargets(new long[from.getTargets().length]);
        }
        reuse.setVertexID(from.getVertexID());
        reuse.setNumTargets(from.getNumTargets());
        System.arraycopy(from.getTargets(), 0, reuse.getTargets(), 0, from.getNumTargets());
        return reuse;
    }

    public int getLength() {
        return -1;
    }

    public void serialize(VertexWithAdjacencyList record, DataOutputView target) throws IOException {
        target.writeLong(record.getVertexID());
        long[] targets = record.getTargets();
        int numTargets = record.getNumTargets();
        target.writeInt(numTargets);
        for (int i = 0; i < numTargets; ++i) {
            target.writeLong(targets[i]);
        }
    }

    public VertexWithAdjacencyList deserialize(DataInputView source) throws IOException {
        return this.deserialize(new VertexWithAdjacencyList(), source);
    }

    public VertexWithAdjacencyList deserialize(VertexWithAdjacencyList target, DataInputView source) throws IOException {
        target.setVertexID(source.readLong());
        int numTargets = source.readInt();
        long[] targets = target.getTargets();
        if (targets.length < numTargets) {
            targets = new long[numTargets];
            target.setTargets(targets);
        }
        target.setNumTargets(numTargets);
        for (int i = 0; i < numTargets; ++i) {
            targets[i] = source.readLong();
        }
        return target;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.write(source, 8);
        int numTargets = source.readInt();
        target.writeInt(numTargets);
        target.write(source, numTargets * 8);
    }
}

