/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.iterative.nephele.customdanglingpagerank;

import org.apache.flink.api.common.io.DelimitedInputFormat;
import org.apache.flink.test.iterative.nephele.customdanglingpagerank.types.VertexWithAdjacencyList;
import org.apache.flink.test.iterative.nephele.danglingpagerank.AsciiLongArrayView;

public class CustomImprovedAdjacencyListInputFormat
extends DelimitedInputFormat<VertexWithAdjacencyList> {
    private static final long serialVersionUID = 1L;
    private final AsciiLongArrayView arrayView = new AsciiLongArrayView();

    public VertexWithAdjacencyList readRecord(VertexWithAdjacencyList target, byte[] bytes, int offset, int numBytes) {
        if (numBytes == 0) {
            return null;
        }
        this.arrayView.set(bytes, offset, numBytes);
        long[] list = target.getTargets();
        try {
            int pos = 0;
            while (this.arrayView.next()) {
                if (pos == 0) {
                    target.setVertexID(this.arrayView.element());
                } else {
                    if (list.length <= pos - 1) {
                        list = new long[list.length < 16 ? 16 : list.length * 2];
                        target.setTargets(list);
                    }
                    list[pos - 1] = this.arrayView.element();
                }
                ++pos;
            }
            target.setNumTargets(pos - 1);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error parsing: " + this.arrayView.toString(), e);
        }
        return target;
    }
}

