/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.iterative.nephele.customdanglingpagerank;

import org.apache.flink.api.common.aggregators.Aggregator;
import org.apache.flink.api.common.aggregators.ConvergenceCriterion;
import org.apache.flink.api.common.operators.util.UserCodeClassWrapper;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.api.common.typeutils.TypeComparatorFactory;
import org.apache.flink.api.common.typeutils.TypePairComparatorFactory;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.iterative.task.IterationHeadPactTask;
import org.apache.flink.runtime.iterative.task.IterationIntermediatePactTask;
import org.apache.flink.runtime.iterative.task.IterationTailPactTask;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.InputFormatVertex;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.OutputFormatVertex;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.operators.BuildSecondCachedMatchDriver;
import org.apache.flink.runtime.operators.CoGroupDriver;
import org.apache.flink.runtime.operators.CollectorMapDriver;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.apache.flink.runtime.operators.util.LocalStrategy;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.apache.flink.test.iterative.nephele.JobGraphUtils;
import org.apache.flink.test.iterative.nephele.customdanglingpagerank.CustomCompensatableDotProductCoGroup;
import org.apache.flink.test.iterative.nephele.customdanglingpagerank.CustomCompensatableDotProductMatch;
import org.apache.flink.test.iterative.nephele.customdanglingpagerank.CustomCompensatingMap;
import org.apache.flink.test.iterative.nephele.customdanglingpagerank.CustomImprovedAdjacencyListInputFormat;
import org.apache.flink.test.iterative.nephele.customdanglingpagerank.CustomImprovedDanglingPageRankInputFormat;
import org.apache.flink.test.iterative.nephele.customdanglingpagerank.CustomPageWithRankOutFormat;
import org.apache.flink.test.iterative.nephele.customdanglingpagerank.types.VertexWithAdjacencyList;
import org.apache.flink.test.iterative.nephele.customdanglingpagerank.types.VertexWithAdjacencyListComparatorFactory;
import org.apache.flink.test.iterative.nephele.customdanglingpagerank.types.VertexWithAdjacencyListSerializerFactory;
import org.apache.flink.test.iterative.nephele.customdanglingpagerank.types.VertexWithRank;
import org.apache.flink.test.iterative.nephele.customdanglingpagerank.types.VertexWithRankAndDangling;
import org.apache.flink.test.iterative.nephele.customdanglingpagerank.types.VertexWithRankAndDanglingComparatorFactory;
import org.apache.flink.test.iterative.nephele.customdanglingpagerank.types.VertexWithRankAndDanglingSerializerFactory;
import org.apache.flink.test.iterative.nephele.customdanglingpagerank.types.VertexWithRankComparatorFactory;
import org.apache.flink.test.iterative.nephele.customdanglingpagerank.types.VertexWithRankDanglingToVertexWithAdjacencyListPairComparatorFactory;
import org.apache.flink.test.iterative.nephele.customdanglingpagerank.types.VertexWithRankDanglingToVertexWithRankPairComparatorFactory;
import org.apache.flink.test.iterative.nephele.customdanglingpagerank.types.VertexWithRankSerializerFactory;
import org.apache.flink.test.iterative.nephele.danglingpagerank.DiffL1NormConvergenceCriterion;
import org.apache.flink.test.iterative.nephele.danglingpagerank.PageRankStatsAggregator;
import org.apache.flink.test.util.TestBaseUtils;

public class CustomCompensatableDanglingPageRank {
    private static final int NUM_FILE_HANDLES_PER_SORT = 64;
    private static final float SORT_SPILL_THRESHOLD = 0.85f;
    private static final int ITERATION_ID = 1;
    private static TypeSerializerFactory<VertexWithRank> vertexWithRankSerializer = new VertexWithRankSerializerFactory();
    private static TypeSerializerFactory<VertexWithRankAndDangling> vertexWithRankAndDanglingSerializer = new VertexWithRankAndDanglingSerializerFactory();
    private static TypeSerializerFactory<VertexWithAdjacencyList> vertexWithAdjacencyListSerializer = new VertexWithAdjacencyListSerializerFactory();
    private static TypeComparatorFactory<VertexWithRank> vertexWithRankComparator = new VertexWithRankComparatorFactory();
    private static TypeComparatorFactory<VertexWithRankAndDangling> vertexWithRankAndDanglingComparator = new VertexWithRankAndDanglingComparatorFactory();
    private static TypeComparatorFactory<VertexWithAdjacencyList> vertexWithAdjacencyListComparator = new VertexWithAdjacencyListComparatorFactory();
    private static TypePairComparatorFactory<VertexWithRankAndDangling, VertexWithAdjacencyList> matchComparator = new VertexWithRankDanglingToVertexWithAdjacencyListPairComparatorFactory();
    private static TypePairComparatorFactory<VertexWithRankAndDangling, VertexWithRank> coGroupComparator = new VertexWithRankDanglingToVertexWithRankPairComparatorFactory();

    public static JobGraph getJobGraph(String[] args) throws Exception {
        int parallelism = 2;
        String pageWithRankInputPath = "";
        String adjacencyListInputPath = "";
        String outputPath = TestBaseUtils.constructTestURI(CustomCompensatableDanglingPageRank.class, (String)"flink_iterations");
        int minorConsumer = 2;
        int matchMemory = 5;
        int coGroupSortMemory = 5;
        int numIterations = 25;
        long numVertices = 5L;
        long numDanglingVertices = 1L;
        String failingWorkers = "1";
        int failingIteration = 2;
        double messageLoss = 0.75;
        if (args.length >= 14) {
            parallelism = Integer.parseInt(args[0]);
            pageWithRankInputPath = args[1];
            adjacencyListInputPath = args[2];
            outputPath = args[3];
            minorConsumer = Integer.parseInt(args[5]);
            matchMemory = Integer.parseInt(args[6]);
            coGroupSortMemory = Integer.parseInt(args[7]);
            numIterations = Integer.parseInt(args[8]);
            numVertices = Long.parseLong(args[9]);
            numDanglingVertices = Long.parseLong(args[10]);
            failingWorkers = args[11];
            failingIteration = Integer.parseInt(args[12]);
            messageLoss = Double.parseDouble(args[13]);
        }
        int totalMemoryConsumption = 3 * minorConsumer + matchMemory + coGroupSortMemory;
        JobGraph jobGraph = new JobGraph("CompensatableDanglingPageRank");
        InputFormatVertex pageWithRankInput = JobGraphUtils.createInput(new CustomImprovedDanglingPageRankInputFormat(), pageWithRankInputPath, "DanglingPageWithRankInput", jobGraph, parallelism);
        TaskConfig pageWithRankInputConfig = new TaskConfig(pageWithRankInput.getConfiguration());
        pageWithRankInputConfig.addOutputShipStrategy(ShipStrategyType.PARTITION_HASH);
        pageWithRankInputConfig.setOutputComparator(vertexWithRankAndDanglingComparator, 0);
        pageWithRankInputConfig.setOutputSerializer(vertexWithRankAndDanglingSerializer);
        pageWithRankInputConfig.setStubParameter("pageRank.numVertices", String.valueOf(numVertices));
        InputFormatVertex adjacencyListInput = JobGraphUtils.createInput(new CustomImprovedAdjacencyListInputFormat(), adjacencyListInputPath, "AdjancencyListInput", jobGraph, parallelism);
        TaskConfig adjacencyListInputConfig = new TaskConfig(adjacencyListInput.getConfiguration());
        adjacencyListInputConfig.addOutputShipStrategy(ShipStrategyType.PARTITION_HASH);
        adjacencyListInputConfig.setOutputSerializer(vertexWithAdjacencyListSerializer);
        adjacencyListInputConfig.setOutputComparator(vertexWithAdjacencyListComparator, 0);
        JobVertex head = JobGraphUtils.createTask(IterationHeadPactTask.class, "IterationHead", jobGraph, parallelism);
        TaskConfig headConfig = new TaskConfig(head.getConfiguration());
        headConfig.setIterationId(1);
        headConfig.addInputToGroup(0);
        headConfig.setIterationHeadPartialSolutionOrWorksetInputIndex(0);
        headConfig.setInputSerializer(vertexWithRankAndDanglingSerializer, 0);
        headConfig.setInputComparator(vertexWithRankAndDanglingComparator, 0);
        headConfig.setInputLocalStrategy(0, LocalStrategy.SORT);
        headConfig.setRelativeMemoryInput(0, (double)minorConsumer / (double)totalMemoryConsumption);
        headConfig.setFilehandlesInput(0, 64);
        headConfig.setSpillingThresholdInput(0, 0.85f);
        headConfig.setRelativeBackChannelMemory((double)minorConsumer / (double)totalMemoryConsumption);
        headConfig.setOutputSerializer(vertexWithRankAndDanglingSerializer);
        headConfig.addOutputShipStrategy(ShipStrategyType.FORWARD);
        headConfig.addOutputShipStrategy(ShipStrategyType.FORWARD);
        TaskConfig headFinalOutConfig = new TaskConfig(new Configuration());
        headFinalOutConfig.setOutputSerializer(vertexWithRankAndDanglingSerializer);
        headFinalOutConfig.addOutputShipStrategy(ShipStrategyType.FORWARD);
        headConfig.setIterationHeadFinalOutputConfig(headFinalOutConfig);
        headConfig.setIterationHeadIndexOfSyncOutput(3);
        headConfig.setNumberOfIterations(numIterations);
        headConfig.setDriver(CollectorMapDriver.class);
        headConfig.setDriverStrategy(DriverStrategy.COLLECTOR_MAP);
        headConfig.setStubWrapper((UserCodeWrapper)new UserCodeClassWrapper(CustomCompensatingMap.class));
        headConfig.setStubParameter("pageRank.numVertices", String.valueOf(numVertices));
        headConfig.setStubParameter("compensation.failingWorker", failingWorkers);
        headConfig.setStubParameter("compensation.failingIteration", String.valueOf(failingIteration));
        headConfig.setStubParameter("compensation.messageLoss", String.valueOf(messageLoss));
        headConfig.addIterationAggregator("pagerank.aggregator", (Aggregator)new PageRankStatsAggregator());
        JobVertex intermediate = JobGraphUtils.createTask(IterationIntermediatePactTask.class, "IterationIntermediate", jobGraph, parallelism);
        TaskConfig intermediateConfig = new TaskConfig(intermediate.getConfiguration());
        intermediateConfig.setIterationId(1);
        intermediateConfig.setDriver(BuildSecondCachedMatchDriver.class);
        intermediateConfig.setDriverStrategy(DriverStrategy.HYBRIDHASH_BUILD_SECOND);
        intermediateConfig.setRelativeMemoryDriver((double)matchMemory / (double)totalMemoryConsumption);
        intermediateConfig.addInputToGroup(0);
        intermediateConfig.addInputToGroup(1);
        intermediateConfig.setInputSerializer(vertexWithRankAndDanglingSerializer, 0);
        intermediateConfig.setInputSerializer(vertexWithAdjacencyListSerializer, 1);
        intermediateConfig.setDriverComparator(vertexWithRankAndDanglingComparator, 0);
        intermediateConfig.setDriverComparator(vertexWithAdjacencyListComparator, 1);
        intermediateConfig.setDriverPairComparator(matchComparator);
        intermediateConfig.setOutputSerializer(vertexWithRankSerializer);
        intermediateConfig.addOutputShipStrategy(ShipStrategyType.PARTITION_HASH);
        intermediateConfig.setOutputComparator(vertexWithRankComparator, 0);
        intermediateConfig.setStubWrapper((UserCodeWrapper)new UserCodeClassWrapper(CustomCompensatableDotProductMatch.class));
        intermediateConfig.setStubParameter("pageRank.numVertices", String.valueOf(numVertices));
        intermediateConfig.setStubParameter("compensation.failingWorker", failingWorkers);
        intermediateConfig.setStubParameter("compensation.failingIteration", String.valueOf(failingIteration));
        intermediateConfig.setStubParameter("compensation.messageLoss", String.valueOf(messageLoss));
        JobVertex tail = JobGraphUtils.createTask(IterationTailPactTask.class, "IterationTail", jobGraph, parallelism);
        TaskConfig tailConfig = new TaskConfig(tail.getConfiguration());
        tailConfig.setIterationId(1);
        tailConfig.setIsWorksetUpdate();
        tailConfig.setDriver(CoGroupDriver.class);
        tailConfig.setDriverStrategy(DriverStrategy.CO_GROUP);
        tailConfig.addInputToGroup(0);
        tailConfig.addInputToGroup(1);
        tailConfig.setInputSerializer(vertexWithRankAndDanglingSerializer, 0);
        tailConfig.setInputSerializer(vertexWithRankSerializer, 1);
        tailConfig.setDriverComparator(vertexWithRankAndDanglingComparator, 0);
        tailConfig.setDriverComparator(vertexWithRankComparator, 1);
        tailConfig.setDriverPairComparator(coGroupComparator);
        tailConfig.setInputAsynchronouslyMaterialized(0, true);
        tailConfig.setRelativeInputMaterializationMemory(0, (double)minorConsumer / (double)totalMemoryConsumption);
        tailConfig.setInputLocalStrategy(1, LocalStrategy.SORT);
        tailConfig.setInputComparator(vertexWithRankComparator, 1);
        tailConfig.setRelativeMemoryInput(1, (double)coGroupSortMemory / (double)totalMemoryConsumption);
        tailConfig.setFilehandlesInput(1, 64);
        tailConfig.setSpillingThresholdInput(1, 0.85f);
        tailConfig.setOutputSerializer(vertexWithRankAndDanglingSerializer);
        tailConfig.setStubWrapper((UserCodeWrapper)new UserCodeClassWrapper(CustomCompensatableDotProductCoGroup.class));
        tailConfig.setStubParameter("pageRank.numVertices", String.valueOf(numVertices));
        tailConfig.setStubParameter("pageRank.numDanglingVertices", String.valueOf(numDanglingVertices));
        tailConfig.setStubParameter("compensation.failingWorker", failingWorkers);
        tailConfig.setStubParameter("compensation.failingIteration", String.valueOf(failingIteration));
        tailConfig.setStubParameter("compensation.messageLoss", String.valueOf(messageLoss));
        OutputFormatVertex output = JobGraphUtils.createFileOutput(jobGraph, "FinalOutput", parallelism);
        TaskConfig outputConfig = new TaskConfig(output.getConfiguration());
        outputConfig.addInputToGroup(0);
        outputConfig.setInputSerializer(vertexWithRankAndDanglingSerializer, 0);
        outputConfig.setStubWrapper((UserCodeWrapper)new UserCodeClassWrapper(CustomPageWithRankOutFormat.class));
        outputConfig.setStubParameter("flink.output.file", outputPath);
        JobVertex sync = JobGraphUtils.createSync(jobGraph, parallelism);
        TaskConfig syncConfig = new TaskConfig(sync.getConfiguration());
        syncConfig.setNumberOfIterations(numIterations);
        syncConfig.addIterationAggregator("pagerank.aggregator", (Aggregator)new PageRankStatsAggregator());
        syncConfig.setConvergenceCriterion("pagerank.aggregator", (ConvergenceCriterion)new DiffL1NormConvergenceCriterion());
        syncConfig.setIterationId(1);
        JobGraphUtils.connect((JobVertex)pageWithRankInput, head, DistributionPattern.ALL_TO_ALL);
        JobGraphUtils.connect(head, intermediate, DistributionPattern.POINTWISE);
        intermediateConfig.setGateIterativeWithNumberOfEventsUntilInterrupt(0, 1);
        JobGraphUtils.connect((JobVertex)adjacencyListInput, intermediate, DistributionPattern.ALL_TO_ALL);
        JobGraphUtils.connect(head, tail, DistributionPattern.POINTWISE);
        JobGraphUtils.connect(intermediate, tail, DistributionPattern.ALL_TO_ALL);
        tailConfig.setGateIterativeWithNumberOfEventsUntilInterrupt(0, 1);
        tailConfig.setGateIterativeWithNumberOfEventsUntilInterrupt(1, parallelism);
        JobGraphUtils.connect(head, (JobVertex)output, DistributionPattern.POINTWISE);
        JobGraphUtils.connect(head, sync, DistributionPattern.POINTWISE);
        SlotSharingGroup sharingGroup = new SlotSharingGroup();
        pageWithRankInput.setSlotSharingGroup(sharingGroup);
        adjacencyListInput.setSlotSharingGroup(sharingGroup);
        head.setSlotSharingGroup(sharingGroup);
        intermediate.setSlotSharingGroup(sharingGroup);
        tail.setSlotSharingGroup(sharingGroup);
        output.setSlotSharingGroup(sharingGroup);
        sync.setSlotSharingGroup(sharingGroup);
        tail.setStrictlyCoLocatedWith(head);
        intermediate.setStrictlyCoLocatedWith(head);
        return jobGraph;
    }
}

