/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.iterative.nephele;

import java.util.Collection;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.operators.util.UserCodeClassWrapper;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.api.common.typeutils.TypeComparatorFactory;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.api.common.typeutils.record.RecordComparatorFactory;
import org.apache.flink.api.common.typeutils.record.RecordSerializerFactory;
import org.apache.flink.api.java.record.functions.MapFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.iterative.task.IterationHeadPactTask;
import org.apache.flink.runtime.iterative.task.IterationTailPactTask;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.InputFormatVertex;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.OutputFormatVertex;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.operators.CollectorMapDriver;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.GroupReduceDriver;
import org.apache.flink.runtime.operators.chaining.ChainedCollectorMapDriver;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.apache.flink.runtime.operators.util.LocalStrategy;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.apache.flink.test.iterative.nephele.JobGraphUtils;
import org.apache.flink.test.recordJobs.kmeans.udfs.CoordVector;
import org.apache.flink.test.recordJobs.kmeans.udfs.PointInFormat;
import org.apache.flink.test.recordJobs.kmeans.udfs.PointOutFormat;
import org.apache.flink.test.util.RecordAPITestBase;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.Record;
import org.apache.flink.types.Value;
import org.apache.flink.util.Collector;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IterationWithChainingNepheleITCase
extends RecordAPITestBase {
    private static final String INPUT_STRING = "0|%d.25|\n1|%d.25|\n";
    private String dataPath;
    private String resultPath;

    public IterationWithChainingNepheleITCase(Configuration config) {
        super(config);
        this.setTaskManagerNumSlots(4);
    }

    protected void preSubmit() throws Exception {
        String initialInput = String.format(INPUT_STRING, 1, 2);
        this.dataPath = this.createTempFile("data_points.txt", initialInput);
        this.resultPath = this.getTempFilePath("result");
    }

    protected void postSubmit() throws Exception {
        int maxIterations = this.config.getInteger("ChainedMapperNepheleITCase#MaxIterations", 1);
        String result = String.format(INPUT_STRING, 1 + maxIterations, 2 + maxIterations);
        IterationWithChainingNepheleITCase.compareResultsByLinesInMemory((String)result, (String)this.resultPath);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConfigurations() {
        Configuration config = new Configuration();
        config.setInteger("ChainedMapperNepheleITCase#NoSubtasks", 4);
        config.setInteger("ChainedMapperNepheleITCase#MaxIterations", 2);
        return IterationWithChainingNepheleITCase.toParameterList((Configuration[])new Configuration[]{config});
    }

    protected JobGraph getJobGraph() throws Exception {
        int numSubTasks = this.config.getInteger("ChainedMapperNepheleITCase#NoSubtasks", 1);
        int maxIterations = this.config.getInteger("ChainedMapperNepheleITCase#MaxIterations", 1);
        return this.getTestJobGraph(this.dataPath, this.resultPath, numSubTasks, maxIterations);
    }

    private JobGraph getTestJobGraph(String inputPath, String outputPath, int numSubTasks, int maxIterations) {
        JobGraph jobGraph = new JobGraph("Iteration Tail with Chaining");
        RecordSerializerFactory serializer = RecordSerializerFactory.get();
        RecordComparatorFactory comparator = new RecordComparatorFactory(new int[]{0}, new Class[]{IntValue.class});
        boolean ITERATION_ID = true;
        InputFormatVertex input = JobGraphUtils.createInput(new PointInFormat(), inputPath, "Input", jobGraph, numSubTasks);
        TaskConfig inputConfig = new TaskConfig(input.getConfiguration());
        inputConfig.setOutputSerializer((TypeSerializerFactory)serializer);
        inputConfig.addOutputShipStrategy(ShipStrategyType.FORWARD);
        JobVertex head = JobGraphUtils.createTask(IterationHeadPactTask.class, "Iteration Head", jobGraph, numSubTasks);
        TaskConfig headConfig = new TaskConfig(head.getConfiguration());
        headConfig.setIterationId(1);
        headConfig.addInputToGroup(0);
        headConfig.setInputSerializer((TypeSerializerFactory)serializer, 0);
        headConfig.setInputLocalStrategy(0, LocalStrategy.NONE);
        headConfig.setIterationHeadPartialSolutionOrWorksetInputIndex(0);
        headConfig.setOutputSerializer((TypeSerializerFactory)serializer);
        headConfig.addOutputShipStrategy(ShipStrategyType.PARTITION_HASH);
        headConfig.setOutputComparator((TypeComparatorFactory)comparator, 0);
        TaskConfig headFinalOutConfig = new TaskConfig(new Configuration());
        headFinalOutConfig.setOutputSerializer((TypeSerializerFactory)serializer);
        headFinalOutConfig.addOutputShipStrategy(ShipStrategyType.FORWARD);
        headConfig.setIterationHeadFinalOutputConfig(headFinalOutConfig);
        headConfig.setIterationHeadIndexOfSyncOutput(2);
        headConfig.setDriver(CollectorMapDriver.class);
        headConfig.setDriverStrategy(DriverStrategy.COLLECTOR_MAP);
        headConfig.setStubWrapper((UserCodeWrapper)new UserCodeClassWrapper(DummyMapper.class));
        headConfig.setRelativeBackChannelMemory(1.0);
        JobVertex tail = JobGraphUtils.createTask(IterationTailPactTask.class, "Chained Iteration Tail", jobGraph, numSubTasks);
        TaskConfig tailConfig = new TaskConfig(tail.getConfiguration());
        tailConfig.setIterationId(1);
        tailConfig.addInputToGroup(0);
        tailConfig.setInputSerializer((TypeSerializerFactory)serializer, 0);
        tailConfig.addOutputShipStrategy(ShipStrategyType.FORWARD);
        tailConfig.setOutputSerializer((TypeSerializerFactory)serializer);
        tailConfig.setDriver(GroupReduceDriver.class);
        tailConfig.setDriverStrategy(DriverStrategy.SORTED_GROUP_REDUCE);
        tailConfig.setDriverComparator((TypeComparatorFactory)comparator, 0);
        tailConfig.setStubWrapper((UserCodeWrapper)new UserCodeClassWrapper(DummyReducer.class));
        TaskConfig chainedMapperConfig = new TaskConfig(new Configuration());
        chainedMapperConfig.setDriverStrategy(DriverStrategy.COLLECTOR_MAP);
        chainedMapperConfig.setStubWrapper((UserCodeWrapper)new UserCodeClassWrapper(IncrementCoordinatesMapper.class));
        chainedMapperConfig.setInputLocalStrategy(0, LocalStrategy.NONE);
        chainedMapperConfig.setInputSerializer((TypeSerializerFactory)serializer, 0);
        chainedMapperConfig.setOutputSerializer((TypeSerializerFactory)serializer);
        chainedMapperConfig.setIsWorksetUpdate();
        tailConfig.addChainedTask(ChainedCollectorMapDriver.class, chainedMapperConfig, "Chained ID Mapper");
        OutputFormatVertex output = JobGraphUtils.createFileOutput(jobGraph, "Output", numSubTasks);
        TaskConfig outputConfig = new TaskConfig(output.getConfiguration());
        outputConfig.addInputToGroup(0);
        outputConfig.setInputSerializer((TypeSerializerFactory)serializer, 0);
        outputConfig.setStubWrapper((UserCodeWrapper)new UserCodeClassWrapper(PointOutFormat.class));
        outputConfig.setStubParameter("flink.output.file", outputPath);
        JobVertex sync = JobGraphUtils.createSync(jobGraph, numSubTasks);
        TaskConfig syncConfig = new TaskConfig(sync.getConfiguration());
        syncConfig.setNumberOfIterations(maxIterations);
        syncConfig.setIterationId(1);
        JobGraphUtils.connect((JobVertex)input, head, DistributionPattern.POINTWISE);
        JobGraphUtils.connect(head, tail, DistributionPattern.ALL_TO_ALL);
        tailConfig.setGateIterativeWithNumberOfEventsUntilInterrupt(0, numSubTasks);
        JobGraphUtils.connect(head, (JobVertex)output, DistributionPattern.POINTWISE);
        JobGraphUtils.connect(head, sync, DistributionPattern.POINTWISE);
        SlotSharingGroup sharingGroup = new SlotSharingGroup();
        input.setSlotSharingGroup(sharingGroup);
        head.setSlotSharingGroup(sharingGroup);
        tail.setSlotSharingGroup(sharingGroup);
        output.setSlotSharingGroup(sharingGroup);
        sync.setSlotSharingGroup(sharingGroup);
        tail.setStrictlyCoLocatedWith(head);
        return jobGraph;
    }

    public static final class IncrementCoordinatesMapper
    extends MapFunction {
        private static final long serialVersionUID = 1L;

        public void map(Record rec, Collector<Record> out) {
            CoordVector coord = (CoordVector)rec.getField(1, CoordVector.class);
            double[] vector = coord.getCoordinates();
            int i = 0;
            while (i < vector.length) {
                int n = i++;
                vector[n] = vector[n] + 1.0;
            }
            rec.setField(1, (Value)coord);
            out.collect((Object)rec);
        }
    }

    public static final class DummyReducer
    implements GroupReduceFunction<Record, Record> {
        private static final long serialVersionUID = 1L;

        public void reduce(Iterable<Record> it, Collector<Record> out) {
            for (Record r : it) {
                out.collect((Object)r);
            }
        }
    }

    public static final class DummyMapper
    extends MapFunction {
        private static final long serialVersionUID = 1L;

        public void map(Record rec, Collector<Record> out) {
            out.collect((Object)rec);
        }
    }
}

