/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.compiler.plandump;

import java.util.List;
import org.apache.flink.api.common.Plan;
import org.apache.flink.optimizer.Optimizer;
import org.apache.flink.optimizer.plandump.PlanJSONDumpGenerator;
import org.apache.flink.test.recordJobs.graph.DeltaPageRankWithInitialDeltas;
import org.apache.flink.test.recordJobs.kmeans.KMeansBroadcast;
import org.apache.flink.test.recordJobs.kmeans.KMeansSingleStep;
import org.apache.flink.test.recordJobs.relational.TPCHQuery3;
import org.apache.flink.test.recordJobs.relational.WebLogAnalysis;
import org.apache.flink.test.recordJobs.wordcount.WordCount;
import org.apache.flink.util.OperatingSystem;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.junit.Assert;
import org.junit.Test;

public class PreviewPlanDumpTest {
    protected static final String IN_FILE = OperatingSystem.isWindows() ? "file:/c:/test/file" : "file:///test/file";
    protected static final String OUT_FILE = OperatingSystem.isWindows() ? "file:/c:/test/output" : "file:///test/output";
    protected static final String[] NO_ARGS = new String[0];

    @Test
    public void dumpWordCount() {
        this.dump(new WordCount().getPlan("4", IN_FILE, OUT_FILE));
        this.dump(new WordCount().getPlan(NO_ARGS));
    }

    @Test
    public void dumpTPCH3() {
        this.dump(new TPCHQuery3().getPlan("4", IN_FILE, IN_FILE, OUT_FILE));
        this.dump(new TPCHQuery3().getPlan(NO_ARGS));
    }

    @Test
    public void dumpKMeans() {
        this.dump(new KMeansSingleStep().getPlan("4", IN_FILE, IN_FILE, OUT_FILE));
        this.dump(new KMeansSingleStep().getPlan(NO_ARGS));
    }

    @Test
    public void dumpWebLogAnalysis() {
        this.dump(new WebLogAnalysis().getPlan("4", IN_FILE, IN_FILE, IN_FILE, OUT_FILE));
        this.dump(new WebLogAnalysis().getPlan(NO_ARGS));
    }

    @Test
    public void dumpBulkIterationKMeans() {
        this.dump(new KMeansBroadcast().getPlan("4", IN_FILE, OUT_FILE));
        this.dump(new KMeansBroadcast().getPlan(NO_ARGS));
    }

    @Test
    public void dumpDeltaPageRank() {
        this.dump(new DeltaPageRankWithInitialDeltas().getPlan("4", IN_FILE, IN_FILE, IN_FILE, OUT_FILE, "10"));
        this.dump(new DeltaPageRankWithInitialDeltas().getPlan(NO_ARGS));
    }

    private void dump(Plan p) {
        try {
            List sinks = Optimizer.createPreOptimizedPlan((Plan)p);
            PlanJSONDumpGenerator dumper = new PlanJSONDumpGenerator();
            String json = dumper.getPactPlanAsJSON(sinks);
            JsonParser parser = new JsonFactory().createJsonParser(json);
            while (parser.nextToken() != null) {
            }
        }
        catch (JsonParseException e) {
            e.printStackTrace();
            Assert.fail((String)("JSON Generator produced malformatted output: " + e.getMessage()));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("An error occurred in the test: " + e.getMessage()));
        }
    }
}

