/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.compiler.examples;

import java.util.Arrays;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.operators.GenericDataSourceBase;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.api.java.record.operators.FileDataSource;
import org.apache.flink.optimizer.plan.NamedChannel;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plan.SingleInputPlanNode;
import org.apache.flink.optimizer.plan.SinkPlanNode;
import org.apache.flink.optimizer.util.CompilerTestBase;
import org.apache.flink.optimizer.util.OperatorResolver;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.apache.flink.runtime.operators.util.LocalStrategy;
import org.apache.flink.test.recordJobs.kmeans.KMeansSingleStep;
import org.junit.Assert;
import org.junit.Test;

public class KMeansSingleStepTest
extends CompilerTestBase {
    private static final String DATAPOINTS = "Data Points";
    private static final String CENTERS = "Centers";
    private static final String MAPPER_NAME = "Find Nearest Centers";
    private static final String REDUCER_NAME = "Recompute Center Positions";
    private static final String SINK = "New Center Positions";
    private final FieldList set0 = new FieldList(0);

    @Test
    public void testCompileKMeansSingleStepWithStats() {
        KMeansSingleStep kmi = new KMeansSingleStep();
        Plan p = kmi.getPlan(String.valueOf(8), IN_FILE, IN_FILE, OUT_FILE, String.valueOf(20));
        p.setExecutionConfig(new ExecutionConfig());
        OperatorResolver cr = KMeansSingleStepTest.getContractResolver((Plan)p);
        FileDataSource pointsSource = (FileDataSource)cr.getNode(DATAPOINTS);
        FileDataSource centersSource = (FileDataSource)cr.getNode(CENTERS);
        this.setSourceStatistics((GenericDataSourceBase)pointsSource, 0x1900000000L, 32.0f);
        this.setSourceStatistics((GenericDataSourceBase)centersSource, 0x100000L, 32.0f);
        OptimizedPlan plan = this.compileWithStats(p);
        this.checkPlan(plan);
    }

    @Test
    public void testCompileKMeansSingleStepWithOutStats() {
        KMeansSingleStep kmi = new KMeansSingleStep();
        Plan p = kmi.getPlan(String.valueOf(8), IN_FILE, IN_FILE, OUT_FILE, String.valueOf(20));
        p.setExecutionConfig(new ExecutionConfig());
        OptimizedPlan plan = this.compileNoStats(p);
        this.checkPlan(plan);
    }

    private void checkPlan(OptimizedPlan plan) {
        CompilerTestBase.OptimizerPlanNodeResolver or = KMeansSingleStepTest.getOptimizerPlanNodeResolver((OptimizedPlan)plan);
        SinkPlanNode sink = (SinkPlanNode)or.getNode(SINK);
        SingleInputPlanNode reducer = (SingleInputPlanNode)or.getNode(REDUCER_NAME);
        SingleInputPlanNode combiner = (SingleInputPlanNode)reducer.getPredecessor();
        SingleInputPlanNode mapper = (SingleInputPlanNode)or.getNode(MAPPER_NAME);
        Assert.assertEquals((long)1L, (long)mapper.getBroadcastInputs().size());
        Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)mapper.getInput().getShipStrategy());
        Assert.assertEquals((Object)ShipStrategyType.BROADCAST, (Object)((NamedChannel)mapper.getBroadcastInputs().get(0)).getShipStrategy());
        Assert.assertEquals((Object)LocalStrategy.NONE, (Object)mapper.getInput().getLocalStrategy());
        Assert.assertEquals((Object)LocalStrategy.NONE, (Object)((NamedChannel)mapper.getBroadcastInputs().get(0)).getLocalStrategy());
        Assert.assertEquals((Object)DriverStrategy.COLLECTOR_MAP, (Object)mapper.getDriverStrategy());
        Assert.assertNull((Object)mapper.getInput().getLocalStrategyKeys());
        Assert.assertNull((Object)mapper.getInput().getLocalStrategySortOrder());
        Assert.assertNull((Object)((NamedChannel)mapper.getBroadcastInputs().get(0)).getLocalStrategyKeys());
        Assert.assertNull((Object)((NamedChannel)mapper.getBroadcastInputs().get(0)).getLocalStrategySortOrder());
        Assert.assertNotNull((Object)combiner);
        Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)combiner.getInput().getShipStrategy());
        Assert.assertEquals((Object)LocalStrategy.NONE, (Object)combiner.getInput().getLocalStrategy());
        Assert.assertEquals((Object)DriverStrategy.SORTED_GROUP_COMBINE, (Object)combiner.getDriverStrategy());
        Assert.assertNull((Object)combiner.getInput().getLocalStrategyKeys());
        Assert.assertNull((Object)combiner.getInput().getLocalStrategySortOrder());
        Assert.assertEquals((Object)this.set0, (Object)combiner.getKeys(0));
        Assert.assertEquals((Object)this.set0, (Object)combiner.getKeys(1));
        Assert.assertEquals((Object)ShipStrategyType.PARTITION_HASH, (Object)reducer.getInput().getShipStrategy());
        Assert.assertEquals((Object)LocalStrategy.COMBININGSORT, (Object)reducer.getInput().getLocalStrategy());
        Assert.assertEquals((Object)DriverStrategy.SORTED_GROUP_REDUCE, (Object)reducer.getDriverStrategy());
        Assert.assertEquals((Object)this.set0, (Object)reducer.getKeys(0));
        Assert.assertEquals((Object)this.set0, (Object)reducer.getInput().getLocalStrategyKeys());
        Assert.assertTrue((boolean)Arrays.equals(reducer.getInput().getLocalStrategySortOrder(), reducer.getSortOrders(0)));
        Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)sink.getInput().getShipStrategy());
        Assert.assertEquals((Object)LocalStrategy.NONE, (Object)sink.getInput().getLocalStrategy());
    }
}

