/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.operators;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.operators.FlatMapITCase$;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.util.CollectionDataSets;
import org.apache.flink.api.scala.util.CollectionDataSets$;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.test.util.MultipleProgramsTestBase;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.util.Collector;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.Buffer;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005Ub\u0001B\u0001\u0003\u0001=\u0011QB\u00127bi6\u000b\u0007/\u0013+DCN,'BA\u0002\u0005\u0003%y\u0007/\u001a:bi>\u00148O\u0003\u0002\u0006\r\u0005)1oY1mC*\u0011q\u0001C\u0001\u0004CBL'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#Yi\u0011A\u0005\u0006\u0003'Q\tA!\u001e;jY*\u0011Q\u0003C\u0001\u0005i\u0016\u001cH/\u0003\u0002\u0018%\tAR*\u001e7uSBdW\r\u0015:pOJ\fWn\u001d+fgR\u0014\u0015m]3\t\u0011e\u0001!\u0011!Q\u0001\ni\tA!\\8eKB\u00111d\u000b\b\u00039%r!!\b\u0015\u000f\u0005y9cBA\u0010'\u001d\t\u0001SE\u0004\u0002\"I5\t!E\u0003\u0002$\u001d\u00051AH]8pizJ\u0011!D\u0005\u0003\u00171I!!\u0003\u0006\n\u0005UA\u0011BA\n\u0015\u0013\tQ##\u0001\rNk2$\u0018\u000e\u001d7f!J|wM]1ngR+7\u000f\u001e\"bg\u0016L!\u0001L\u0017\u0003#Q+7\u000f^#yK\u000e,H/[8o\u001b>$WM\u0003\u0002+%!)q\u0006\u0001C\u0001a\u00051A(\u001b8jiz\"\"!M\u001a\u0011\u0005I\u0002Q\"\u0001\u0002\t\u000beq\u0003\u0019\u0001\u000e\t\u000fU\u0002\u0001\u0019!C\u0005m\u0005Q!/Z:vYR\u0004\u0016\r\u001e5\u0016\u0003]\u0002\"\u0001O\u001f\u000f\u0005eZT\"\u0001\u001e\u000b\u0003\u0015I!\u0001\u0010\u001e\u0002\rA\u0013X\rZ3g\u0013\tqtH\u0001\u0004TiJLgn\u001a\u0006\u0003yiBq!\u0011\u0001A\u0002\u0013%!)\u0001\bsKN,H\u000e\u001e)bi\"|F%Z9\u0015\u0005\r3\u0005CA\u001dE\u0013\t)%H\u0001\u0003V]&$\bbB$A\u0003\u0003\u0005\raN\u0001\u0004q\u0012\n\u0004BB%\u0001A\u0003&q'A\u0006sKN,H\u000e\u001e)bi\"\u0004\u0003bB&\u0001\u0001\u0004%IAN\u0001\tKb\u0004Xm\u0019;fI\"9Q\n\u0001a\u0001\n\u0013q\u0015\u0001D3ya\u0016\u001cG/\u001a3`I\u0015\fHCA\"P\u0011\u001d9E*!AA\u0002]Ba!\u0015\u0001!B\u00139\u0014!C3ya\u0016\u001cG/\u001a3!\u0011\u001d\u0019\u0006A1A\u0005\nQ\u000b1b\u0018;f[B4u\u000e\u001c3feV\tQ\u000b\u0005\u0002W76\tqK\u0003\u0002Y3\u0006)!/\u001e7fg*\u0011!\fD\u0001\u0006UVt\u0017\u000e^\u0005\u00039^\u0013q\u0002V3na>\u0014\u0018M]=G_2$WM\u001d\u0005\u0007=\u0002\u0001\u000b\u0011B+\u0002\u0019}#X-\u001c9G_2$WM\u001d\u0011\t\u000b\u0001\u0004A\u0011\u0001+\u0002\u0015Q,W\u000e\u001d$pY\u0012,'\u000f\u000b\u0002`EB\u00111\rZ\u0007\u00023&\u0011Q-\u0017\u0002\u0005%VdW\rC\u0003h\u0001\u0011\u0005\u0001.\u0001\u0004cK\u001a|'/\u001a\u000b\u0002\u0007\"\u0012aM\u001b\t\u0003G.L!\u0001\\-\u0003\r\t+gm\u001c:f\u0011\u0015q\u0007\u0001\"\u0001i\u0003\u0015\tg\r^3sQ\ti\u0007\u000f\u0005\u0002dc&\u0011!/\u0017\u0002\u0006\u0003\u001a$XM\u001d\u0005\u0006i\u0002!\t\u0001[\u0001\u0016i\u0016\u001cHOT8o!\u0006\u001c8/\u001b8h\r2\fG/T1qQ\t\u0019h\u000f\u0005\u0002do&\u0011\u00010\u0017\u0002\u0005)\u0016\u001cH\u000fC\u0003{\u0001\u0011\u0005\u0001.\u0001\u000euKN$H)\u0019;b\tV\u0004H.[2bi&twM\u00127bi6\u000b\u0007\u000f\u000b\u0002zm\")Q\u0010\u0001C\u0001Q\u0006YC/Z:u\r2\fG/T1q/&$\bNV1ss&twMT;nE\u0016\u0014xJZ#nSR$X\r\u001a+va2,7\u000f\u000b\u0002}m\"1\u0011\u0011\u0001\u0001\u0005\u0002!\f\u0011\u0006^3tiRK\b/Z\"p]Z,'o]5p]\u001ac\u0017\r^'baB,'oQ;ti>lGk\u001c+va2,\u0007FA@w\u0011\u0019\t9\u0001\u0001C\u0001Q\u0006AC/Z:u)f\u0004XmQ8om\u0016\u00148/[8o\r2\fG/T1qa\u0016\u0014H+\u001e9mKR{')Y:jG\"\u001a\u0011Q\u0001<\t\r\u00055\u0001\u0001\"\u0001i\u0003\u0005#Xm\u001d;GY\u0006$X*\u00199qKJLe-\u0016#G%\u0016$XO\u001d8t\u0013:\u0004X\u000f^(cU\u0016\u001cG/T;mi&\u0004H.\u001a+j[\u0016\u001cx\u000b[5mK\u000eC\u0017M\\4j]\u001eLE\u000fK\u0002\u0002\fYDa!a\u0005\u0001\t\u0003A\u0017a\u0007;fgR4E.\u0019;NCB<\u0016\u000e\u001e5Ce>\fGmY1tiN+G\u000fK\u0002\u0002\u0012YDs\u0001AA\r\u0003K\t9\u0003\u0005\u0003\u0002\u001c\u0005\u0005RBAA\u000f\u0015\r\ty\"W\u0001\u0007eVtg.\u001a:\n\t\u0005\r\u0012Q\u0004\u0002\b%Vtw+\u001b;i\u0003\u00151\u0018\r\\;fG\t\tI\u0003\u0005\u0003\u0002,\u0005ERBAA\u0017\u0015\r\ty#W\u0001\beVtg.\u001a:t\u0013\u0011\t\u0019$!\f\u0003\u001bA\u000b'/Y7fi\u0016\u0014\u0018N_3e\u0001")
public class FlatMapITCase
extends MultipleProgramsTestBase {
    private String resultPath = null;
    private String expected = null;
    private final TemporaryFolder _tempFolder = new TemporaryFolder();

    private String resultPath() {
        return this.resultPath;
    }

    private void resultPath_$eq(String x$1) {
        this.resultPath = x$1;
    }

    private String expected() {
        return this.expected;
    }

    private void expected_$eq(String x$1) {
        this.expected = x$1;
    }

    private TemporaryFolder _tempFolder() {
        return this._tempFolder;
    }

    @Rule
    public TemporaryFolder tempFolder() {
        return this._tempFolder();
    }

    @Before
    public void before() {
        this.resultPath_$eq(this.tempFolder().newFile().toURI().toString());
    }

    @After
    public void after() {
        TestBaseUtils.compareResultsByLinesInMemory((String)this.expected(), (String)this.resultPath());
    }

    @Test
    public void testNonPassingFlatMap() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<String> ds = CollectionDataSets$.MODULE$.getStringDataSet(env);
        DataSet nonPassingFlatMapDs = ds.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<String> apply(String in) {
                return in.contains("banana") ? Option$.MODULE$.option2Iterable((Option)new Some((Object)in)) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
        }, (TypeInformation)BasicTypeInfo.getInfoFor(String.class), ClassTag$.MODULE$.apply(String.class));
        nonPassingFlatMapDs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("\n");
    }

    @Test
    public void testDataDuplicatingFlatMap() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<String> ds = CollectionDataSets$.MODULE$.getStringDataSet(env);
        DataSet duplicatingFlatMapDs = ds.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(String in) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{in, in.toUpperCase()}));
            }
        }, (TypeInformation)BasicTypeInfo.getInfoFor(String.class), ClassTag$.MODULE$.apply(String.class));
        duplicatingFlatMapDs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("Hi\nHI\nHello\nHELLO\nHello world\nHELLO WORLD\nHello world, how are you?\nHELLO WORLD, HOW ARE YOU?\nI am fine.\nI AM FINE.\nLuke Skywalker\nLUKE SKYWALKER\nRandom comment\nRANDOM COMMENT\nLOL\nLOL\n");
    }

    @Test
    public void testFlatMapWithVaryingNumberOfEmittedTuples() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet varyingTuplesMapDs = ds.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final IndexedSeq<Tuple3<Object, Object, String>> apply(Tuple3<Object, Object, String> in) {
                int numTuples = BoxesRunTime.unboxToInt((Object)in._1()) % 3;
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numTuples).map((Function1)new Serializable(this, in){
                    public static final long serialVersionUID = 0L;
                    private final Tuple3 in$1;

                    public final Tuple3<Object, Object, String> apply(int i) {
                        return this.in$1;
                    }
                    {
                        this.in$1 = in$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
        }, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public TypeInformation<?>[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public Class<Tuple3<Object, Object, String>> protected$tupleType($anon$8 x$1) {
                return x$1.tupleType;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$8 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class));
        String x$1 = this.resultPath();
        FileSystem.WriteMode x$2 = FileSystem.WriteMode.OVERWRITE;
        String x$3 = varyingTuplesMapDs.writeAsCsv$default$2();
        String x$4 = varyingTuplesMapDs.writeAsCsv$default$3();
        varyingTuplesMapDs.writeAsCsv(x$1, x$3, x$4, x$2);
        env.execute();
        this.expected_$eq("1,1,Hi\n2,2,Hello\n2,2,Hello\n4,3,Hello world, how are you?\n5,3,I am fine.\n5,3,I am fine.\n7,4,Comment#1\n8,4,Comment#2\n8,4,Comment#2\n10,4,Comment#4\n11,5,Comment#5\n11,5,Comment#5\n13,5,Comment#7\n14,5,Comment#8\n14,5,Comment#8\n16,6,Comment#10\n17,6,Comment#11\n17,6,Comment#11\n19,6,Comment#13\n20,6,Comment#14\n20,6,Comment#14\n");
    }

    @Test
    public void testTypeConversionFlatMapperCustomToTuple() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<CollectionDataSets.CustomType> ds = CollectionDataSets$.MODULE$.getCustomTypeDataSet(env);
        DataSet typeConversionFlatMapDs = ds.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Tuple3<Object, Object, String>> apply(CollectionDataSets.CustomType in) {
                return Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)in.myInt()), (Object)BoxesRunTime.boxToLong((long)in.myLong()), (Object)in.myString())));
            }
        }, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, String>>(this){

            public TypeInformation<?>[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public Class<Tuple3<Object, Object, String>> protected$tupleType($anon$9 x$1) {
                return x$1.tupleType;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$9 $outer;
                    private final ExecutionConfig executionConfig$2;
                    private final TypeSerializer[] fieldSerializers$2;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionConfig$2 = executionConfig$2;
                        this.fieldSerializers$2 = fieldSerializers$2;
                    }
                });
                return new CaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class));
        String x$5 = this.resultPath();
        FileSystem.WriteMode x$6 = FileSystem.WriteMode.OVERWRITE;
        String x$7 = typeConversionFlatMapDs.writeAsCsv$default$2();
        String x$8 = typeConversionFlatMapDs.writeAsCsv$default$3();
        typeConversionFlatMapDs.writeAsCsv(x$5, x$7, x$8, x$6);
        env.execute();
        this.expected_$eq("1,0,Hi\n2,1,Hello\n2,2,Hello world\n3,3,Hello world, how are you?\n3,4,I am fine.\n3,5,Luke Skywalker\n4,6,Comment#1\n4,7,Comment#2\n4,8,Comment#3\n4,9,Comment#4\n5,10,Comment#5\n5,11,Comment#6\n5,12,Comment#7\n5,13,Comment#8\n5,14,Comment#9\n6,15,Comment#10\n6,16,Comment#11\n6,17,Comment#12\n6,18,Comment#13\n6,19,Comment#14\n6,20,Comment#15\n");
    }

    @Test
    public void testTypeConversionFlatMapperTupleToBasic() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet typeConversionFlatMapDs = ds.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<String> apply(Tuple3<Object, Object, String> in) {
                return Option$.MODULE$.option2Iterable((Option)new Some(in._3()));
            }
        }, (TypeInformation)BasicTypeInfo.getInfoFor(String.class), ClassTag$.MODULE$.apply(String.class));
        typeConversionFlatMapDs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("Hi\nHello\nHello world\nHello world, how are you?\nI am fine.\nLuke Skywalker\nComment#1\nComment#2\nComment#3\nComment#4\nComment#5\nComment#6\nComment#7\nComment#8\nComment#9\nComment#10\nComment#11\nComment#12\nComment#13\nComment#14\nComment#15\n");
    }

    @Test
    public void testFlatMapperIfUDFReturnsInputObjectMultipleTimesWhileChangingIt() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final CollectionDataSets.MutableTuple3<Object, Object, String> apply(Tuple3<Object, Object, String> t) {
                return new CollectionDataSets.MutableTuple3<Object, Object, Object>(t._1(), t._2(), t._3());
            }
        }, (TypeInformation)new CaseClassTypeInfo<CollectionDataSets.MutableTuple3<Object, Object, String>>(this){

            public TypeInformation<?>[] protected$types($anon$10 x$1) {
                return x$1.types;
            }

            public Class<CollectionDataSets.MutableTuple3<Object, Object, String>> protected$tupleType($anon$10 x$1) {
                return x$1.tupleType;
            }

            public TypeSerializer<CollectionDataSets.MutableTuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$10 $outer;
                    private final ExecutionConfig executionConfig$3;
                    private final TypeSerializer[] fieldSerializers$3;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$3[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$3);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionConfig$3 = executionConfig$3;
                        this.fieldSerializers$3 = fieldSerializers$3;
                    }
                });
                return new CaseClassSerializer<CollectionDataSets.MutableTuple3<Object, Object, String>>(this, fieldSerializers){

                    public CollectionDataSets.MutableTuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new CollectionDataSets.MutableTuple3<Object, Object, String>(BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (String)fields[2]);
                    }
                };
            }
        }, ClassTag$.MODULE$.apply(CollectionDataSets.MutableTuple3.class));
        DataSet inputObjFlatMapDs = ds.flatMap((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(CollectionDataSets.MutableTuple3<Object, Object, String> in, Collector<CollectionDataSets.MutableTuple3<Object, Object, String>> out) {
                int numTuples = BoxesRunTime.unboxToInt((Object)in._1()) % 4;
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numTuples).foreach$mVc$sp((Function1)new Serializable(this, in, out){
                    public static final long serialVersionUID = 0L;
                    private final CollectionDataSets.MutableTuple3 in$2;
                    private final Collector out$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.in$2._1_$eq(BoxesRunTime.boxToInteger((int)i));
                        this.out$1.collect((Object)this.in$2);
                    }
                    {
                        this.in$2 = in$2;
                        this.out$1 = out$1;
                    }
                });
            }
        }, (TypeInformation)new CaseClassTypeInfo<CollectionDataSets.MutableTuple3<Object, Object, String>>(this){

            public TypeInformation<?>[] protected$types($anon$11 x$1) {
                return x$1.types;
            }

            public Class<CollectionDataSets.MutableTuple3<Object, Object, String>> protected$tupleType($anon$11 x$1) {
                return x$1.tupleType;
            }

            public TypeSerializer<CollectionDataSets.MutableTuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$11 $outer;
                    private final ExecutionConfig executionConfig$4;
                    private final TypeSerializer[] fieldSerializers$4;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$4[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$4);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionConfig$4 = executionConfig$4;
                        this.fieldSerializers$4 = fieldSerializers$4;
                    }
                });
                return new CaseClassSerializer<CollectionDataSets.MutableTuple3<Object, Object, String>>(this, fieldSerializers){

                    public CollectionDataSets.MutableTuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new CollectionDataSets.MutableTuple3<Object, Object, String>(BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (String)fields[2]);
                    }
                };
            }
        }, ClassTag$.MODULE$.apply(CollectionDataSets.MutableTuple3.class));
        String x$9 = this.resultPath();
        FileSystem.WriteMode x$10 = FileSystem.WriteMode.OVERWRITE;
        String x$11 = inputObjFlatMapDs.writeAsCsv$default$2();
        String x$12 = inputObjFlatMapDs.writeAsCsv$default$3();
        inputObjFlatMapDs.writeAsCsv(x$9, x$11, x$12, x$10);
        env.execute();
        this.expected_$eq("0,1,Hi\n0,2,Hello\n1,2,Hello\n0,2,Hello world\n1,2,Hello world\n2,2,Hello world\n0,3,I am fine.\n0,3,Luke Skywalker\n1,3,Luke Skywalker\n0,4,Comment#1\n1,4,Comment#1\n2,4,Comment#1\n0,4,Comment#3\n0,4,Comment#4\n1,4,Comment#4\n0,5,Comment#5\n1,5,Comment#5\n2,5,Comment#5\n0,5,Comment#7\n0,5,Comment#8\n1,5,Comment#8\n0,5,Comment#9\n1,5,Comment#9\n2,5,Comment#9\n0,6,Comment#11\n0,6,Comment#12\n1,6,Comment#12\n0,6,Comment#13\n1,6,Comment#13\n2,6,Comment#13\n0,6,Comment#15\n");
    }

    @Test
    public void testFlatMapWithBroadcastSet() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Object> ints = CollectionDataSets$.MODULE$.getIntDataSet(env);
        DataSet ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final CollectionDataSets.MutableTuple3<Object, Object, String> apply(Tuple3<Object, Object, String> t) {
                return new CollectionDataSets.MutableTuple3<Object, Object, Object>(t._1(), t._2(), t._3());
            }
        }, (TypeInformation)new CaseClassTypeInfo<CollectionDataSets.MutableTuple3<Object, Object, String>>(this){

            public TypeInformation<?>[] protected$types($anon$12 x$1) {
                return x$1.types;
            }

            public Class<CollectionDataSets.MutableTuple3<Object, Object, String>> protected$tupleType($anon$12 x$1) {
                return x$1.tupleType;
            }

            public TypeSerializer<CollectionDataSets.MutableTuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$12 $outer;
                    private final ExecutionConfig executionConfig$5;
                    private final TypeSerializer[] fieldSerializers$5;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$5[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$5);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionConfig$5 = executionConfig$5;
                        this.fieldSerializers$5 = fieldSerializers$5;
                    }
                });
                return new CaseClassSerializer<CollectionDataSets.MutableTuple3<Object, Object, String>>(this, fieldSerializers){

                    public CollectionDataSets.MutableTuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new CollectionDataSets.MutableTuple3<Object, Object, String>(BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (String)fields[2]);
                    }
                };
            }
        }, ClassTag$.MODULE$.apply(CollectionDataSets.MutableTuple3.class));
        DataSet bcFlatMapDs = ds.flatMap((FlatMapFunction)new RichFlatMapFunction<CollectionDataSets.MutableTuple3<Object, Object, String>, CollectionDataSets.MutableTuple3<Object, Object, String>>(this){
            private int f2Replace;
            private final CollectionDataSets.MutableTuple3<Object, Object, String> outTuple;

            private int f2Replace() {
                return this.f2Replace;
            }

            private void f2Replace_$eq(int x$1) {
                this.f2Replace = x$1;
            }

            private CollectionDataSets.MutableTuple3<Object, Object, String> outTuple() {
                return this.outTuple;
            }

            public void open(Configuration config) {
                Buffer ints = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.getRuntimeContext().getBroadcastVariable("ints")).asScala();
                this.f2Replace_$eq(BoxesRunTime.unboxToInt((Object)ints.sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
            }

            public void flatMap(CollectionDataSets.MutableTuple3<Object, Object, String> value, Collector<CollectionDataSets.MutableTuple3<Object, Object, String>> out) {
                this.outTuple()._1_$eq(BoxesRunTime.boxToInteger((int)this.f2Replace()));
                this.outTuple()._2_$eq(value._2());
                this.outTuple()._3_$eq(value._3());
                out.collect(this.outTuple());
            }
            {
                this.f2Replace = 0;
                this.outTuple = new CollectionDataSets.MutableTuple3<Integer, Long, String>(BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToLong((long)0L), "");
            }
        }, (TypeInformation)new CaseClassTypeInfo<CollectionDataSets.MutableTuple3<Object, Object, String>>(this){

            public TypeInformation<?>[] protected$types($anon$13 x$1) {
                return x$1.types;
            }

            public Class<CollectionDataSets.MutableTuple3<Object, Object, String>> protected$tupleType($anon$13 x$1) {
                return x$1.tupleType;
            }

            public TypeSerializer<CollectionDataSets.MutableTuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$13 $outer;
                    private final ExecutionConfig executionConfig$6;
                    private final TypeSerializer[] fieldSerializers$6;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$6[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$6);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionConfig$6 = executionConfig$6;
                        this.fieldSerializers$6 = fieldSerializers$6;
                    }
                });
                return new CaseClassSerializer<CollectionDataSets.MutableTuple3<Object, Object, String>>(this, fieldSerializers){

                    public CollectionDataSets.MutableTuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new CollectionDataSets.MutableTuple3<Object, Object, String>(BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (String)fields[2]);
                    }
                };
            }
        }, ClassTag$.MODULE$.apply(CollectionDataSets.MutableTuple3.class)).withBroadcastSet(ints, "ints");
        String x$13 = this.resultPath();
        FileSystem.WriteMode x$14 = FileSystem.WriteMode.OVERWRITE;
        String x$15 = bcFlatMapDs.writeAsCsv$default$2();
        String x$16 = bcFlatMapDs.writeAsCsv$default$3();
        bcFlatMapDs.writeAsCsv(x$13, x$15, x$16, x$14);
        env.execute();
        this.expected_$eq("55,1,Hi\n55,2,Hello\n55,2,Hello world\n55,3,Hello world, how are you?\n55,3,I am fine.\n55,3,Luke Skywalker\n55,4,Comment#1\n55,4,Comment#2\n55,4,Comment#3\n55,4,Comment#4\n55,5,Comment#5\n55,5,Comment#6\n55,5,Comment#7\n55,5,Comment#8\n55,5,Comment#9\n55,6,Comment#10\n55,6,Comment#11\n55,6,Comment#12\n55,6,Comment#13\n55,6,Comment#14\n55,6,Comment#15\n");
    }

    public FlatMapITCase(MultipleProgramsTestBase.TestExecutionMode mode) {
        super(mode);
    }
}

