/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.runtime.minicluster;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.testkit.JavaTestKit;
import com.typesafe.config.Config;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.messages.JobManagerMessages;
import org.apache.flink.runtime.minicluster.LocalFlinkMiniCluster;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class LocalFlinkMiniClusterITCase {
    static ActorSystem system;

    @BeforeClass
    public static void setup() {
        system = ActorSystem.create((String)"Testkit", (Config)AkkaUtils.getDefaultAkkaConfig());
    }

    @AfterClass
    public static void teardown() {
        JavaTestKit.shutdownActorSystem((ActorSystem)system);
        system = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalFlinkMiniClusterWithMultipleTaskManagers() {
        LocalFlinkMiniCluster miniCluster = null;
        int numTMs = 3;
        int numSlots = 14;
        try {
            Configuration config = new Configuration();
            config.setInteger("localinstancemanager.numtaskmanager", 3);
            config.setInteger("taskmanager.numberOfTaskSlots", 14);
            miniCluster = new LocalFlinkMiniCluster(config, true);
            final ActorRef jm = miniCluster.getJobManager();
            new JavaTestKit(system){
                {
                    super(x0);
                    new JavaTestKit.Within(TestingUtils.TESTING_DURATION()){

                        protected void run() {
                            jm.tell(JobManagerMessages.getRequestNumberRegisteredTaskManager(), this.getRef());
                            this.expectMsgEquals(TestingUtils.TESTING_DURATION(), 3);
                            jm.tell(JobManagerMessages.getRequestTotalNumberOfSlots(), this.getRef());
                            this.expectMsgEquals(TestingUtils.TESTING_DURATION(), 42);
                        }
                    };
                }
            };
        }
        finally {
            if (miniCluster != null) {
                miniCluster.stop();
            }
        }
    }
}

