/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.runtime;

import java.io.IOException;
import java.util.Random;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.io.GenericInputFormat;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.io.NonParallelInput;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.test.util.JavaProgramTestBase;
import org.apache.flink.util.Collector;
import org.junit.Rule;
import org.junit.rules.Timeout;

public class SelfJoinDeadlockITCase
extends JavaProgramTestBase {
    protected String resultPath;
    @Rule
    public Timeout globalTimeout = new Timeout(120000);

    protected void preSubmit() throws Exception {
        this.resultPath = this.getTempDirPath("result");
    }

    protected void testProgram() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds = env.createInput((InputFormat)new LargeJoinDataGeneratorInputFormat(1000000));
        ds.join((DataSet)ds).where(new int[]{0}).equalTo(new int[]{1}).with((FlatJoinFunction)new Joiner()).writeAsText(this.resultPath);
        env.execute("Local Selfjoin Test Job");
    }

    private static class LargeJoinDataGeneratorInputFormat
    extends GenericInputFormat<Tuple3<Integer, Integer, String>>
    implements NonParallelInput {
        private static final long serialVersionUID = 1L;
        private final Random rand = new Random(42L);
        private final int toProduce;
        private int produced;

        public LargeJoinDataGeneratorInputFormat(int toProduce) {
            this.toProduce = toProduce;
        }

        public boolean reachedEnd() throws IOException {
            return this.produced >= this.toProduce;
        }

        public Tuple3<Integer, Integer, String> nextRecord(Tuple3<Integer, Integer, String> reuse) throws IOException {
            ++this.produced;
            return new Tuple3((Object)this.rand.nextInt(this.toProduce), (Object)this.rand.nextInt(this.toProduce), (Object)"aaa");
        }
    }

    public static class Joiner
    implements FlatJoinFunction<Tuple3<Integer, Integer, String>, Tuple3<Integer, Integer, String>, Tuple5<Integer, Integer, Integer, String, String>> {
        public void join(Tuple3<Integer, Integer, String> in1, Tuple3<Integer, Integer, String> in2, Collector<Tuple5<Integer, Integer, Integer, String, String>> out) throws Exception {
            out.collect((Object)new Tuple5(in1.f0, in1.f1, in2.f1, in1.f2, in2.f2));
        }
    }
}

