/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.recordJobs.relational.query1Util;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.io.network.api.writer.RecordWriter;
import org.apache.flink.runtime.operators.shipping.RecordOutputCollector;
import org.apache.flink.test.recordJobs.relational.query1Util.LineItemFilter;
import org.apache.flink.test.recordJobs.util.Tuple;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.Record;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.Value;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class LineItemFilterTest {
    private static final String RETURN_FLAG = "N";
    @Mock
    RecordWriter<Record> recordWriterMock;
    private List<RecordWriter<Record>> writerList = new ArrayList<RecordWriter<Record>>();

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.writerList.add(this.recordWriterMock);
    }

    @Test
    public void shouldNotFilterTuple() throws Exception, InterruptedException {
        LineItemFilter out = new LineItemFilter();
        String shipDate = "1996-03-13";
        Tuple input = this.createInputTuple(shipDate);
        IntValue inputKey = new IntValue();
        Record rec = new Record();
        rec.setField(0, (Value)inputKey);
        rec.setField(1, (Value)input);
        RecordOutputCollector collector = new RecordOutputCollector(this.writerList);
        StringValue returnFlag = new StringValue((CharSequence)RETURN_FLAG);
        out.map(rec, (Collector<Record>)collector);
        ArgumentCaptor argument = ArgumentCaptor.forClass(Record.class);
        ((RecordWriter)Mockito.verify(this.recordWriterMock)).emit((IOReadableWritable)argument.capture());
        Assert.assertEquals((Object)returnFlag, (Object)((Record)argument.getValue()).getField(0, StringValue.class));
        Assert.assertEquals((Object)input, (Object)((Record)argument.getValue()).getField(1, Record.class));
    }

    @Test
    public void shouldFilterTuple() throws Exception, InterruptedException {
        LineItemFilter out = new LineItemFilter();
        String shipDate = "1999-03-13";
        Tuple input = this.createInputTuple(shipDate);
        IntValue inputKey = new IntValue();
        Record rec = new Record();
        rec.setField(0, (Value)inputKey);
        rec.setField(1, (Value)input);
        RecordOutputCollector collector = new RecordOutputCollector(this.writerList);
        out.map(rec, (Collector<Record>)collector);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.recordWriterMock});
    }

    @Test
    public void shouldNotThrowExceptionWhenNullTuple() throws Exception {
        LineItemFilter out = new LineItemFilter();
        Value input = null;
        IntValue inputKey = new IntValue();
        Record rec = new Record();
        rec.setField(0, (Value)inputKey);
        rec.setField(1, input);
        RecordOutputCollector collector = new RecordOutputCollector(this.writerList);
        out.map(rec, (Collector<Record>)collector);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.recordWriterMock});
    }

    @Test
    public void shouldNoThrowExceptionOnMalformedDate() throws Exception, InterruptedException {
        LineItemFilter out = new LineItemFilter();
        String shipDate = "foobarDate";
        Tuple input = this.createInputTuple(shipDate);
        IntValue inputKey = new IntValue();
        Record rec = new Record();
        rec.setField(0, (Value)inputKey);
        rec.setField(1, (Value)input);
        RecordOutputCollector collector = new RecordOutputCollector(this.writerList);
        out.map(rec, (Collector<Record>)collector);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.recordWriterMock});
    }

    @Test
    public void shouldNoThrowExceptionOnTooShortTuple() throws Exception, InterruptedException {
        LineItemFilter out = new LineItemFilter();
        Tuple input = new Tuple();
        input.addAttribute("1");
        input.addAttribute("155190");
        input.addAttribute("7706");
        input.addAttribute("1");
        input.addAttribute("17");
        input.addAttribute("21168.23");
        input.addAttribute("0.04");
        input.addAttribute("0.02");
        input.addAttribute(RETURN_FLAG);
        input.addAttribute("0");
        IntValue inputKey = new IntValue();
        Record rec = new Record();
        rec.setField(0, (Value)inputKey);
        rec.setField(1, (Value)input);
        RecordOutputCollector collector = new RecordOutputCollector(this.writerList);
        out.map(rec, (Collector<Record>)collector);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.recordWriterMock});
    }

    private Tuple createInputTuple(String shipDate) {
        Tuple input = new Tuple();
        input.addAttribute("1");
        input.addAttribute("155190");
        input.addAttribute("7706");
        input.addAttribute("1");
        input.addAttribute("17");
        input.addAttribute("21168.23");
        input.addAttribute("0.04");
        input.addAttribute("0.02");
        input.addAttribute(RETURN_FLAG);
        input.addAttribute("0");
        input.addAttribute(shipDate);
        return input;
    }
}

