/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.recordJobs.relational.query1Util;

import java.util.Iterator;
import org.apache.flink.api.java.record.functions.ReduceFunction;
import org.apache.flink.test.recordJobs.util.Tuple;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.Record;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.Value;
import org.apache.flink.util.Collector;

public class GroupByReturnFlag
extends ReduceFunction {
    private static final long serialVersionUID = 1L;

    public void reduce(Iterator<Record> records, Collector<Record> out) throws Exception {
        Record outRecord = new Record();
        Tuple returnTuple = new Tuple();
        long quantity = 0L;
        double extendedPriceSum = 0.0;
        boolean first = true;
        while (records.hasNext()) {
            Record rec = records.next();
            Tuple t = (Tuple)rec.getField(1, Tuple.class);
            if (first) {
                first = false;
                rec.copyTo(outRecord);
                returnTuple.addAttribute(((StringValue)rec.getField(0, StringValue.class)).toString());
            }
            long tupleQuantity = Long.parseLong(t.getStringValueAt(4));
            quantity += tupleQuantity;
            double extendedPricePerTuple = Double.parseDouble(t.getStringValueAt(5));
            extendedPriceSum += extendedPricePerTuple;
        }
        LongValue pactQuantity = new LongValue(quantity);
        returnTuple.addAttribute("" + pactQuantity);
        returnTuple.addAttribute("" + extendedPriceSum);
        outRecord.setField(1, (Value)returnTuple);
        out.collect((Object)outRecord);
    }
}

